/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.content;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.painter.decoration.DecorationException;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.background.IBackground;
import com.alee.painter.decoration.content.AbstractContent;
import com.alee.utils.CollectionUtils;
import com.alee.utils.GraphicsUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import java.util.List;
import javax.swing.JComponent;

@XStreamAlias(value="RoundRectangle")
public class RoundRectangle<C extends JComponent, D extends IDecoration<C, D>, I extends RoundRectangle<C, D, I>>
extends AbstractContent<C, D, I> {
    @XStreamAsAttribute
    @Nullable
    protected Integer round;
    @XStreamImplicit
    @Nullable
    protected List<IBackground> backgrounds;

    @Override
    @NotNull
    public String getId() {
        return this.id != null ? this.id : "background";
    }

    protected int getRound(@NotNull C c, @NotNull D d) {
        return this.round != null ? this.round : 0;
    }

    @NotNull
    public List<IBackground> getBackgrounds() {
        if (CollectionUtils.isEmpty(this.backgrounds)) {
            throw new DecorationException("At least one Background must be specified");
        }
        return this.backgrounds;
    }

    @Override
    public boolean isEmpty(@NotNull C c, @NotNull D d) {
        return false;
    }

    @Override
    protected void paintContent(@NotNull Graphics2D g2d, @NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        int round = this.getRound(c, d);
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(bounds.x, bounds.y, bounds.width, bounds.height, round, round);
        for (IBackground background : this.getBackgrounds()) {
            background.paint(g2d, bounds, c, d, shape);
        }
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    @Override
    @NotNull
    protected Dimension getContentPreferredSize(@NotNull C c, @NotNull D d, @NotNull Dimension available) {
        Insets padding = this.getPadding(c, d);
        int round = this.getRound(c, d);
        int phor = padding != null ? padding.left + padding.right : 0;
        int pver = padding != null ? padding.top + padding.bottom : 0;
        int w = Math.max(phor, round * 2);
        int h = Math.max(pver, round * 2);
        return new Dimension(w, h);
    }
}

