/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.layout;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.content.IContent;
import com.alee.painter.decoration.layout.AbstractContentLayout;
import com.alee.painter.decoration.layout.ContentLayoutData;
import com.alee.utils.collection.ImmutableList;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;

@XStreamAlias(value="AlignLayout")
public class AlignLayout<C extends JComponent, D extends IDecoration<C, D>, I extends AlignLayout<C, D, I>>
extends AbstractContentLayout<C, D, I> {
    protected static final String LEFT = "left";
    protected static final String RIGHT = "right";
    protected static final String TOP = "top";
    protected static final String BOTTOM = "bottom";
    protected static final String CENTER = "center";
    public static final List<String> horizontals = new ImmutableList((Object[])new String[]{"left", "center", "right"});
    public static final List<String> verticals = new ImmutableList((Object[])new String[]{"top", "center", "bottom"});
    public static final String SEPARATOR = ",";
    @XStreamAsAttribute
    @Nullable
    protected Integer hgap;
    @XStreamAsAttribute
    @Nullable
    protected Integer vgap;
    @XStreamAsAttribute
    @Nullable
    protected Boolean hfill;
    @XStreamAsAttribute
    @Nullable
    protected Boolean vfill;

    public int getHorizontalGap(@NotNull C c, @NotNull D d) {
        return this.hgap != null ? this.hgap : 0;
    }

    public int getVerticalGap(@NotNull C c, @NotNull D d) {
        return this.vgap != null ? this.vgap : 0;
    }

    public boolean isHorizontalFill(@NotNull C c, @NotNull D d) {
        return this.hfill != null && this.hfill != false;
    }

    public boolean isVerticalFill(@NotNull C c, @NotNull D d) {
        return this.vfill != null && this.vfill != false;
    }

    @Override
    @NotNull
    public ContentLayoutData layoutContent(@NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        ContentLayoutData layoutData = new ContentLayoutData(2);
        boolean hfill = this.isHorizontalFill(c, d);
        boolean vfill = this.isVerticalFill(c, d);
        for (String halign : horizontals) {
            for (String valign : verticals) {
                int y;
                int x;
                String constraints = this.constraints(halign, valign);
                if (this.isEmpty(c, d, constraints)) continue;
                Dimension ps = this.getPreferredSize(c, d, bounds.getSize(), constraints);
                ps.width = Math.min(ps.width, bounds.width);
                ps.height = Math.min(ps.height, bounds.height);
                if (hfill) {
                    x = bounds.x;
                } else if (halign.equals(LEFT)) {
                    x = bounds.x;
                } else if (halign.equals(CENTER)) {
                    x = bounds.x + bounds.width / 2 - ps.width / 2;
                } else if (halign.equals(RIGHT)) {
                    x = bounds.x + bounds.width - ps.width;
                } else {
                    throw new IllegalArgumentException("Unknown horizontal alignment: " + halign);
                }
                if (vfill) {
                    y = bounds.y;
                } else if (valign.equals(TOP)) {
                    y = bounds.y;
                } else if (valign.equals(CENTER)) {
                    y = bounds.y + bounds.height / 2 - ps.height / 2;
                } else if (valign.equals(BOTTOM)) {
                    y = bounds.y + bounds.height - ps.height;
                } else {
                    throw new IllegalArgumentException("Unknown vertical alignment: " + valign);
                }
                int width = hfill ? bounds.width : ps.width;
                int height = vfill ? bounds.height : ps.height;
                layoutData.put(constraints, new Rectangle(x, y, width, height));
            }
        }
        return layoutData;
    }

    @Override
    @NotNull
    protected Dimension getContentPreferredSize(@NotNull C c, @NotNull D d, @NotNull Dimension available) {
        Dimension ps;
        List<IContent> contents = this.getContents(c, d);
        if (contents.size() > 1) {
            int hgap = this.getHorizontalGap(c, d);
            int vgap = this.getVerticalGap(c, d);
            boolean hfill = this.isHorizontalFill(c, d);
            boolean vfill = this.isVerticalFill(c, d);
            HashMap<String, Integer> widths = new HashMap<String, Integer>();
            HashMap<String, Integer> heights = new HashMap<String, Integer>();
            if (!hfill || !vfill) {
                for (String halign : horizontals) {
                    for (String valign : verticals) {
                        Dimension size = this.getAreaSize(c, d, available, halign, valign);
                        if (size == null) continue;
                        if (!hfill) {
                            int width = widths.containsKey(halign) ? (Integer)widths.get(halign) : 0;
                            widths.put(halign, Math.max(width, size.width));
                        }
                        if (vfill) continue;
                        int height = widths.containsKey(valign) ? (Integer)widths.get(valign) : 0;
                        heights.put(valign, Math.max(height, size.height));
                    }
                }
            }
            ps = new Dimension(0, 0);
            if (hfill) {
                ps.width = this.maxWidth(c, d, available, contents);
            } else {
                for (Integer width : widths.values()) {
                    ps.width = ps.width + (ps.width > 0 ? hgap + width : width);
                }
            }
            if (vfill) {
                ps.height = this.maxHeight(c, d, available, contents);
            } else {
                for (Integer height : heights.values()) {
                    ps.height = ps.height + (ps.height > 0 ? vgap + height : height);
                }
            }
        } else {
            ps = contents.size() == 1 ? contents.get(0).getPreferredSize(c, d, available) : new Dimension(0, 0);
        }
        return ps;
    }

    @Nullable
    protected Dimension getAreaSize(@NotNull C c, @NotNull D d, @NotNull Dimension available, @NotNull String horizontal, @NotNull String vertical) {
        Dimension size = new Dimension(0, 0);
        for (IContent content : this.getContents(c, d, this.constraints(horizontal, vertical))) {
            Dimension preferredSize = content.getPreferredSize(c, d, available);
            size.width = Math.max(size.width, preferredSize.width);
            size.height = Math.max(size.height, preferredSize.height);
        }
        return size.width > 0 || size.height > 0 ? size : null;
    }

    protected int maxWidth(@NotNull C c, @NotNull D d, @NotNull Dimension available, @NotNull List<IContent> contents) {
        int max = 0;
        for (IContent content : contents) {
            max = Math.max(max, content.getPreferredSize(c, d, (Dimension)available).width);
        }
        return max;
    }

    protected int maxHeight(@NotNull C c, @NotNull D d, @NotNull Dimension available, @NotNull List<IContent> contents) {
        int max = 0;
        for (IContent content : contents) {
            max = Math.max(max, content.getPreferredSize(c, d, (Dimension)available).height);
        }
        return max;
    }

    @NotNull
    protected String constraints(@NotNull String horizontal, @NotNull String vertical) {
        return horizontal + SEPARATOR + vertical;
    }
}

