/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.shape;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Supplier;
import com.alee.laf.grouping.GroupingLayout;
import com.alee.painter.decoration.AbstractDecoration;
import com.alee.painter.decoration.WebDecoration;
import com.alee.painter.decoration.border.BorderWidth;
import com.alee.painter.decoration.shadow.ShadowType;
import com.alee.painter.decoration.shape.AbstractShape;
import com.alee.painter.decoration.shape.IPartialShape;
import com.alee.painter.decoration.shape.Round;
import com.alee.painter.decoration.shape.ShapeType;
import com.alee.painter.decoration.shape.Sides;
import com.alee.painter.decoration.shape.StretchInfo;
import com.alee.utils.MathUtils;
import com.alee.utils.ShapeUtils;
import com.alee.utils.general.Pair;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;

@XStreamAlias(value="WebShape")
public class WebShape<C extends JComponent, D extends WebDecoration<C, D>, I extends WebShape<C, D, I>>
extends AbstractShape<C, D, I>
implements IPartialShape<C, D, I> {
    @XStreamAsAttribute
    @Nullable
    protected Round round;
    @XStreamAsAttribute
    @Nullable
    protected String sides;
    @XStreamAsAttribute
    @Nullable
    protected String lines;

    @NotNull
    public Round getRound(@NotNull C c, @NotNull D d) {
        return this.round != null ? this.round : new Round();
    }

    @Nullable
    protected GroupingLayout getGroupingLayout(@NotNull C c, @NotNull D d) {
        LayoutManager layout;
        GroupingLayout groupingLayout = null;
        Container parent = ((Component)c).getParent();
        if (parent != null && (layout = parent.getLayout()) instanceof GroupingLayout) {
            groupingLayout = (GroupingLayout)layout;
        }
        return groupingLayout;
    }

    @Nullable
    protected String getSides(@NotNull C c, @NotNull D d) {
        GroupingLayout layout;
        String sides = ((AbstractDecoration)d).isSection() ? this.sides : ((layout = this.getGroupingLayout(c, d)) != null ? layout.getSides((Component)c) : this.sides);
        return sides;
    }

    @Override
    public boolean isPaintTop(@NotNull C c, @NotNull D d) {
        String sides = this.getSides(c, d);
        return sides == null || sides.charAt(0) != '0';
    }

    @Override
    public boolean isPaintLeft(@NotNull C c, @NotNull D d) {
        String sides = this.getSides(c, d);
        return sides == null || sides.charAt(2) != '0';
    }

    @Override
    public boolean isPaintBottom(@NotNull C c, @NotNull D d) {
        String sides = this.getSides(c, d);
        return sides == null || sides.charAt(4) != '0';
    }

    @Override
    public boolean isPaintRight(@NotNull C c, @NotNull D d) {
        String sides = this.getSides(c, d);
        return sides == null || sides.charAt(6) != '0';
    }

    public boolean isAnySide(@NotNull C c, @NotNull D d) {
        String sides = this.getSides(c, d);
        return sides == null || sides.contains("1");
    }

    @Nullable
    protected String getLines(@NotNull C c, @NotNull D d) {
        GroupingLayout layout;
        String lines = ((AbstractDecoration)d).isSection() ? this.lines : ((layout = this.getGroupingLayout(c, d)) != null ? layout.getLines((Component)c) : this.lines);
        return lines;
    }

    @Override
    public boolean isPaintTopLine(@NotNull C c, @NotNull D d) {
        String lines = this.getLines(c, d);
        return !this.isPaintTop(c, d) && lines != null && lines.charAt(0) == '1';
    }

    @Override
    public boolean isPaintLeftLine(@NotNull C c, @NotNull D d) {
        String lines = this.getLines(c, d);
        return !this.isPaintLeft(c, d) && lines != null && lines.charAt(2) == '1';
    }

    @Override
    public boolean isPaintBottomLine(@NotNull C c, @NotNull D d) {
        String lines = this.getLines(c, d);
        return !this.isPaintBottom(c, d) && lines != null && lines.charAt(4) == '1';
    }

    @Override
    public boolean isPaintRightLine(@NotNull C c, @NotNull D d) {
        String lines = this.getLines(c, d);
        return !this.isPaintRight(c, d) && lines != null && lines.charAt(6) == '1';
    }

    public boolean isAnyLine(@NotNull C c, @NotNull D d) {
        return this.isPaintTopLine(c, d) || this.isPaintLeftLine(c, d) || this.isPaintBottomLine(c, d) || this.isPaintRightLine(c, d);
    }

    protected Sides createSides(@NotNull C c, @NotNull D d) {
        boolean ltr = ((Component)c).getComponentOrientation().isLeftToRight();
        return new Sides(this.isPaintTop(c, d), ltr ? this.isPaintLeft(c, d) : this.isPaintRight(c, d), this.isPaintBottom(c, d), ltr ? this.isPaintRight(c, d) : this.isPaintLeft(c, d));
    }

    @Override
    public boolean isVisible(@NotNull ShapeType type, @NotNull Rectangle bounds, @NotNull C c, @NotNull D d) {
        boolean visible = false;
        int ow = ((WebDecoration)d).getShadowWidth(ShadowType.outer) * 2;
        if (bounds.width - ow > 0 && bounds.height - ow > 0) {
            switch (type) {
                case outerShadow: {
                    visible = this.isAnySide(c, d);
                    break;
                }
                case border: {
                    visible = this.isAnySide(c, d) || this.isAnyLine(c, d);
                    break;
                }
                default: {
                    visible = true;
                }
            }
        }
        return visible;
    }

    @Override
    @NotNull
    public Shape getShape(final @NotNull ShapeType type, final @NotNull Rectangle bounds, @NotNull C c, @NotNull D d) {
        final int sw = ((WebDecoration)d).getShadowWidth(ShadowType.outer);
        final Round round = this.getRound(c, d);
        final Sides sides = this.createSides(c, d);
        return ShapeUtils.getShape(c, "WebShape." + (Object)((Object)type), new Supplier<Shape>(){

            @NotNull
            public Shape get() {
                Shape result = type.isBorder() ? ShapeUtils.createBorderShape(sw, bounds, round, sides) : ShapeUtils.createFillShape(sw, bounds, round, sides, type);
                return result;
            }
        }, new Object[]{bounds, sw, round, sides});
    }

    @Override
    @NotNull
    public Object[] getShapeSettings(@NotNull Rectangle bounds, @NotNull C c, @NotNull D d) {
        return new Object[]{this.getRound(c, d), this.createSides(c, d)};
    }

    @Override
    @NotNull
    public StretchInfo getStretchInfo(@NotNull Rectangle bounds, @NotNull C c, @NotNull D d) {
        int sw = ((WebDecoration)d).getShadowWidth(ShadowType.outer);
        Round r = this.getRound(c, d);
        Sides sides = this.createSides(c, d);
        BorderWidth bw = ((WebDecoration)d).getBorderWidth();
        int isw = ((WebDecoration)d).getShadowWidth(ShadowType.inner);
        int x0 = bounds.x + (sides.left ? sw : 0) + MathUtils.max((int[])new int[]{bw.left, isw, r.topLeft, r.bottomLeft, sw});
        int x1 = bounds.x + bounds.width - 1 - (sides.right ? sw : 0) - MathUtils.max((int[])new int[]{isw, bw.right, r.topRight, r.bottomRight, sw});
        int y0 = bounds.y + (sides.top ? sw : 0) + MathUtils.max((int[])new int[]{bw.top, isw, r.topLeft, r.topRight, sw});
        int y1 = bounds.y + bounds.height - 1 - (sides.bottom ? sw : 0) - MathUtils.max((int[])new int[]{bw.bottom, isw, r.bottomLeft, r.bottomRight, sw});
        return new StretchInfo((Pair<Integer, Integer>)(x0 < x1 ? new Pair((Object)x0, (Object)x1) : null), (Pair<Integer, Integer>)(y0 < y1 ? new Pair((Object)y0, (Object)y1) : null));
    }
}

