/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.extended.inspector.ComponentHighlighter;
import com.alee.managers.style.BoundsType;
import com.alee.utils.ColorUtils;
import com.alee.utils.ExceptionUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.TimeUtils;
import com.alee.utils.UtilityException;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JComponent;

public final class DebugUtils {
    public static final Font DEBUG_FONT = new Font("Dialog", 1, 8);
    public static final NumberFormat DEBUG_FORMAT = new DecimalFormat("#0.00");

    private DebugUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    @NotNull
    public static String getDeadlockStackTrace() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        long[] threadIds = bean.findDeadlockedThreads();
        StringBuilder stackTrace = new StringBuilder();
        if (threadIds != null) {
            ThreadInfo[] infos;
            for (ThreadInfo info : infos = bean.getThreadInfo(threadIds)) {
                StackTraceElement[] stack = info.getStackTrace();
                stackTrace.append(ExceptionUtils.getStackTrace((StackTraceElement[])stack));
                stackTrace.append(info != infos[infos.length - 1] ? "\n" : "");
            }
        }
        return stackTrace.toString();
    }

    public static void initTimeDebugInfo() {
        TimeUtils.pinNanoTime();
    }

    public static void paintTimeDebugInfo(@NotNull Graphics g) {
        DebugUtils.paintDebugInfoImpl((Graphics2D)g);
    }

    public static void paintTimeDebugInfo(@NotNull Graphics2D g2d) {
        DebugUtils.paintDebugInfoImpl(g2d);
    }

    private static void paintDebugInfoImpl(@NotNull Graphics2D g2d) {
        double ms = (float)TimeUtils.getPassedNanoTime() / 1000000.0f;
        String micro = "" + DEBUG_FORMAT.format(ms);
        Rectangle cb = g2d.getClip().getBounds();
        Font font = g2d.getFont();
        g2d.setFont(DEBUG_FONT);
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        FontMetrics fm = g2d.getFontMetrics();
        int w = fm.stringWidth(micro) + 4;
        int h = fm.getHeight();
        g2d.setPaint(Color.BLACK);
        g2d.fillRect(cb.x + cb.width - w, cb.y, w, h);
        g2d.setPaint(Color.WHITE);
        g2d.drawString(micro, cb.x + cb.width - w + 2, cb.y + h - fm.getDescent());
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
        g2d.setFont(font);
    }

    public static void paintBorderDebugInfo(@NotNull Graphics g, @NotNull JComponent c) {
        Insets padding;
        Insets border;
        Rectangle bounds = new Rectangle(0, 0, c.getWidth() - 1, c.getHeight() - 1);
        g.setColor(ColorUtils.opaque((Color)ComponentHighlighter.marginColor));
        g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
        Insets margin = BoundsType.margin.insets(c);
        if (!SwingUtils.isEmpty(margin)) {
            bounds = SwingUtils.shrink(bounds, margin);
            g.setColor(ColorUtils.opaque((Color)ComponentHighlighter.borderColor));
            g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        if (!SwingUtils.isEmpty(border = BoundsType.border.insets(c))) {
            bounds = SwingUtils.shrink(bounds, border);
            g.setColor(ColorUtils.opaque((Color)ComponentHighlighter.paddingColor));
            g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        if (!SwingUtils.isEmpty(padding = BoundsType.padding.insets(c))) {
            bounds = SwingUtils.shrink(bounds, padding);
            g.setColor(ColorUtils.opaque((Color)ComponentHighlighter.contentColor));
            g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    public static void paintBaselineDebugInfo(@NotNull Graphics g, @NotNull JComponent c) {
        DebugUtils.paintBaselineDebugInfo(g, c, Color.RED);
    }

    public static void paintBaselineDebugInfo(@NotNull Graphics g, @NotNull JComponent c, @NotNull Color color) {
        int baseline = c.getBaseline(c.getWidth(), c.getHeight());
        g.setColor(color);
        g.drawLine(0, baseline, c.getWidth() - 1, baseline);
    }
}

