/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.UtilityException;
import com.alee.utils.ninepatch.NinePatchIcon;
import com.alee.utils.ninepatch.NinePatchInterval;
import com.alee.utils.ninepatch.NinePatchIntervalType;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public final class NinePatchUtils {
    private NinePatchUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    @NotNull
    public static List<NinePatchInterval> parseIntervals(@NotNull BufferedImage image, @NotNull NinePatchIntervalType intervalType) {
        boolean hv = intervalType == NinePatchIntervalType.horizontalStretch || intervalType == NinePatchIntervalType.verticalStretch;
        int l = (intervalType == NinePatchIntervalType.horizontalStretch || intervalType == NinePatchIntervalType.horizontalContent ? image.getWidth() : image.getHeight()) - 1;
        ArrayList<NinePatchInterval> intervals = new ArrayList<NinePatchInterval>();
        NinePatchInterval interval = null;
        for (int i = 1; i < l; ++i) {
            boolean pixelPart;
            int rgb;
            switch (intervalType) {
                case horizontalStretch: {
                    rgb = image.getRGB(i, 0);
                    break;
                }
                case verticalStretch: {
                    rgb = image.getRGB(0, i);
                    break;
                }
                case horizontalContent: {
                    rgb = image.getRGB(i, image.getHeight() - 1);
                    break;
                }
                case verticalContent: {
                    rgb = image.getRGB(image.getWidth() - 1, i);
                    break;
                }
                default: {
                    rgb = 0;
                }
            }
            boolean bl = pixelPart = rgb != Color.BLACK.getRGB();
            if (interval == null) {
                interval = new NinePatchInterval(i - 1, i - 1, pixelPart);
                continue;
            }
            if (pixelPart == interval.isPixel()) {
                interval.setEnd(i - 1);
                continue;
            }
            if (hv || !interval.isPixel()) {
                intervals.add(interval);
            }
            interval = new NinePatchInterval(i - 1, i - 1, pixelPart);
        }
        if (interval != null && (hv || !interval.isPixel())) {
            intervals.add(interval);
        }
        return intervals;
    }

    @NotNull
    public static List<NinePatchInterval> parseStretchIntervals(@NotNull boolean[] filled) {
        ArrayList<NinePatchInterval> intervals = new ArrayList<NinePatchInterval>();
        NinePatchInterval interval = null;
        for (int i = 0; i < filled.length; ++i) {
            boolean pixelPart;
            boolean bl = pixelPart = !filled[i];
            if (interval == null) {
                interval = new NinePatchInterval(i, i, pixelPart);
                continue;
            }
            if (pixelPart == interval.isPixel()) {
                interval.setEnd(i);
                continue;
            }
            intervals.add(interval);
            interval = new NinePatchInterval(i, i, pixelPart);
        }
        if (interval != null) {
            intervals.add(interval);
        }
        return intervals;
    }

    @NotNull
    public static NinePatchIcon rotateIcon90CW(@NotNull NinePatchIcon icon) {
        BufferedImage rawImage = ImageUtils.rotateImage90CW((BufferedImage)icon.getRawImage());
        NinePatchIcon rotated = new NinePatchIcon(rawImage, false);
        rotated.setHorizontalStretch(CollectionUtils.copy(icon.getVerticalStretch()));
        rotated.setVerticalStretch(CollectionUtils.copy(icon.getHorizontalStretch()));
        Insets om = icon.getMargin();
        rotated.setMargin(om.left, om.bottom, om.right, om.top);
        return rotated;
    }

    @NotNull
    public static NinePatchIcon rotateIcon90CCW(@NotNull NinePatchIcon icon) {
        BufferedImage rawImage = ImageUtils.rotateImage90CCW((BufferedImage)icon.getRawImage());
        NinePatchIcon rotated = new NinePatchIcon(rawImage, false);
        rotated.setHorizontalStretch(CollectionUtils.copy(icon.getVerticalStretch()));
        rotated.setVerticalStretch(CollectionUtils.copy(icon.getHorizontalStretch()));
        Insets om = icon.getMargin();
        rotated.setMargin(om.right, om.top, om.left, om.bottom);
        return rotated;
    }

    @NotNull
    public static NinePatchIcon rotateIcon180(@NotNull NinePatchIcon icon) {
        BufferedImage rawImage = ImageUtils.rotateImage180((BufferedImage)icon.getRawImage());
        NinePatchIcon rotated = new NinePatchIcon(rawImage, false);
        rotated.setHorizontalStretch(CollectionUtils.copy(icon.getHorizontalStretch()));
        rotated.setVerticalStretch(CollectionUtils.copy(icon.getVerticalStretch()));
        Insets om = icon.getMargin();
        rotated.setMargin(om.bottom, om.right, om.top, om.left);
        return rotated;
    }

    @Deprecated
    @NotNull
    public static NinePatchIcon createShadeIcon(int shadeWidth, int round, float shadeOpacity) {
        int r = round * 2;
        int inner = Math.max(shadeWidth, round);
        int w = shadeWidth * 2 + inner * 2;
        RoundRectangle2D.Double shape = new RoundRectangle2D.Double(shadeWidth, shadeWidth, w - shadeWidth * 2, w - shadeWidth * 2, r, r);
        BufferedImage shade = ImageUtils.createShadowImage((int)w, (int)w, (Shape)shape, (int)shadeWidth, (float)shadeOpacity, (boolean)true);
        NinePatchIcon ninePatchIcon = new NinePatchIcon(shade, false);
        ninePatchIcon.addHorizontalStretch(0, shadeWidth + inner, true);
        ninePatchIcon.addHorizontalStretch(shadeWidth + inner + 1, w - shadeWidth - inner - 1, false);
        ninePatchIcon.addHorizontalStretch(w - shadeWidth - inner, w, true);
        ninePatchIcon.addVerticalStretch(0, shadeWidth + inner, true);
        ninePatchIcon.addVerticalStretch(shadeWidth + inner + 1, w - shadeWidth - inner - 1, false);
        ninePatchIcon.addVerticalStretch(w - shadeWidth - inner, w, true);
        ninePatchIcon.setMargin(shadeWidth);
        return ninePatchIcon;
    }
}

