/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.resource.ClassResource;
import com.alee.api.resource.Resource;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.UtilityException;
import com.alee.utils.ninepatch.NinePatchIcon;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

@Deprecated
public final class SelectorUtils {
    public static int halfButton = 4;
    public static int halfSelector = 2;
    public static int halfLine = 1;
    public static int shadeWidth = 2;
    private static final Map<String, Icon> selectionIconsCache = new HashMap<String, Icon>(10);

    private SelectorUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static void drawWebSelection(Graphics2D g2d, Color color, int x, int y, int width, int height, boolean resizableLR, boolean resizableUD, boolean drawConnectors, boolean drawSideControls) {
        SelectorUtils.drawWebSelection(g2d, color, new Rectangle(x, y, width, height), resizableLR, resizableUD, drawConnectors, drawSideControls);
    }

    public static void drawWebSelection(Graphics2D g2d, Color color, Rectangle selection, boolean resizableLR, boolean resizableUD, boolean drawConnectors) {
        SelectorUtils.drawWebSelection(g2d, color, selection, resizableLR, resizableUD, drawConnectors, true);
    }

    public static void drawWebSelection(Graphics2D g2d, Color color, Rectangle selection, boolean resizableLR, boolean resizableUD, boolean drawConnectors, boolean drawSideControls) {
        selection = SelectorUtils.validateRect(selection);
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        Area buttonsShape = new Area();
        if (resizableUD) {
            if (resizableLR) {
                buttonsShape.add(new Area(new Ellipse2D.Double(selection.x - halfButton, selection.y - halfButton, halfButton * 2, halfButton * 2)));
                buttonsShape.add(new Area(new Ellipse2D.Double(selection.x + selection.width - halfButton, selection.y - halfButton, halfButton * 2, halfButton * 2)));
            }
            if (drawSideControls) {
                buttonsShape.add(new Area(new Ellipse2D.Double(selection.x + selection.width / 2 - halfButton, selection.y - halfButton, halfButton * 2, halfButton * 2)));
            }
        }
        if (resizableLR && drawSideControls) {
            buttonsShape.add(new Area(new Ellipse2D.Double(selection.x - halfButton, selection.y + selection.height / 2 - halfButton, halfButton * 2, halfButton * 2)));
            buttonsShape.add(new Area(new Ellipse2D.Double(selection.x + selection.width - halfButton, selection.y + selection.height / 2 - halfButton, halfButton * 2, halfButton * 2)));
        }
        if (resizableUD) {
            if (resizableLR) {
                buttonsShape.add(new Area(new Ellipse2D.Double(selection.x - halfButton, selection.y + selection.height - halfButton, halfButton * 2, halfButton * 2)));
                buttonsShape.add(new Area(new Ellipse2D.Double(selection.x + selection.width - halfButton, selection.y + selection.height - halfButton, halfButton * 2, halfButton * 2)));
            }
            if (drawSideControls) {
                buttonsShape.add(new Area(new Ellipse2D.Double(selection.x + selection.width / 2 - halfButton, selection.y + selection.height - halfButton, halfButton * 2, halfButton * 2)));
            }
        }
        if (drawConnectors) {
            Area selectionShape = new Area(new RoundRectangle2D.Double(selection.x - halfLine, selection.y - halfLine, selection.width + halfLine * 2, selection.height + halfLine * 2, 5.0, 5.0));
            selectionShape.subtract(new Area(new RoundRectangle2D.Double(selection.x + halfLine, selection.y + halfLine, selection.width - halfLine * 2, selection.height - halfLine * 2, 3.0, 3.0)));
            buttonsShape.add(selectionShape);
        }
        GraphicsUtils.drawShade((Graphics2D)g2d, (Shape)buttonsShape, (Color)Color.GRAY, (int)shadeWidth);
        g2d.setPaint(Color.GRAY);
        g2d.draw(buttonsShape);
        g2d.setPaint(color);
        g2d.fill(buttonsShape);
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    public static void drawWebSelector(Graphics2D g2d, Color color, Rectangle selection, int selector) {
        selection = SelectorUtils.validateRect(selection);
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        Ellipse2D.Double buttonsShape = selector == 8 ? new Ellipse2D.Double(selection.x - halfSelector, selection.y - halfSelector, halfSelector * 2, halfSelector * 2) : (selector == 1 ? new Ellipse2D.Double(selection.x + selection.width / 2 - halfSelector, selection.y - halfSelector, halfSelector * 2, halfSelector * 2) : (selector == 2 ? new Ellipse2D.Double(selection.x + selection.width - halfSelector, selection.y - halfSelector, halfSelector * 2, halfSelector * 2) : (selector == 7 ? new Ellipse2D.Double(selection.x - halfSelector, selection.y + selection.height / 2 - halfSelector, halfSelector * 2, halfSelector * 2) : (selector == 3 ? new Ellipse2D.Double(selection.x + selection.width - halfSelector, selection.y + selection.height / 2 - halfSelector, halfSelector * 2, halfSelector * 2) : (selector == 6 ? new Ellipse2D.Double(selection.x - halfSelector, selection.y + selection.height - halfSelector, halfSelector * 2, halfSelector * 2) : (selector == 5 ? new Ellipse2D.Double(selection.x + selection.width / 2 - halfSelector, selection.y + selection.height - halfSelector, halfSelector * 2, halfSelector * 2) : (selector == 4 ? new Ellipse2D.Double(selection.x + selection.width - halfSelector, selection.y + selection.height - halfSelector, halfSelector * 2, halfSelector * 2) : null)))))));
        g2d.setPaint(color);
        g2d.fill(buttonsShape);
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    private static NinePatchIcon getSelectionIcon(String name) {
        NinePatchIcon icon;
        if (selectionIconsCache.containsKey(name)) {
            icon = (NinePatchIcon)selectionIconsCache.get(name);
        } else {
            icon = new NinePatchIcon((Resource)new ClassResource(LafUtils.class, "icons/selection/" + name + ".9.png"), true);
            selectionIconsCache.put(name, icon);
        }
        return icon;
    }

    private static ImageIcon getGripperIcon() {
        ImageIcon icon;
        String key = "gripper";
        if (selectionIconsCache.containsKey("gripper")) {
            icon = (ImageIcon)selectionIconsCache.get("gripper");
        } else {
            icon = new ImageIcon(LafUtils.class.getResource("icons/selection/gripper.png"));
            selectionIconsCache.put("gripper", icon);
        }
        return icon;
    }

    private static NinePatchIcon getSelectorIcon(int selector) {
        NinePatchIcon icon;
        String key = Integer.toString(selector);
        if (selectionIconsCache.containsKey(key)) {
            icon = (NinePatchIcon)selectionIconsCache.get(key);
        } else {
            icon = new NinePatchIcon((Resource)new ClassResource(LafUtils.class, "icons/selection/selector" + key + ".9.png"), true);
            selectionIconsCache.put(key, icon);
        }
        return icon;
    }

    public static void drawWebIconedSelection(Graphics2D g2d, Rectangle selection, boolean resizableLR, boolean resizableUD, boolean drawConnectors) {
        SelectorUtils.drawWebIconedSelection(g2d, selection, resizableLR, resizableUD, drawConnectors, true);
    }

    public static void drawWebIconedSelection(Graphics2D g2d, Rectangle selection, boolean resizableLR, boolean resizableUD, boolean drawConnectors, boolean drawSideControls) {
        selection = SelectorUtils.validateRect(selection);
        Rectangle rect = SelectorUtils.calculateIconedRect(selection);
        if (drawConnectors) {
            if (!resizableLR && !resizableUD) {
                SelectorUtils.getSelectionIcon("conn").paintIcon(g2d, rect);
            } else if (resizableLR && !resizableUD && drawSideControls) {
                SelectorUtils.getSelectionIcon("lr_conn").paintIcon(g2d, rect);
            } else if (!resizableLR && resizableUD && drawSideControls) {
                SelectorUtils.getSelectionIcon("ud_conn").paintIcon(g2d, rect);
            } else if (resizableLR && resizableUD) {
                if (drawSideControls) {
                    SelectorUtils.getSelectionIcon("full_conn").paintIcon(g2d, rect);
                } else {
                    SelectorUtils.getSelectionIcon("corners_conn").paintIcon(g2d, rect);
                }
            }
        } else if (resizableLR && !resizableUD && drawSideControls) {
            SelectorUtils.getSelectionIcon("lr").paintIcon(g2d, rect);
        } else if (!resizableLR && resizableUD && drawSideControls) {
            SelectorUtils.getSelectionIcon("ud").paintIcon(g2d, rect);
        } else if (resizableLR && resizableUD) {
            if (drawSideControls) {
                SelectorUtils.getSelectionIcon("full").paintIcon(g2d, rect);
            } else {
                SelectorUtils.getSelectionIcon("corners").paintIcon(g2d, rect);
            }
        }
    }

    public static void drawWebIconedSelector(Graphics2D g2d, Rectangle selection, int selector) {
        selection = SelectorUtils.validateRect(selection);
        Rectangle rect = SelectorUtils.calculateIconedRect(selection);
        SelectorUtils.getSelectorIcon(selector).paintIcon(g2d, rect);
    }

    public static void drawWebIconedGripper(Graphics2D g2d, Point point) {
        SelectorUtils.drawWebIconedGripper(g2d, point.x, point.y);
    }

    public static void drawWebIconedGripper(Graphics2D g2d, int x, int y) {
        ImageIcon gripper = SelectorUtils.getGripperIcon();
        g2d.drawImage(gripper.getImage(), x - gripper.getIconWidth() / 2, y - gripper.getIconHeight() / 2, null);
    }

    private static Rectangle calculateIconedRect(Rectangle selection) {
        return new Rectangle(selection.x - halfButton - shadeWidth, selection.y - halfButton - shadeWidth, selection.width + halfButton * 2 + shadeWidth * 2, selection.height + halfButton * 2 + shadeWidth * 2);
    }

    private static Rectangle validateRect(Rectangle rect) {
        Rectangle result;
        if (rect.width >= 0 && rect.height >= 0) {
            result = rect;
        } else {
            int x = rect.x;
            int width = Math.abs(rect.width);
            if (rect.width < 0) {
                x -= width;
            }
            int y = rect.y;
            int height = Math.abs(rect.height);
            if (rect.height < 0) {
                y -= height;
            }
            result = new Rectangle(x, y, width, height);
        }
        return result;
    }
}

