/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.Supplier;
import com.alee.painter.decoration.shape.Round;
import com.alee.painter.decoration.shape.ShapeType;
import com.alee.painter.decoration.shape.Sides;
import com.alee.utils.TextUtils;
import com.alee.utils.UtilityException;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class ShapeUtils {
    private static final Map<Component, Map<String, CachedShape>> shapeCache = new WeakHashMap<Component, Map<String, CachedShape>>();

    private ShapeUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    @NotNull
    public static Shape createBorderShape(int sw, @NotNull Rectangle bounds, @NotNull Round round, @NotNull Sides sides) {
        boolean connect;
        GeneralPath shape = new GeneralPath(0);
        boolean moved = false;
        if (sides.top) {
            shape.moveTo(bounds.x + (sides.left ? sw + round.topLeft : 0), bounds.y + sw);
            if (sides.right) {
                shape.lineTo(bounds.x + bounds.width - sw - round.topRight - 1, bounds.y + sw);
                shape.quadTo(bounds.x + bounds.width - sw - 1, bounds.y + sw, bounds.x + bounds.width - sw - 1, bounds.y + sw + round.topRight);
            } else {
                shape.lineTo(bounds.x + bounds.width - 1, bounds.y + sw);
            }
            connect = true;
        } else {
            connect = false;
        }
        if (sides.right) {
            if (!connect) {
                shape.moveTo(bounds.x + bounds.width - sw - 1, bounds.y);
                moved = true;
            }
            if (sides.bottom) {
                shape.lineTo(bounds.x + bounds.width - sw - 1, bounds.y + bounds.height - sw - round.bottomRight - 1);
                shape.quadTo(bounds.x + bounds.width - sw - 1, bounds.y + bounds.height - sw - 1, bounds.x + bounds.width - sw - round.bottomRight - 1, bounds.y + bounds.height - sw - 1);
            } else {
                shape.lineTo(bounds.x + bounds.width - sw - 1, bounds.y + bounds.height - 1);
            }
            connect = true;
        } else {
            connect = false;
        }
        if (sides.bottom) {
            if (!connect) {
                shape.moveTo(bounds.x + bounds.width - 1, bounds.y + bounds.height - sw - 1);
                moved = true;
            }
            if (sides.left) {
                shape.lineTo(bounds.x + sw + round.bottomLeft, bounds.y + bounds.height - sw - 1);
                shape.quadTo(bounds.x + sw, bounds.y + bounds.height - sw - 1, bounds.x + sw, bounds.y + bounds.height - sw - round.bottomLeft - 1);
            } else {
                shape.lineTo(bounds.x, bounds.y + bounds.height - sw - 1);
            }
            connect = true;
        } else {
            connect = false;
        }
        if (sides.left) {
            if (!connect) {
                shape.moveTo(bounds.x + sw, bounds.y + bounds.height - 1);
                moved = true;
            }
            if (sides.top) {
                shape.lineTo(bounds.x + sw, bounds.y + sw + round.topLeft);
                shape.quadTo(bounds.x + sw, bounds.y + sw, bounds.x + sw + round.topLeft, bounds.y + sw);
                if (!moved) {
                    shape.closePath();
                }
            } else {
                shape.lineTo(bounds.x + sw, bounds.y);
            }
        }
        return shape;
    }

    @NotNull
    public static Shape createFillShape(int sw, @NotNull Rectangle bounds, @NotNull Round round, @NotNull Sides sides, @NotNull ShapeType type) {
        int outerShadowOffset = type.isOuterShadow() ? sw : 0;
        Round r = new Round(round.topLeft + 1, round.topRight + 1, round.bottomRight + 1, round.bottomLeft + 1);
        GeneralPath shape = new GeneralPath(0);
        if (sides.top) {
            shape.moveTo(bounds.x + (sides.left ? sw + r.topLeft : -outerShadowOffset), bounds.y + sw);
            if (sides.right) {
                shape.lineTo(bounds.x + bounds.width - sw - r.topRight, bounds.y + sw);
                shape.quadTo(bounds.x + bounds.width - sw, bounds.y + sw, bounds.x + bounds.width - sw, bounds.y + sw + r.topRight);
            } else {
                shape.lineTo(bounds.x + bounds.width + outerShadowOffset, bounds.y + sw);
            }
        } else {
            shape.moveTo(bounds.x + (sides.left ? sw : -outerShadowOffset), bounds.y - outerShadowOffset);
            shape.lineTo(bounds.x + bounds.width + (sides.right ? -sw : outerShadowOffset), bounds.y - outerShadowOffset);
        }
        if (sides.right) {
            if (sides.bottom) {
                shape.lineTo(bounds.x + bounds.width - sw, bounds.y + bounds.height - sw - r.bottomRight);
                shape.quadTo(bounds.x + bounds.width - sw, bounds.y + bounds.height - sw, bounds.x + bounds.width - sw - r.bottomRight, bounds.y + bounds.height - sw);
            } else {
                shape.lineTo(bounds.x + bounds.width - sw, bounds.y + bounds.height + outerShadowOffset);
            }
        } else {
            shape.lineTo(bounds.x + bounds.width + outerShadowOffset, bounds.y + bounds.height + (sides.bottom ? -sw : outerShadowOffset));
        }
        if (sides.bottom) {
            if (sides.left) {
                shape.lineTo(bounds.x + sw + r.bottomLeft, bounds.y + bounds.height - sw);
                shape.quadTo(bounds.x + sw, bounds.y + bounds.height - sw, bounds.x + sw, bounds.y + bounds.height - sw - r.bottomLeft);
            } else {
                shape.lineTo(bounds.x - outerShadowOffset, bounds.y + bounds.height - sw);
            }
        } else {
            shape.lineTo(bounds.x + (sides.left ? sw : -outerShadowOffset), bounds.y + bounds.height + outerShadowOffset);
        }
        if (sides.left) {
            if (sides.top) {
                shape.lineTo(bounds.x + sw, bounds.y + sw + r.topLeft);
                shape.quadTo(bounds.x + sw, bounds.y + sw, bounds.x + sw + r.topLeft, bounds.y + sw);
            } else {
                shape.lineTo(bounds.x + sw, bounds.y - outerShadowOffset);
            }
        } else {
            shape.lineTo(bounds.x - outerShadowOffset, bounds.y + (sides.top ? sw : -outerShadowOffset));
        }
        return shape;
    }

    @NotNull
    public static <T extends Shape> T getShape(@NotNull Component component, @NotNull String shapeId, @NotNull Supplier<T> shapeSupplier, Object ... settings) {
        Shape shape;
        String settingsKey = TextUtils.getSettingsKey((Object[])settings);
        Map<String, CachedShape> cacheById = shapeCache.get(component);
        if (cacheById == null) {
            shape = (Shape)shapeSupplier.get();
            cacheById = new HashMap<String, CachedShape>(1);
            cacheById.put(shapeId, new CachedShape(settingsKey, shape));
            shapeCache.put(component, cacheById);
        } else {
            CachedShape cachedShape = cacheById.get(shapeId);
            if (cachedShape == null || !cachedShape.key.equals(settingsKey)) {
                shape = (Shape)shapeSupplier.get();
                cacheById.put(shapeId, new CachedShape(settingsKey, shape));
            } else {
                shape = cachedShape.shape;
            }
        }
        return (T)shape;
    }

    private static class CachedShape {
        @NotNull
        public final String key;
        @NotNull
        public final Shape shape;

        public CachedShape(@NotNull String key, @NotNull Shape shape) {
            this.key = key;
            this.shape = shape;
        }
    }
}

