/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.extended.collapsible.WebCollapsiblePane;
import com.alee.extended.date.WebCalendar;
import com.alee.extended.date.WebDateField;
import com.alee.extended.filechooser.WebFileChooserField;
import com.alee.extended.pathfield.WebPathField;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.painter.decoration.content.TextRasterization;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.ProprietaryUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.UtilityException;
import com.alee.utils.collection.ImmutableList;
import com.alee.utils.swing.extensions.SizeMethods;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.FocusManager;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.slf4j.LoggerFactory;

public final class SwingUtils {
    @NotNull
    public static final String HANDLES_ENABLE_STATE = "HANDLES_ENABLE_STATE";
    @NotNull
    public static final Color RENDERING_FIX_COLOR = new Color(231, 157, 94, 0);
    @Nullable
    private static Integer systemShortcutModifier = null;
    @Nullable
    private static JLabel label = null;
    @Nullable
    private static String[] fontNames;
    @Nullable
    private static Font[] fonts;

    private SwingUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static boolean isOpaque(@NotNull Component component) {
        boolean opaque = component instanceof Window ? ProprietaryUtils.isWindowOpaque((Window)component) : component.isOpaque();
        return opaque;
    }

    public static void update(Component component) {
        if (component instanceof JComponent) {
            ((JComponent)component).revalidate();
        } else {
            component.invalidate();
        }
        component.repaint();
    }

    public static void removeFromParent(@Nullable Component component, boolean update) {
        Container parent;
        if (component != null && (parent = component.getParent()) != null) {
            parent.remove(component);
            if (update) {
                SwingUtils.update(parent);
            }
        }
    }

    public static boolean isEmpty(@NotNull JTextComponent component) {
        Document document = component.getDocument();
        return document == null || document.getLength() == 0;
    }

    public static boolean isEmpty(@Nullable Insets insets) {
        return insets == null || insets.top == 0 && insets.left == 0 && insets.bottom == 0 && insets.right == 0;
    }

    public static boolean isPreserveBorders(@NotNull JComponent component) {
        return SwingUtils.getHonorUserBorders(component) && !SwingUtils.isUIResource(component.getBorder());
    }

    public static boolean isUIResource(@Nullable Object value) {
        return value == null || value instanceof UIResource;
    }

    public static boolean getHonorUserBorders(@NotNull JComponent component) {
        return Boolean.getBoolean("WebLookAndFeel.honorUserBorders") || Boolean.TRUE.equals(component.getClientProperty("WebLookAndFeel.honorUserBorder"));
    }

    public static void setHonorUserBorders(@NotNull JComponent component, boolean honor) {
        if (honor) {
            component.putClientProperty("WebLookAndFeel.honorUserBorder", Boolean.TRUE);
        } else {
            component.putClientProperty("WebLookAndFeel.honorUserBorder", null);
        }
    }

    public static boolean isLeftMouseButton(@NotNull MouseEvent e) {
        return (e.getModifiers() & 0x10) != 0;
    }

    public static boolean isMiddleMouseButton(@NotNull MouseEvent e) {
        return (e.getModifiers() & 8) == 8;
    }

    public static boolean isRightMouseButton(@NotNull MouseEvent e) {
        return (e.getModifiers() & 4) == 4;
    }

    public static boolean isDoubleClick(@NotNull MouseEvent e) {
        return SwingUtils.isDoubleClick(e, true);
    }

    public static boolean isDoubleClick(@NotNull MouseEvent e, boolean repeatable) {
        return SwingUtils.isLeftMouseButton(e) && (repeatable ? e.getClickCount() % 2 == 0 : e.getClickCount() == 2);
    }

    public static void packRowHeights(@NotNull JTable table) {
        for (int row = 0; row < table.getRowCount(); ++row) {
            int maxHeight = 0;
            for (int column = 0; column < table.getColumnCount(); ++column) {
                Object valueAt;
                TableCellRenderer cellRenderer = table.getCellRenderer(row, column);
                Component renderer = cellRenderer.getTableCellRendererComponent(table, valueAt = table.getValueAt(row, column), false, false, row, column);
                int heightPreferable = renderer != null ? renderer.getPreferredSize().height : 0;
                maxHeight = Math.max(heightPreferable, maxHeight);
            }
            table.setRowHeight(row, maxHeight);
        }
    }

    public static void packColumnWidths(@NotNull JTable table) {
        SwingUtils.packColumnWidths(table, 2);
    }

    public static void packColumnWidths(@NotNull JTable table, int margin) {
        for (int i = 0; i < table.getColumnCount(); ++i) {
            SwingUtils.packColumnWidth(table, i, margin);
        }
    }

    public static void packColumnWidth(@NotNull JTable table, int col) {
        SwingUtils.packColumnWidth(table, col, 2);
    }

    public static void packColumnWidth(@NotNull JTable table, int col, int margin) {
        DefaultTableColumnModel columnModel = (DefaultTableColumnModel)table.getColumnModel();
        TableColumn column = columnModel.getColumn(col);
        TableCellRenderer renderer = column.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component rendererComponent = renderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, 0, 0);
        int width = rendererComponent.getPreferredSize().width;
        for (int r = 0; r < table.getRowCount(); ++r) {
            renderer = table.getCellRenderer(r, col);
            rendererComponent = renderer.getTableCellRendererComponent(table, table.getValueAt(r, col), false, false, r, col);
            width = Math.max(width, rendererComponent.getPreferredSize().width);
        }
        column.setPreferredWidth(width += 2 * margin);
        column.setWidth(width);
    }

    public static boolean isPopupTrigger(@NotNull MouseEvent e) {
        return e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e);
    }

    /*
     * Could not resolve type clashes
     */
    public static void destroyContainer(@NotNull Container container) {
        for (Container toDestroy : SwingUtils.collectAllContainers(container)) {
            toDestroy.removeAll();
            toDestroy.setLayout(null);
            for (EventListener listener : toDestroy.getMouseListeners()) {
                toDestroy.removeMouseListener((MouseListener)listener);
            }
            for (EventListener listener : toDestroy.getMouseMotionListeners()) {
                toDestroy.removeMouseMotionListener((MouseMotionListener)listener);
            }
            for (EventListener listener : toDestroy.getMouseWheelListeners()) {
                toDestroy.removeMouseWheelListener((MouseWheelListener)listener);
            }
            for (EventListener listener : toDestroy.getKeyListeners()) {
                toDestroy.removeKeyListener((KeyListener)listener);
            }
            for (EventListener listener : toDestroy.getComponentListeners()) {
                toDestroy.removeComponentListener((ComponentListener)listener);
            }
            for (EventListener listener : toDestroy.getContainerListeners()) {
                toDestroy.removeContainerListener((ContainerListener)listener);
            }
            if (!(toDestroy instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)toDestroy;
            for (AncestorListener listener : jComponent.getAncestorListeners()) {
                jComponent.removeAncestorListener(listener);
            }
        }
    }

    @NotNull
    public static List<Container> collectAllContainers(@NotNull Container container) {
        return SwingUtils.collectAllContainers(container, new ArrayList<Container>());
    }

    @NotNull
    public static List<Container> collectAllContainers(@NotNull Container container, @NotNull List<Container> containers) {
        containers.add(container);
        for (Component component : container.getComponents()) {
            if (!(component instanceof Container)) continue;
            SwingUtils.collectAllContainers((Container)component, containers);
        }
        return containers;
    }

    @NotNull
    public static ButtonGroup groupButtons(@NotNull Container container) {
        return SwingUtils.groupButtons(container, false);
    }

    @NotNull
    public static ButtonGroup groupButtons(@NotNull Container container, boolean recursive) {
        ButtonGroup buttonGroup = new ButtonGroup();
        SwingUtils.groupButtons(container, recursive, buttonGroup);
        return buttonGroup;
    }

    public static void groupButtons(@NotNull Container container, boolean recursive, @NotNull ButtonGroup buttonGroup) {
        for (Component component : container.getComponents()) {
            if (component instanceof AbstractButton) {
                buttonGroup.add((AbstractButton)component);
            }
            if (!recursive || !(component instanceof Container)) continue;
            SwingUtils.groupButtons(container, true);
        }
    }

    @NotNull
    public static ButtonGroup groupButtons(AbstractButton ... buttons) {
        ButtonGroup buttonGroup = new ButtonGroup();
        SwingUtils.groupButtons(buttonGroup, buttons);
        return buttonGroup;
    }

    public static void groupButtons(@NotNull ButtonGroup buttonGroup, AbstractButton ... buttons) {
        for (AbstractButton button : buttons) {
            buttonGroup.add(button);
        }
    }

    public static void copyOrientation(@NotNull Component from, @NotNull Component to) {
        ComponentOrientation fo = from.getComponentOrientation();
        if (fo.isLeftToRight() != to.getComponentOrientation().isLeftToRight()) {
            to.applyComponentOrientation(fo);
        }
    }

    public static void changeOrientation(@NotNull Component component) {
        boolean ltr = component.getComponentOrientation().isLeftToRight();
        component.applyComponentOrientation(ltr ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT);
    }

    public static void updateGlobalOrientation(@NotNull ComponentOrientation orientation) {
        for (Window window : Window.getWindows()) {
            window.applyComponentOrientation(orientation);
            JRootPane rootPane = CoreSwingUtils.getRootPane((Component)window);
            if (rootPane != null) {
                SwingUtils.update(rootPane);
                continue;
            }
            SwingUtils.update(window);
        }
    }

    public static boolean isHeavyWeightWindow(@Nullable Window window) {
        String can;
        boolean heavyWeight = window != null ? (can = window.getClass().getCanonicalName()) != null && can.endsWith("HeavyWeightWindow") : false;
        return heavyWeight;
    }

    @Nullable
    public static <C extends Container> C getFirstParent(@NotNull Component component, @NotNull Class<C> parentClass) {
        Container parent;
        for (parent = component.getParent(); !parentClass.isInstance(parent) && parent != null; parent = parent.getParent()) {
        }
        return (C)parent;
    }

    @Nullable
    public static <C extends Component> C getFirst(@NotNull Container container, @NotNull Class<C> componentClass) {
        return SwingUtils.getFirst(container, componentClass, false);
    }

    @Nullable
    public static <C extends Component> C getFirst(@NotNull Container container, @NotNull Class<C> componentClass, boolean recursive) {
        Component result = null;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            C another;
            Component component = container.getComponent(i);
            if (componentClass.isInstance(component)) {
                result = component;
                break;
            }
            if (!recursive || !(component instanceof Container) || (another = SwingUtils.getFirst((Container)component, componentClass, true)) == null) continue;
            result = another;
            break;
        }
        return (C)result;
    }

    @Nullable
    public static <C extends JComponent> C getFirstParentSupportingDrop(@NotNull Component component) {
        JComponent c;
        JComponent result = null;
        Container parent = component.getParent();
        if (parent instanceof JComponent && (c = (JComponent)parent).getTransferHandler() != null) {
            result = c;
        }
        if (result == null) {
            result = (JComponent)SwingUtils.getFirstParentSupportingDrop(parent);
        }
        return (C)result;
    }

    @Nullable
    public static Window getAvailableWindow() {
        Window[] allWindows;
        Window result = null;
        Window activeWindow = SwingUtils.getActiveWindow();
        if (activeWindow != null && (activeWindow instanceof JFrame || activeWindow instanceof JDialog || activeWindow instanceof JWindow)) {
            result = activeWindow;
        }
        if (result == null && (allWindows = Window.getWindows()) != null && allWindows.length > 0) {
            for (Window window : allWindows) {
                if (!window.isShowing() || !(window instanceof JFrame) && !(window instanceof JDialog) && !(window instanceof JWindow)) continue;
                result = window;
                break;
            }
        }
        return result;
    }

    @Nullable
    public static Container getContentPane(@NotNull Component component) {
        JRootPane rootPane = CoreSwingUtils.getRootPane((Component)component);
        return rootPane != null ? rootPane.getContentPane() : null;
    }

    @Nullable
    public static JLayeredPane getLayeredPane(@NotNull Component component) {
        JRootPane rootPane = CoreSwingUtils.getRootPane((Component)component);
        return rootPane != null ? rootPane.getLayeredPane() : null;
    }

    @Nullable
    public static Component getGlassPane(@NotNull Component component) {
        JRootPane rootPane = CoreSwingUtils.getRootPane((Component)component);
        return rootPane != null ? rootPane.getGlassPane() : null;
    }

    @NotNull
    public static Insets increase(@NotNull Insets insets, @Nullable Insets amount) {
        if (amount != null) {
            insets.top += amount.top;
            insets.left += amount.left;
            insets.bottom += amount.bottom;
            insets.right += amount.right;
        }
        return insets;
    }

    @NotNull
    public static Dimension increase(@NotNull Dimension dimension, @Nullable Insets amount) {
        if (amount != null) {
            dimension.width += amount.left + amount.right;
            dimension.height += amount.top + amount.bottom;
        }
        return dimension;
    }

    @NotNull
    public static Insets decrease(@NotNull Insets insets, @Nullable Insets amount) {
        if (amount != null) {
            insets.top -= amount.top;
            insets.left -= amount.left;
            insets.bottom -= amount.bottom;
            insets.right -= amount.right;
        }
        return insets;
    }

    @Nullable
    public static Insets max(@Nullable Insets insets1, @Nullable Insets insets2) {
        Insets max = insets1 != null && insets2 != null ? new Insets(Math.max(insets1.top, insets2.top), Math.max(insets1.left, insets2.left), Math.max(insets1.bottom, insets2.bottom), Math.max(insets1.right, insets2.right)) : (insets1 != null ? insets1 : insets2);
        return max;
    }

    @NotNull
    public static Insets maxNonNull(@NotNull Insets insets1, @NotNull Insets insets2) {
        return new Insets(Math.max(insets1.top, insets2.top), Math.max(insets1.left, insets2.left), Math.max(insets1.bottom, insets2.bottom), Math.max(insets1.right, insets2.right));
    }

    @Nullable
    public static Insets min(@Nullable Insets insets1, @Nullable Insets insets2) {
        Insets min = insets1 != null && insets2 != null ? new Insets(Math.min(insets1.top, insets2.top), Math.min(insets1.left, insets2.left), Math.min(insets1.bottom, insets2.bottom), Math.min(insets1.right, insets2.right)) : (insets1 != null ? insets1 : insets2);
        return min;
    }

    @NotNull
    public static Insets minNonNull(@NotNull Insets insets1, @NotNull Insets insets2) {
        return new Insets(Math.min(insets1.top, insets2.top), Math.min(insets1.left, insets2.left), Math.min(insets1.bottom, insets2.bottom), Math.min(insets1.right, insets2.right));
    }

    @NotNull
    public static Dimension maxPreferredSize(@NotNull Component component1, @NotNull Component component2) {
        return SwingUtils.maxNonNull(component1.getPreferredSize(), component2.getPreferredSize());
    }

    @NotNull
    public static Dimension maxPreferredSize(Component ... components) {
        Dimension max = components.length > 0 ? components[0].getPreferredSize() : new Dimension(0, 0);
        for (int i = 1; i < components.length; ++i) {
            max = SwingUtils.maxNonNull(max, components[i].getPreferredSize());
        }
        return max;
    }

    public static int maxPreferredWidth(Component ... components) {
        int max = 0;
        for (Component component : components) {
            max = Math.max(max, component.getPreferredSize().width);
        }
        return max;
    }

    public static int maxPreferredHeight(Component ... components) {
        int max = 0;
        for (Component component : components) {
            max = Math.max(max, component.getPreferredSize().height);
        }
        return max;
    }

    @Nullable
    public static Dimension max(@Nullable Dimension dimension1, @Nullable Dimension dimension2) {
        Dimension max = dimension1 != null && dimension2 != null ? new Dimension(Math.max(dimension1.width, dimension2.width), Math.max(dimension1.height, dimension2.height)) : (dimension1 != null ? dimension1 : dimension2);
        return max;
    }

    @NotNull
    public static Dimension maxNonNull(@Nullable Dimension dimension1, @Nullable Dimension dimension2) {
        Dimension max;
        if (dimension1 != null && dimension2 != null) {
            max = new Dimension(Math.max(dimension1.width, dimension2.width), Math.max(dimension1.height, dimension2.height));
        } else if (dimension1 != null) {
            max = dimension1;
        } else if (dimension2 != null) {
            max = dimension2;
        } else {
            throw new UtilityException("At least one of the Dimensions must not be null");
        }
        return max;
    }

    @NotNull
    public static Dimension minPreferredSize(@NotNull Component component1, @NotNull Component component2) {
        return SwingUtils.minNonNull(component1.getPreferredSize(), component2.getPreferredSize());
    }

    @NotNull
    public static Dimension minPreferredSize(Component ... components) {
        Dimension min = components.length > 0 ? components[0].getPreferredSize() : new Dimension(0, 0);
        for (int i = 1; i < components.length; ++i) {
            min = SwingUtils.minNonNull(min, components[i].getPreferredSize());
        }
        return min;
    }

    @Nullable
    public static Dimension min(@Nullable Dimension dimension1, @Nullable Dimension dimension2) {
        Dimension min = dimension1 != null && dimension2 != null ? new Dimension(Math.min(dimension1.width, dimension2.width), Math.min(dimension1.height, dimension2.height)) : null;
        return min;
    }

    @NotNull
    public static Dimension minNonNull(@NotNull Dimension dimension1, @NotNull Dimension dimension2) {
        return new Dimension(Math.min(dimension1.width, dimension2.width), Math.min(dimension1.height, dimension2.height));
    }

    @NotNull
    public static Rectangle shrink(@NotNull Rectangle rectangle, @Nullable Insets insets) {
        Rectangle result = insets != null ? new Rectangle(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom) : new Rectangle(rectangle);
        return result;
    }

    @NotNull
    public static Rectangle moveBy(@NotNull Rectangle rectangle, @Nullable Point point) {
        Rectangle result = point != null ? new Rectangle(rectangle.x + point.x, rectangle.y + point.y, rectangle.width, rectangle.height) : new Rectangle(rectangle);
        return result;
    }

    @NotNull
    public static Dimension shrink(@NotNull Dimension dimension, @Nullable Insets insets) {
        Dimension result = insets != null ? new Dimension(dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom) : new Dimension(dimension);
        return result;
    }

    @NotNull
    public static Dimension stretch(@NotNull Dimension dimension, @Nullable Insets insets) {
        Dimension result = insets != null ? new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom) : new Dimension(dimension);
        return result;
    }

    public static void setOpaqueRecursively(@NotNull Component component, boolean opaque) {
        SwingUtils.setOpaqueRecursively(component, opaque, false);
    }

    public static void setOpaqueRecursively(@NotNull Component component, boolean opaque, boolean childrenOnly) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            if (!childrenOnly) {
                jComponent.setOpaque(opaque);
            }
        }
        if (component instanceof Container) {
            for (Component child : ((Container)component).getComponents()) {
                SwingUtils.setOpaqueRecursively(child, opaque, false);
            }
        }
    }

    public static void setDoubleBufferedRecursively(@NotNull Component component, boolean doubleBuffered) {
        SwingUtils.setDoubleBufferedRecursively(component, doubleBuffered, false);
    }

    public static void setDoubleBufferedRecursively(@NotNull Component component, boolean doubleBuffered, boolean childrenOnly) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            if (!childrenOnly) {
                jComponent.setDoubleBuffered(doubleBuffered);
            }
        }
        if (component instanceof Container) {
            for (Component child : ((Container)component).getComponents()) {
                SwingUtils.setDoubleBufferedRecursively(child, doubleBuffered, false);
            }
        }
    }

    public static void setHandlesEnableStateMark(@NotNull JComponent component) {
        component.putClientProperty(HANDLES_ENABLE_STATE, Boolean.TRUE);
    }

    public static void removeHandlesEnableStateMark(@NotNull JComponent component) {
        component.putClientProperty(HANDLES_ENABLE_STATE, Boolean.FALSE);
    }

    public static boolean isHandlesEnableState(@NotNull Component component) {
        Object property;
        boolean handlesEnabledState = component instanceof JComponent ? (property = ((JComponent)component).getClientProperty(HANDLES_ENABLE_STATE)) instanceof Boolean && (Boolean)property != false : false;
        return handlesEnabledState;
    }

    public static void setEnabledRecursively(@NotNull Component component, boolean enabled) {
        SwingUtils.setEnabledRecursively(component, enabled, false);
    }

    public static void setEnabledRecursively(@NotNull Component component, boolean enabled, boolean startFromChildren) {
        if (!startFromChildren) {
            component.setEnabled(enabled);
        }
        if (component instanceof Container && (startFromChildren || !SwingUtils.isHandlesEnableState(component))) {
            for (Component child : ((Container)component).getComponents()) {
                SwingUtils.setEnabledRecursively(child, enabled, false);
            }
        }
    }

    @NotNull
    public static List<Component> disableRecursively(@NotNull Component component, boolean startFromChildren, boolean excludePanels, Component ... excluded) {
        return SwingUtils.disableRecursively(component, startFromChildren, excludePanels, (List<Component>)new ImmutableList((Object[])excluded));
    }

    @NotNull
    public static List<Component> disableRecursively(@NotNull Component component, boolean startFromChildren, boolean excludePanels, @NotNull List<Component> excluded) {
        ArrayList<Component> disabled = new ArrayList<Component>();
        SwingUtils.disableRecursively(component, startFromChildren, excludePanels, excluded, disabled);
        return disabled;
    }

    private static void disableRecursively(@NotNull Component component, boolean startFromChildren, boolean excludePanels, @NotNull List<Component> excluded, @NotNull List<Component> disabled) {
        boolean b;
        boolean bl = b = !startFromChildren && !excluded.contains(component) && (!(component instanceof JPanel) || !excludePanels);
        if (b && component.isEnabled()) {
            component.setEnabled(false);
            disabled.add(component);
        }
        if (!(!(component instanceof Container) || b && SwingUtils.isHandlesEnableState(component))) {
            for (Component child : ((Container)component).getComponents()) {
                SwingUtils.disableRecursively(child, false, excludePanels, excluded, disabled);
            }
        }
    }

    public static void enable(@NotNull List<Component> disabled) {
        for (Component component : disabled) {
            component.setEnabled(true);
        }
    }

    public static void setFocusableRecursively(@NotNull JComponent component, boolean focusable) {
        SwingUtils.setFocusableRecursively(component, focusable, false);
    }

    public static void setFocusableRecursively(@NotNull JComponent component, boolean focusable, boolean childrenOnly) {
        if (!childrenOnly) {
            component.setFocusable(focusable);
        }
        for (int i = 0; i < component.getComponentCount(); ++i) {
            if (!(component.getComponent(i) instanceof JComponent)) continue;
            SwingUtils.setFocusableRecursively((JComponent)component.getComponent(i), focusable, false);
        }
    }

    public static void setBackgroundRecursively(@NotNull Component component, Color bg) {
        SwingUtils.setBackgroundRecursively(component, bg, false);
    }

    public static void setBackgroundRecursively(@NotNull Component component, Color bg, boolean childrenOnly) {
        if (!childrenOnly) {
            component.setBackground(bg);
        }
        if (component instanceof Container) {
            for (Component child : ((Container)component).getComponents()) {
                SwingUtils.setBackgroundRecursively(child, bg, false);
            }
        }
    }

    public static void setForegroundRecursively(@NotNull JComponent component, @Nullable Color foreground) {
        SwingUtils.setForegroundRecursively(component, foreground, false);
    }

    public static void setForegroundRecursively(@NotNull JComponent component, @Nullable Color foreground, boolean childrenOnly) {
        if (!childrenOnly) {
            component.setForeground(foreground);
        }
        for (int i = 0; i < component.getComponentCount(); ++i) {
            if (!(component.getComponent(i) instanceof JComponent)) continue;
            SwingUtils.setForegroundRecursively((JComponent)component.getComponent(i), foreground, false);
        }
    }

    public static void setFontRecursively(@NotNull JComponent component, @Nullable Font font) {
        SwingUtils.setFontRecursively(component, font, false);
    }

    public static void setFontRecursively(@NotNull JComponent component, @Nullable Font font, boolean childrenOnly) {
        if (!childrenOnly) {
            component.setFont(font);
        }
        for (int i = 0; i < component.getComponentCount(); ++i) {
            if (!(component.getComponent(i) instanceof JComponent)) continue;
            SwingUtils.setFontRecursively((JComponent)component.getComponent(i), font, false);
        }
    }

    @NotNull
    public static BufferedImage createComponentSnapshot(@NotNull Component content) {
        return SwingUtils.createComponentSnapshot(content, content.getWidth(), content.getHeight(), 1.0f);
    }

    @NotNull
    public static BufferedImage createComponentSnapshot(@NotNull Component content, float opacity) {
        return SwingUtils.createComponentSnapshot(content, content.getWidth(), content.getHeight(), opacity);
    }

    @NotNull
    public static BufferedImage createComponentSnapshot(@NotNull Component content, int width, int height) {
        return SwingUtils.createComponentSnapshot(content, width, height, 1.0f);
    }

    @NotNull
    public static BufferedImage createComponentSnapshot(@NotNull Component content, int width, int height, float opacity) {
        BufferedImage result;
        BufferedImage bi = ImageUtils.createCompatibleImage((int)width, (int)height, (int)3);
        Graphics2D snapshot2d = bi.createGraphics();
        Dimension size = content.getSize();
        content.setSize(width, height);
        content.paintAll(snapshot2d);
        content.setSize(size);
        snapshot2d.dispose();
        if (content instanceof JComponent) {
            ((JComponent)content).revalidate();
            content.repaint();
        }
        if (opacity < 1.0f) {
            result = ImageUtils.createCompatibleImage((int)width, (int)height, (int)3);
            Graphics2D transparent2d = result.createGraphics();
            GraphicsUtils.setupAlphaComposite((Graphics2D)transparent2d, (Float)Float.valueOf(opacity));
            transparent2d.drawImage((Image)bi, 0, 0, null);
            transparent2d.dispose();
        } else {
            result = bi;
        }
        return result;
    }

    @Nullable
    public static KeyStroke getAccelerator(@Nullable HotkeyData hotkey) {
        return hotkey != null && hotkey.isHotkeySet() ? hotkey.getKeyStroke() : null;
    }

    public static int getFocusAcceleratorKeyMask() {
        Object toolkitMask;
        Toolkit toolkit;
        int mask = 8;
        if (SystemUtils.isJava7orAbove() && Objects.equals((Object)(toolkit = Toolkit.getDefaultToolkit()).getClass().getCanonicalName(), (Object)"sun.awt.SunToolkit") && (toolkitMask = ReflectUtils.callMethodSafely((Object)toolkit, (String)"getFocusAcceleratorKeyMask", (Object[])new Object[0])) != null) {
            mask = (Integer)toolkitMask;
        }
        return mask;
    }

    public static int getMnemonicIndex(String text, int mnemonic) {
        int index;
        if (text != null && mnemonic != 0) {
            char uc = Character.toUpperCase((char)mnemonic);
            char lc = Character.toLowerCase((char)mnemonic);
            int uci = text.indexOf(uc);
            int lci = text.indexOf(lc);
            index = uci == -1 ? lci : (lci == -1 ? uci : (lci < uci ? lci : uci));
        } else {
            index = -1;
        }
        return index;
    }

    @Nullable
    public static Window getActiveWindow() {
        Window[] windows = Window.getWindows();
        Window window = null;
        for (Window w : windows) {
            if (!w.isShowing() || !w.isActive() || !w.isFocused()) continue;
            window = w;
            break;
        }
        return window;
    }

    public static boolean isShortcut(@NotNull InputEvent event) {
        return (event.getModifiers() & SwingUtils.getSystemShortcutModifier()) != 0;
    }

    public static int getSystemShortcutModifier() {
        if (systemShortcutModifier == null) {
            systemShortcutModifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        }
        return systemShortcutModifier;
    }

    @NotNull
    public static String hotkeyToString(@NotNull KeyEvent keyEvent) {
        return SwingUtils.hotkeyToString(SwingUtils.isCtrl(keyEvent), SwingUtils.isAlt(keyEvent), SwingUtils.isShift(keyEvent), keyEvent.getKeyCode());
    }

    @NotNull
    public static String hotkeyToString(@NotNull HotkeyData hotkeyData) {
        return SwingUtils.hotkeyToString(hotkeyData.isCtrl(), hotkeyData.isAlt(), hotkeyData.isShift(), hotkeyData.getKeyCode());
    }

    @NotNull
    public static String hotkeyToString(@NotNull KeyStroke keyStroke) {
        return SwingUtils.hotkeyToString(SwingUtils.isCtrl(keyStroke.getModifiers()), SwingUtils.isAlt(keyStroke.getModifiers()), SwingUtils.isShift(keyStroke.getModifiers()), keyStroke.getKeyCode());
    }

    @NotNull
    public static String hotkeyToString(boolean isCtrl, boolean isAlt, boolean isShift, @Nullable Integer keyCode) {
        return "" + (isCtrl ? KeyEvent.getKeyModifiersText(SwingUtils.getSystemShortcutModifier()) + (isAlt || isShift || keyCode != null ? "+" : "") : "") + (isAlt ? KeyEvent.getKeyModifiersText(8) + (isShift || keyCode != null ? "+" : "") : "") + (isShift ? KeyEvent.getKeyModifiersText(1) + (keyCode != null ? "+" : "") : "") + (keyCode != null ? KeyEvent.getKeyText(keyCode) : "");
    }

    public static boolean isCtrl(@NotNull InputEvent event) {
        return SwingUtils.isCtrl(event.getModifiers());
    }

    public static boolean isCtrl(int modifiers) {
        return (modifiers & 2) != 0;
    }

    public static boolean isAlt(@NotNull InputEvent event) {
        return SwingUtils.isAlt(event.getModifiers());
    }

    public static boolean isAlt(int modifiers) {
        return (modifiers & 8) != 0;
    }

    public static boolean isShift(@NotNull InputEvent event) {
        return SwingUtils.isShift(event.getModifiers());
    }

    public static boolean isShift(int modifiers) {
        return (modifiers & 1) != 0;
    }

    @NotNull
    public static HotkeyData getHotkeyData(@NotNull KeyStroke keyStroke) {
        int m = keyStroke.getModifiers();
        return new HotkeyData(SwingUtils.isCtrl(m), SwingUtils.isAlt(m), SwingUtils.isShift(m), keyStroke.getKeyCode());
    }

    @NotNull
    public static Font getDefaultLabelFont() {
        if (label == null) {
            label = new JLabel();
        }
        return label.getFont();
    }

    @NotNull
    public static FontMetrics getDefaultLabelFontMetrics() {
        if (label == null) {
            label = new JLabel();
        }
        return label.getFontMetrics(label.getFont());
    }

    @Nullable
    public static JScrollPane getScrollPane(@Nullable Component component) {
        JScrollPane scrollPane = component != null && component.getParent() != null && component.getParent() instanceof JViewport && component.getParent().getParent() != null && component.getParent().getParent() instanceof JScrollPane ? (JScrollPane)component.getParent().getParent() : null;
        return scrollPane;
    }

    @Nullable
    public static Component compositeRequestFocus(@NotNull Component component) {
        Component focused = null;
        if (component instanceof Container) {
            FocusTraversalPolicy policy;
            Component after;
            Container focusCycleRootAncestor;
            FocusTraversalPolicy policy2;
            Component defaultComponent;
            Container container = (Container)component;
            if (container.isFocusCycleRoot() && (defaultComponent = (policy2 = container.getFocusTraversalPolicy()).getDefaultComponent(container)) != null) {
                defaultComponent.requestFocus();
                focused = defaultComponent;
            }
            if (focused == null && (focusCycleRootAncestor = container.getFocusCycleRootAncestor()) != null && (after = (policy = focusCycleRootAncestor.getFocusTraversalPolicy()).getComponentAfter(focusCycleRootAncestor, container)) != null && SwingUtilities.isDescendingFrom(after, container)) {
                after.requestFocus();
                focused = after;
            }
        }
        if (focused == null && component.isFocusable()) {
            component.requestFocus();
            focused = component;
        }
        return focused;
    }

    @Nullable
    public static Component findFocusableComponent(@NotNull Container container) {
        Component focusable = null;
        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
        if (focusTraversalPolicy != null) {
            focusable = focusTraversalPolicy.getFirstComponent(container);
        } else {
            for (Component component : container.getComponents()) {
                if (component.isFocusable()) {
                    focusable = component;
                    continue;
                }
                if (component instanceof Container && (focusable = SwingUtils.findFocusableComponent((Container)component)) != null) break;
            }
        }
        return focusable;
    }

    @NotNull
    public static List<Component> findComponentsWithText(@Nullable String text, @Nullable Component component) {
        return SwingUtils.findComponentsWithText(text, component, new ArrayList<Component>());
    }

    @NotNull
    public static List<Component> findComponentsWithText(@Nullable String text, @Nullable Component component, @NotNull List<Component> components) {
        block35: {
            if (text != null && !text.equals("") && component != null) {
                try {
                    if (component instanceof WebPathField || component instanceof WebFileChooserField || component instanceof WebDateField || component instanceof WebCalendar) {
                        for (Component child : ((Container)component).getComponents()) {
                            if (SwingUtils.findComponentsWithText(text, child).size() <= 0) continue;
                            components.add(component);
                            break block35;
                        }
                        break block35;
                    }
                    if (component instanceof WebCollapsiblePane) {
                        WebCollapsiblePane collapsiblePane = (WebCollapsiblePane)component;
                        if (SwingUtils.findComponentsWithText(text, collapsiblePane.getTitleComponent()).size() > 0) {
                            components.add(component);
                        }
                    } else if (component instanceof JComboBox) {
                        JComboBox comboBox = (JComboBox)component;
                        Object selectedItem = comboBox.getSelectedItem();
                        if (selectedItem != null) {
                            if (selectedItem.toString().toLowerCase(Locale.ROOT).contains(text.toLowerCase(Locale.ROOT))) {
                                components.add(component);
                            } else if (comboBox.isEditable()) {
                                if (SwingUtils.findComponentsWithText(text, comboBox.getEditor().getEditorComponent()).size() > 0) {
                                    components.add(component);
                                }
                            } else if (SwingUtils.findComponentsWithText(text, comboBox.getRenderer().getListCellRendererComponent(null, selectedItem, -1, true, true)).size() > 0) {
                                components.add(component);
                            }
                        }
                    } else if (component instanceof JSpinner) {
                        if (((JSpinner)component).getValue().toString().toLowerCase(Locale.ROOT).contains(text.toLowerCase(Locale.ROOT))) {
                            components.add(component);
                        }
                    } else if (component instanceof JLabel) {
                        if (((JLabel)component).getText().toLowerCase(Locale.ROOT).contains(text.toLowerCase(Locale.ROOT))) {
                            components.add(component);
                        }
                    } else if (component instanceof AbstractButton) {
                        if (((AbstractButton)component).getText().toLowerCase(Locale.ROOT).contains(text.toLowerCase(Locale.ROOT))) {
                            components.add(component);
                        }
                    } else if (component instanceof JTextComponent) {
                        if (((JTextComponent)component).getText().toLowerCase(Locale.ROOT).contains(text.toLowerCase(Locale.ROOT))) {
                            if (component.getParent() != null && component.getParent().getParent() != null && component.getParent().getParent() instanceof JScrollPane) {
                                components.add(component.getParent().getParent());
                            } else {
                                components.add(component);
                            }
                        }
                    } else if (component instanceof JTabbedPane) {
                        JTabbedPane tp = (JTabbedPane)component;
                        for (int i = 0; i < tp.getTabCount(); ++i) {
                            if (!(tp.getComponentAt(i) instanceof Container)) continue;
                            SwingUtils.checkContent(text, (Container)tp.getComponentAt(i), components);
                        }
                    } else if (component instanceof Container) {
                        SwingUtils.checkContent(text, (Container)component, components);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return components;
    }

    private static void checkContent(@Nullable String text, @NotNull Container container, @NotNull List<Component> components) {
        for (Component child : container.getComponents()) {
            SwingUtils.findComponentsWithText(text, child, components);
        }
    }

    public static int indexOf(@NotNull Container container, @Nullable Component child) {
        int index = -1;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            if (container.getComponent(i) != child) continue;
            index = i;
            break;
        }
        return index;
    }

    @NotNull
    public static Map<Component, Dimension> getChildPreferredSizes(@NotNull Container container) {
        HashMap<Component, Dimension> cps = new HashMap<Component, Dimension>(container.getComponentCount());
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            cps.put(component, component.getPreferredSize());
        }
        return cps;
    }

    public static void equalizeComponentsSize(Component ... components) {
        SwingUtils.equalizeComponentsSize(Collections.<String>emptyList(), components);
    }

    public static void equalizeComponentsSize(@NotNull List<String> properties, Component ... components) {
        SwingUtils.equalizeComponentsSizeImpl(true, true, properties, components);
    }

    public static void equalizeComponentsSize(@NotNull List<? extends Component> components) {
        SwingUtils.equalizeComponentsSize(Collections.<String>emptyList(), components);
    }

    public static void equalizeComponentsSize(@NotNull List<String> properties, @NotNull List<? extends Component> components) {
        SwingUtils.equalizeComponentsSizeImpl(true, true, properties, components.toArray(new Component[components.size()]));
    }

    public static void equalizeComponentsWidth(Component ... components) {
        SwingUtils.equalizeComponentsWidth(Collections.<String>emptyList(), components);
    }

    public static void equalizeComponentsWidth(@NotNull List<String> properties, Component ... components) {
        SwingUtils.equalizeComponentsSizeImpl(true, false, properties, components);
    }

    public static void equalizeComponentsWidth(@NotNull List<? extends Component> components) {
        SwingUtils.equalizeComponentsWidth(Collections.<String>emptyList(), components);
    }

    public static void equalizeComponentsWidth(@NotNull List<String> properties, @NotNull List<? extends Component> components) {
        SwingUtils.equalizeComponentsSizeImpl(true, false, properties, components.toArray(new Component[components.size()]));
    }

    public static void equalizeComponentsHeight(Component ... components) {
        SwingUtils.equalizeComponentsHeight(Collections.<String>emptyList(), components);
    }

    public static void equalizeComponentsHeight(@NotNull List<String> properties, Component ... components) {
        SwingUtils.equalizeComponentsSizeImpl(false, true, properties, components);
    }

    public static void equalizeComponentsHeight(@NotNull List<? extends Component> components) {
        SwingUtils.equalizeComponentsHeight(Collections.<String>emptyList(), components);
    }

    public static void equalizeComponentsHeight(@NotNull List<String> properties, @NotNull List<? extends Component> components) {
        SwingUtils.equalizeComponentsSizeImpl(false, true, properties, components.toArray(new Component[components.size()]));
    }

    private static void equalizeComponentsSizeImpl(final boolean width, final boolean height, @NotNull List<String> properties, final Component ... components) {
        SwingUtils.equalizeComponentsSizeImpl(width, height, components);
        if (CollectionUtils.notEmpty(properties)) {
            PropertyChangeListener listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    SwingUtils.resetComponentsSizeImpl(width, height, components);
                    SwingUtils.equalizeComponentsSizeImpl(width, height, components);
                }
            };
            for (Component component : components) {
                for (String property : properties) {
                    component.addPropertyChangeListener(property, listener);
                }
            }
        }
    }

    private static void equalizeComponentsSizeImpl(boolean width, boolean height, Component ... components) {
        Dimension ps;
        Dimension maxSize = new Dimension(0, 0);
        for (Component component : components) {
            if (component == null) continue;
            ps = component.getPreferredSize();
            maxSize.width = Math.max(maxSize.width, ps.width);
            maxSize.height = Math.max(maxSize.height, ps.height);
        }
        for (Component component : components) {
            if (component == null) continue;
            if (component instanceof SizeMethods) {
                SizeMethods sizeMethods = (SizeMethods)((Object)component);
                if (width) {
                    sizeMethods.setPreferredWidth(maxSize.width);
                }
                if (!height) continue;
                sizeMethods.setPreferredHeight(maxSize.height);
                continue;
            }
            ps = component.getPreferredSize();
            if (width && height) {
                component.setPreferredSize(maxSize);
                continue;
            }
            if (width) {
                component.setPreferredSize(new Dimension(maxSize.width, ps.height));
                continue;
            }
            if (!height) continue;
            component.setPreferredSize(new Dimension(ps.width, maxSize.height));
        }
    }

    private static void resetComponentsSizeImpl(boolean width, boolean height, Component ... components) {
        for (Component component : components) {
            if (component == null) continue;
            if (component instanceof SizeMethods) {
                SizeMethods sizeMethods = (SizeMethods)((Object)component);
                if (width) {
                    sizeMethods.setPreferredWidth(-1);
                }
                if (!height) continue;
                sizeMethods.setPreferredHeight(-1);
                continue;
            }
            component.setPreferredSize(null);
        }
    }

    public static boolean isEqualOrChild(@Nullable Component component, @Nullable Component child) {
        boolean equalOrChild = false;
        if (component == child) {
            equalOrChild = true;
        } else if (component instanceof Container && child != null) {
            for (Component c : ((Container)component).getComponents()) {
                if (!SwingUtils.isEqualOrChild(c, child)) continue;
                equalOrChild = true;
                break;
            }
        }
        return equalOrChild;
    }

    public static boolean hasFocusOwner(@Nullable Component component) {
        Component focusOwner = FocusManager.getCurrentManager().getFocusOwner();
        return component != null && component == focusOwner || component instanceof Container && ((Container)component).isAncestorOf(focusOwner);
    }

    public static boolean hasFocusableComponent(@NotNull Container container) {
        boolean hasFocusableComponent = false;
        for (Component component : container.getComponents()) {
            if (component.isFocusable()) {
                hasFocusableComponent = true;
                break;
            }
            if (!(component instanceof Container) || !SwingUtils.hasFocusableComponent((Container)component)) continue;
            hasFocusableComponent = true;
            break;
        }
        return hasFocusableComponent;
    }

    @NotNull
    public static String[] getFontNames() {
        if (fontNames == null) {
            fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }
        return fontNames;
    }

    @NotNull
    public static Font[] getFonts() {
        if (fonts == null) {
            fonts = SwingUtils.createFonts(SwingUtils.getFontNames());
        }
        return fonts;
    }

    @NotNull
    public static Font[] createFonts(@NotNull String[] fontNames) {
        Font[] fonts = new Font[fontNames.length];
        for (int i = 0; i < fontNames.length; ++i) {
            fonts[i] = new Font(fontNames[i], 0, 13);
        }
        return fonts;
    }

    @NotNull
    public static Insets toRTL(@NotNull Insets insets) {
        return new Insets(insets.top, insets.right, insets.bottom, insets.left);
    }

    public static Map setupTextAntialias(@NotNull Graphics g) {
        return SwingUtils.setupTextAntialias((Graphics2D)g, TextRasterization.subpixel.getRenderingHints());
    }

    public static Map setupTextAntialias(@NotNull Graphics2D g2d) {
        return SwingUtils.setupTextAntialias(g2d, TextRasterization.subpixel.getRenderingHints());
    }

    public static Map setupTextAntialias(@NotNull Graphics g, @NotNull TextRasterization rasterization) {
        return SwingUtils.setupTextAntialias((Graphics2D)g, rasterization.getRenderingHints());
    }

    public static Map setupTextAntialias(@NotNull Graphics2D g2d, @NotNull TextRasterization rasterization) {
        return SwingUtils.setupTextAntialias(g2d, rasterization.getRenderingHints());
    }

    private static Map setupTextAntialias(@NotNull Graphics2D g2d, @Nullable Map hints) {
        Map oldHints;
        if (hints != null) {
            Paint paint = g2d.getPaint();
            g2d.setPaint(RENDERING_FIX_COLOR);
            g2d.setPaint(paint);
            oldHints = SwingUtils.getRenderingHints(g2d, hints, null);
            g2d.addRenderingHints(hints);
        } else {
            oldHints = null;
        }
        return oldHints;
    }

    public static void restoreTextAntialias(@NotNull Graphics g, @Nullable Map hints) {
        SwingUtils.restoreTextAntialias((Graphics2D)g, hints);
    }

    public static void restoreTextAntialias(@NotNull Graphics2D g2d, @Nullable Map hints) {
        if (hints != null) {
            g2d.addRenderingHints(hints);
        }
    }

    @NotNull
    private static Map getRenderingHints(@NotNull Graphics2D g2d, @Nullable Map hintsToSave, @Nullable Map savedHints) {
        if (savedHints == null) {
            savedHints = new RenderingHints(null);
        } else {
            savedHints.clear();
        }
        if (hintsToSave != null && hintsToSave.size() != 0) {
            Set objects = hintsToSave.keySet();
            for (Object o : objects) {
                RenderingHints.Key key = (RenderingHints.Key)o;
                Object value = g2d.getRenderingHint(key);
                if (value == null) continue;
                savedHints.put(key, value);
            }
        }
        return savedHints;
    }

    @NotNull
    public static FontMetrics getFontMetrics(@Nullable JComponent component, @NotNull Graphics g) {
        return SwingUtils.getFontMetrics(component, g, g.getFont());
    }

    @NotNull
    public static FontMetrics getFontMetrics(@Nullable JComponent component, @NotNull Graphics g, @NotNull Font font) {
        FontMetrics fontMetrics = component != null ? component.getFontMetrics(font) : g.getFontMetrics(font);
        return fontMetrics;
    }

    public static void firePropertyChanged(@NotNull Component component, @NotNull String property, @Nullable Object oldValue, @Nullable Object newValue) {
        try {
            ReflectUtils.callMethod((Object)component, (String)"firePropertyChange", (Object[])new Object[]{property, oldValue, newValue});
        }
        catch (NoSuchMethodException e) {
            LoggerFactory.getLogger(ProprietaryUtils.class).error(e.toString(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LoggerFactory.getLogger(ProprietaryUtils.class).error(e.toString(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LoggerFactory.getLogger(ProprietaryUtils.class).error(e.toString(), (Throwable)e);
        }
    }

    public static long frameRateDelay(int frameRate) {
        return Math.min(10L, 1000L / (long)frameRate);
    }

    public static int stringWidth(@NotNull FontMetrics fontMetrics, @Nullable String string) {
        return TextUtils.notEmpty((String)string) ? fontMetrics.stringWidth(string) : 0;
    }
}

