/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import java.io.Serializable;
import javax.swing.JComponent;

public final class NullableClientProperty<V extends Serializable>
implements Serializable {
    @NotNull
    private final String key;
    @Nullable
    private final V defaultValue;

    public NullableClientProperty(@NotNull String key, @Nullable V defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    @NotNull
    public String key() {
        return this.key;
    }

    @Nullable
    public V defaultValue() {
        return this.defaultValue;
    }

    @Nullable
    public V get(@NotNull JComponent component) {
        Object value = component.getClientProperty(this.key);
        return (V)(value != null ? (Serializable)value : this.defaultValue);
    }

    @Nullable
    public V set(@NotNull JComponent component, @Nullable V value) {
        Object old = component.getClientProperty(this.key);
        component.putClientProperty(this.key, value);
        return (V)((Serializable)old);
    }

    @Nullable
    public V reset(@NotNull JComponent component) {
        return this.set(component, null);
    }
}

