/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class SizeCache {
    private static final String MAX_CHILDREN_SIZES = "max.children.sizes:";
    private final Map<Component, Sizes> sizes;
    private final Map<String, Sizes> custom;

    public SizeCache(@NotNull Container container) {
        this(container.getComponentCount());
    }

    public SizeCache(int initialCapacity) {
        this.sizes = new WeakHashMap<Component, Sizes>(initialCapacity);
        this.custom = new HashMap<String, Sizes>();
    }

    @NotNull
    public Dimension preferred(@NotNull Component component) {
        return this.getSizes(component).preferred(component);
    }

    @NotNull
    public Dimension preferred(@NotNull Container container, int index) {
        Component component = container.getComponent(index);
        return this.getSizes(component).preferred(component);
    }

    @NotNull
    public Dimension minimum(@NotNull Component component) {
        return this.getSizes(component).minimum(component);
    }

    @NotNull
    public Dimension minimum(@NotNull Container container, int index) {
        Component component = container.getComponent(index);
        return this.getSizes(component).minimum(component);
    }

    @NotNull
    public Dimension maximum(@NotNull Component component) {
        return this.getSizes(component).maximum(component);
    }

    @NotNull
    public Dimension maximum(@NotNull Container container, int index) {
        Component component = container.getComponent(index);
        return this.getSizes(component).maximum(component);
    }

    public void clear(@NotNull Component component) {
        Sizes sizes = this.sizes.get(component);
        if (sizes != null) {
            sizes.preferred = null;
            sizes.minimum = null;
            sizes.maximum = null;
        }
    }

    @NotNull
    private Sizes getSizes(@NotNull Component component) {
        Sizes sizes = this.sizes.get(component);
        if (sizes == null) {
            sizes = new Sizes();
            this.sizes.put(component, sizes);
        }
        return sizes;
    }

    public Dimension maxPreferred(@NotNull Container container) {
        return this.getSizes(MAX_CHILDREN_SIZES + container.hashCode()).maxPreferred(container, this);
    }

    public Dimension maxMinimum(@NotNull Container container) {
        return this.getSizes(MAX_CHILDREN_SIZES + container.hashCode()).maxMinimum(container, this);
    }

    public Dimension maxMaximum(@NotNull Container container) {
        return this.getSizes(MAX_CHILDREN_SIZES + container.hashCode()).maxMaximum(container, this);
    }

    @NotNull
    private Sizes getSizes(@NotNull String key) {
        Sizes sizes = this.custom.get(key);
        if (sizes == null) {
            sizes = new Sizes();
            this.custom.put(key, sizes);
        }
        return sizes;
    }

    private static final class Sizes {
        @Nullable
        private Dimension preferred;
        @Nullable
        private Dimension minimum;
        @Nullable
        private Dimension maximum;

        private Sizes() {
        }

        @NotNull
        public Dimension preferred(@NotNull Component component) {
            if (this.preferred == null) {
                this.preferred = component.getPreferredSize();
            }
            return this.preferred;
        }

        public Dimension maxPreferred(@NotNull Container container, @NotNull SizeCache cache) {
            if (this.preferred == null) {
                this.preferred = new Dimension(0, 0);
                for (int index = 0; index < container.getComponentCount(); ++index) {
                    this.preferred = SwingUtils.maxNonNull(this.preferred, cache.preferred(container, index));
                }
            }
            return this.preferred;
        }

        @NotNull
        public Dimension minimum(@NotNull Component component) {
            if (this.minimum == null) {
                this.minimum = component.getMinimumSize();
            }
            return this.minimum;
        }

        public Dimension maxMinimum(@NotNull Container container, @NotNull SizeCache cache) {
            if (this.preferred == null) {
                this.preferred = new Dimension(0, 0);
                for (int index = 0; index < container.getComponentCount(); ++index) {
                    this.preferred = SwingUtils.maxNonNull(this.preferred, cache.minimum(container, index));
                }
            }
            return this.preferred;
        }

        @NotNull
        public Dimension maximum(@NotNull Component component) {
            if (this.maximum == null) {
                this.maximum = component.getMaximumSize();
            }
            return this.maximum;
        }

        public Dimension maxMaximum(@NotNull Container container, @NotNull SizeCache cache) {
            if (this.preferred == null) {
                this.preferred = new Dimension(0, 0);
                for (int index = 0; index < container.getComponentCount(); ++index) {
                    this.preferred = SwingUtils.maxNonNull(this.preferred, cache.maximum(container, index));
                }
            }
            return this.preferred;
        }
    }
}

