/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing.extensions;

import java.awt.Component;
import java.awt.Font;

public final class FontMethodsImpl {
    public static boolean isPlainFont(Component component) {
        return component == null || component.getFont() == null || component.getFont().isPlain();
    }

    public static <C extends Component> C setPlainFont(Component component) {
        return FontMethodsImpl.setPlainFont(component, true);
    }

    public static <C extends Component> C setPlainFont(Component component, boolean apply) {
        if (apply && component != null && component.getFont() != null) {
            component.setFont(component.getFont().deriveFont(0));
        }
        return (C)component;
    }

    public static boolean isBoldFont(Component component) {
        return component != null && component.getFont() != null && component.getFont().isBold();
    }

    public static <C extends Component> C setBoldFont(Component component) {
        return FontMethodsImpl.setBoldFont(component, true);
    }

    public static <C extends Component> C setBoldFont(Component component, boolean apply) {
        if (apply && component != null && component.getFont() != null) {
            component.setFont(component.getFont().deriveFont(1));
        }
        return (C)component;
    }

    public static boolean isItalicFont(Component component) {
        return component != null && component.getFont() != null && component.getFont().isItalic();
    }

    public static <C extends Component> C setItalicFont(Component component) {
        return FontMethodsImpl.setItalicFont(component, true);
    }

    public static <C extends Component> C setItalicFont(Component component, boolean apply) {
        if (apply && component != null && component.getFont() != null) {
            component.setFont(component.getFont().deriveFont(2));
        }
        return (C)component;
    }

    public static <C extends Component> C setFontStyle(Component component, boolean bold, boolean italic) {
        int style = bold && italic ? 3 : (bold ? 1 : (italic ? 2 : 0));
        return FontMethodsImpl.setFontStyle(component, style);
    }

    public static <C extends Component> C setFontStyle(Component component, int style) {
        if (component != null && component.getFont() != null) {
            component.setFont(component.getFont().deriveFont(style));
        }
        return (C)component;
    }

    public static int getFontSize(Component component) {
        if (component != null && component.getFont() != null) {
            return component.getFont().getSize();
        }
        return -1;
    }

    public static <C extends Component> C setFontSize(Component component, int fontSize) {
        if (component != null && component.getFont() != null) {
            component.setFont(component.getFont().deriveFont((float)fontSize));
        }
        return (C)component;
    }

    public static <C extends Component> C changeFontSize(Component component, int change) {
        if (component != null && component.getFont() != null) {
            Font font = component.getFont();
            component.setFont(font.deriveFont((float)font.getSize() + (float)change));
        }
        return (C)component;
    }

    public static <C extends Component> C setFontSizeAndStyle(Component component, int fontSize, boolean bold, boolean italic) {
        int style = bold && italic ? 3 : (bold ? 1 : (italic ? 2 : 0));
        return FontMethodsImpl.setFontSizeAndStyle(component, fontSize, style);
    }

    public static <C extends Component> C setFontSizeAndStyle(Component component, int fontSize, int style) {
        if (component != null && component.getFont() != null) {
            component.setFont(component.getFont().deriveFont(style, fontSize));
        }
        return (C)component;
    }

    public static String getFontName(Component component) {
        if (component != null && component.getFont() != null) {
            return component.getFont().getFontName();
        }
        return null;
    }

    public static <C extends Component> C setFontName(Component component, String fontName) {
        if (component != null && component.getFont() != null) {
            Font oldFont = component.getFont();
            component.setFont(new Font(fontName, oldFont.getStyle(), oldFont.getSize()));
        }
        return (C)component;
    }
}

