/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing.extensions;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.BiFunction;
import com.alee.api.jdk.Function;
import com.alee.utils.swing.WeakComponentData;
import java.awt.Dimension;
import javax.swing.JComponent;

public final class SizeMethodsImpl {
    private static final WeakComponentData<JComponent, Dimension> minimumSizeCache = new WeakComponentData("SizeMethodsImpl.minimumSize", 5);
    private static final WeakComponentData<JComponent, Dimension> maximumSizeCache = new WeakComponentData("SizeMethodsImpl.maximumSize", 5);
    private static final WeakComponentData<JComponent, Dimension> preferredSizeCache = new WeakComponentData("SizeMethodsImpl.preferredSize", 50);

    public static int getPreferredWidth(@NotNull JComponent component) {
        Dimension ps = (Dimension)preferredSizeCache.get(component);
        return ps != null ? ps.width : -1;
    }

    @NotNull
    public static <C extends JComponent> C setPreferredWidth(@NotNull JComponent component, final int preferredWidth) {
        preferredSizeCache.modify(component, (BiFunction)new BiFunction<JComponent, Dimension, Dimension>(){

            public Dimension apply(@NotNull JComponent component, @NotNull Dimension dimension) {
                return new Dimension(preferredWidth, dimension.height);
            }
        }, (Function)new Function<JComponent, Dimension>(){

            public Dimension apply(@NotNull JComponent component) {
                return new Dimension(preferredWidth, -1);
            }
        });
        return (C)component;
    }

    public static int getPreferredHeight(@NotNull JComponent component) {
        Dimension ps = (Dimension)preferredSizeCache.get(component);
        return ps != null ? ps.height : -1;
    }

    @NotNull
    public static <C extends JComponent> C setPreferredHeight(@NotNull JComponent component, final int preferredHeight) {
        preferredSizeCache.modify(component, (BiFunction)new BiFunction<JComponent, Dimension, Dimension>(){

            public Dimension apply(@NotNull JComponent component, @NotNull Dimension dimension) {
                return new Dimension(dimension.width, preferredHeight);
            }
        }, (Function)new Function<JComponent, Dimension>(){

            public Dimension apply(@NotNull JComponent component) {
                return new Dimension(-1, preferredHeight);
            }
        });
        return (C)component;
    }

    @NotNull
    public static Dimension getPreferredSize(@NotNull JComponent component, @NotNull Dimension originalPreferredSize) {
        Dimension preferredSize = new Dimension(originalPreferredSize);
        Dimension ps = (Dimension)preferredSizeCache.get(component);
        Dimension min = (Dimension)minimumSizeCache.get(component);
        Dimension max = (Dimension)maximumSizeCache.get(component);
        if (ps != null && ps.width != -1) {
            preferredSize.width = ps.width;
        } else {
            if (min != null && min.width != -1) {
                preferredSize.width = Math.max(min.width, preferredSize.width);
            }
            if (max != null && max.width != -1) {
                preferredSize.width = Math.min(preferredSize.width, max.width);
            }
        }
        if (ps != null && ps.height != -1) {
            preferredSize.height = ps.height;
        } else {
            if (min != null && min.height != -1) {
                preferredSize.height = Math.max(min.height, preferredSize.height);
            }
            if (max != null && max.height != -1) {
                preferredSize.height = Math.min(preferredSize.height, max.height);
            }
        }
        return preferredSize;
    }

    @NotNull
    public static Dimension getOriginalPreferredSize(@NotNull JComponent component, @NotNull Dimension originalPreferredSize) {
        return originalPreferredSize;
    }

    @NotNull
    public static <C extends JComponent> C setPreferredSize(@NotNull JComponent component, int width, int height) {
        component.setPreferredSize(new Dimension(width, height));
        return (C)component;
    }

    public static int getMaximumWidth(JComponent component) {
        Dimension ms = (Dimension)maximumSizeCache.get(component);
        return ms != null ? ms.width : -1;
    }

    @NotNull
    public static <C extends JComponent> C setMaximumWidth(@NotNull JComponent component, final int maximumWidth) {
        maximumSizeCache.modify(component, (BiFunction)new BiFunction<JComponent, Dimension, Dimension>(){

            public Dimension apply(@NotNull JComponent component, @NotNull Dimension dimension) {
                return new Dimension(maximumWidth, dimension.height);
            }
        }, (Function)new Function<JComponent, Dimension>(){

            public Dimension apply(@NotNull JComponent component) {
                return new Dimension(maximumWidth, -1);
            }
        });
        return (C)component;
    }

    public static int getMaximumHeight(@NotNull JComponent component) {
        Dimension ms = (Dimension)maximumSizeCache.get(component);
        return ms != null ? ms.height : -1;
    }

    @NotNull
    public static <C extends JComponent> C setMaximumHeight(@NotNull JComponent component, final int maximumHeight) {
        maximumSizeCache.modify(component, (BiFunction)new BiFunction<JComponent, Dimension, Dimension>(){

            public Dimension apply(@NotNull JComponent component, @NotNull Dimension dimension) {
                return new Dimension(dimension.width, maximumHeight);
            }
        }, (Function)new Function<JComponent, Dimension>(){

            public Dimension apply(@NotNull JComponent component) {
                return new Dimension(-1, maximumHeight);
            }
        });
        return (C)component;
    }

    @NotNull
    public static Dimension getMaximumSize(@NotNull JComponent component, @NotNull Dimension originalMaximumSize) {
        Dimension maximumSize = new Dimension(originalMaximumSize);
        Dimension max = (Dimension)maximumSizeCache.get(component);
        if (max != null && max.width != -1) {
            maximumSize.width = max.width;
        }
        if (max != null && max.height != -1) {
            maximumSize.height = max.height;
        }
        return maximumSize;
    }

    @NotNull
    public static Dimension getOriginalMaximumSize(@NotNull JComponent component, @NotNull Dimension originalMaximumSize) {
        return originalMaximumSize;
    }

    @NotNull
    public static <C extends JComponent> C setMaximumSize(@NotNull JComponent component, int width, int height) {
        component.setMaximumSize(new Dimension(width, height));
        return (C)component;
    }

    public static int getMinimumWidth(@NotNull JComponent component) {
        Dimension ms = (Dimension)minimumSizeCache.get(component);
        return ms != null ? ms.width : -1;
    }

    @NotNull
    public static <C extends JComponent> C setMinimumWidth(@NotNull JComponent component, final int minimumWidth) {
        minimumSizeCache.modify(component, (BiFunction)new BiFunction<JComponent, Dimension, Dimension>(){

            public Dimension apply(@NotNull JComponent component, @NotNull Dimension dimension) {
                return new Dimension(minimumWidth, dimension.height);
            }
        }, (Function)new Function<JComponent, Dimension>(){

            public Dimension apply(@NotNull JComponent component) {
                return new Dimension(minimumWidth, -1);
            }
        });
        return (C)component;
    }

    public static int getMinimumHeight(@NotNull JComponent component) {
        Dimension ms = (Dimension)minimumSizeCache.get(component);
        return ms != null ? ms.height : -1;
    }

    @NotNull
    public static <C extends JComponent> C setMinimumHeight(@NotNull JComponent component, final int minimumHeight) {
        minimumSizeCache.modify(component, (BiFunction)new BiFunction<JComponent, Dimension, Dimension>(){

            public Dimension apply(@NotNull JComponent component, @NotNull Dimension dimension) {
                return new Dimension(dimension.width, minimumHeight);
            }
        }, (Function)new Function<JComponent, Dimension>(){

            public Dimension apply(@NotNull JComponent component) {
                return new Dimension(-1, minimumHeight);
            }
        });
        return (C)component;
    }

    @NotNull
    public static Dimension getMinimumSize(@NotNull JComponent component, @NotNull Dimension originalMinimumSize) {
        Dimension minimumSize = new Dimension(originalMinimumSize);
        Dimension min = (Dimension)minimumSizeCache.get(component);
        if (min != null && min.width != -1) {
            minimumSize.width = min.width;
        }
        if (min != null && min.height != -1) {
            minimumSize.height = min.height;
        }
        return minimumSize;
    }

    @NotNull
    public static Dimension getOriginalMinimumSize(@NotNull JComponent component, @NotNull Dimension originalMinimumSize) {
        return originalMinimumSize;
    }

    @NotNull
    public static <C extends JComponent> C setMinimumSize(@NotNull JComponent component, int width, int height) {
        component.setMinimumSize(new Dimension(width, height));
        return (C)component;
    }
}

