/*
 * Decompiled with CFR 0.152.
 */
package com.wefika.flowlayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import com.wefika.flowlayout.R;
import java.util.ArrayList;
import java.util.List;

public class FlowLayout
extends ViewGroup {
    private int mGravity = 0x800033;

    public FlowLayout(Context context) {
        super(context);
    }

    public FlowLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FlowLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FlowLayout, defStyle, 0);
        int index = a.getInt(0, -1);
        if (index > 0) {
            this.setGravity(index);
        }
        a.recycle();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        ArrayList lines = new ArrayList();
        ArrayList<Integer> lineHeights = new ArrayList<Integer>();
        ArrayList<Integer> lineMargins = new ArrayList<Integer>();
        int width = this.getWidth();
        int height = this.getHeight();
        int linesSum = 0;
        int lineWidth = 0;
        int lineHeight = 0;
        List lineViews = new ArrayList<View>();
        float horizontalGravityFactor = 0.0f;
        switch (this.mGravity & 7) {
            default: {
                break;
            }
            case 1: {
                horizontalGravityFactor = 0.5f;
                break;
            }
            case 5: {
                horizontalGravityFactor = 1.0f;
            }
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childWidth = child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
            int childHeight = child.getMeasuredHeight() + lp.bottomMargin + lp.topMargin;
            if (lineWidth + childWidth > width) {
                lineHeights.add(lineHeight);
                lines.add(lineViews);
                lineMargins.add((int)((float)(width - lineWidth) * horizontalGravityFactor));
                linesSum += lineHeight;
                lineHeight = 0;
                lineWidth = 0;
                lineViews = new ArrayList();
            }
            lineWidth += childWidth;
            lineHeight = Math.max(lineHeight, childHeight);
            lineViews.add(child);
        }
        lineHeights.add(lineHeight);
        lines.add(lineViews);
        lineMargins.add((int)((float)(width - lineWidth) * horizontalGravityFactor));
        linesSum += lineHeight;
        int verticalGravityMargin = 0;
        switch (this.mGravity & 0x70) {
            default: {
                break;
            }
            case 16: {
                verticalGravityMargin = (height - linesSum) / 2;
                break;
            }
            case 80: {
                verticalGravityMargin = height - linesSum;
            }
        }
        int numLines = lineHeights.size();
        int top = 0;
        for (int i = 0; i < numLines; ++i) {
            lineHeight = (Integer)lineHeights.get(i);
            lineViews = (List)lines.get(i);
            int left = (Integer)lineMargins.get(i);
            int children = lineViews.size();
            for (int j = 0; j < children; ++j) {
                View child = (View)lineViews.get(j);
                if (child.getVisibility() == 8) continue;
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp.height == -1) {
                    int childWidthMode = Integer.MIN_VALUE;
                    int childWidthSize = lineWidth;
                    if (lp.width == -1) {
                        childWidthMode = 0x40000000;
                    } else if (lp.width >= 0) {
                        childWidthMode = 0x40000000;
                        childWidthSize = lp.width;
                    }
                    child.measure(View.MeasureSpec.makeMeasureSpec((int)childWidthSize, (int)childWidthMode), View.MeasureSpec.makeMeasureSpec((int)(lineHeight - lp.topMargin - lp.bottomMargin), (int)0x40000000));
                }
                int childWidth = child.getMeasuredWidth();
                int childHeight = child.getMeasuredHeight();
                int gravityMargin = 0;
                if (Gravity.isVertical((int)lp.gravity)) {
                    switch (lp.gravity) {
                        default: {
                            break;
                        }
                        case 16: 
                        case 17: {
                            gravityMargin = (lineHeight - childHeight - lp.topMargin - lp.bottomMargin) / 2;
                            break;
                        }
                        case 80: {
                            gravityMargin = lineHeight - childHeight - lp.topMargin - lp.bottomMargin;
                        }
                    }
                }
                child.layout(left + lp.leftMargin, top + lp.topMargin + gravityMargin + verticalGravityMargin, left + childWidth + lp.leftMargin, top + childHeight + lp.topMargin + gravityMargin + verticalGravityMargin);
                left += childWidth + lp.leftMargin + lp.rightMargin;
            }
            top += lineHeight;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int sizeWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int sizeHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int modeWidth = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int modeHeight = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int width = 0;
        int height = 0;
        int lineWidth = 0;
        int lineHeight = 0;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childWidthMode = Integer.MIN_VALUE;
            int childWidthSize = sizeWidth;
            int childHeightMode = Integer.MIN_VALUE;
            int childHeightSize = sizeHeight;
            if (lp.width == -1) {
                childWidthMode = 0x40000000;
                childWidthSize -= lp.leftMargin + lp.rightMargin;
            } else if (lp.width >= 0) {
                childWidthMode = 0x40000000;
                childWidthSize = lp.width;
            }
            if (lp.height >= 0) {
                childHeightMode = 0x40000000;
                childHeightSize = lp.height;
            }
            child.measure(View.MeasureSpec.makeMeasureSpec((int)childWidthSize, (int)childWidthMode), View.MeasureSpec.makeMeasureSpec((int)childHeightSize, (int)childHeightMode));
            int childWidth = child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
            if (lineWidth + childWidth > sizeWidth) {
                width = Math.max(width, lineWidth);
                lineWidth = childWidth;
                height += lineHeight;
                lineHeight = Math.max(lineHeight, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            } else {
                lineWidth += childWidth;
                lineHeight = Math.max(lineHeight, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            }
            if (i != childCount - 1) continue;
            width = Math.max(width, lineWidth);
            height += lineHeight;
        }
        this.setMeasuredDimension(modeWidth == 0x40000000 ? sizeWidth : width, modeHeight == 0x40000000 ? sizeHeight : height);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            if ((gravity & 0x800007) == 0) {
                gravity |= 0x800003;
            }
            if ((gravity & 0x70) == 0) {
                gravity |= 0x30;
            }
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    public class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public int gravity;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            this.gravity = -1;
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.FlowLayout_Layout);
            this.gravity = a.getInt(0, -1);
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
            this.gravity = -1;
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
            this.gravity = -1;
        }
    }
}

