/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze;

import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.BreezeWriter;
import com.weibo.breeze.SchemaLoader;
import com.weibo.breeze.message.GenericMessage;
import com.weibo.breeze.message.Message;
import com.weibo.breeze.message.Schema;
import com.weibo.breeze.message.SchemaDesc;
import com.weibo.breeze.serializer.BigDecimalSerializer;
import com.weibo.breeze.serializer.BigIntegerSerializer;
import com.weibo.breeze.serializer.CommonSerializer;
import com.weibo.breeze.serializer.DateSerializer;
import com.weibo.breeze.serializer.EnumSerializer;
import com.weibo.breeze.serializer.Serializer;
import com.weibo.breeze.serializer.SerializerFactory;
import com.weibo.breeze.serializer.TimestampSerializer;
import com.weibo.breeze.type.BreezeType;
import com.weibo.breeze.type.TypeMessage;
import com.weibo.breeze.type.TypePackedArray;
import com.weibo.breeze.type.TypePackedMap;
import com.weibo.breeze.type.TypePlaceHolder;
import com.weibo.breeze.type.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Breeze {
    public static final String BREEZE_SERIALIZER_SUFFIX = "BreezeSerializer";
    private static final Logger logger = LoggerFactory.getLogger(Breeze.class);
    private static final ThreadLocal<Set<String>> GET_SERIALIZER_SET = ThreadLocal.withInitial(HashSet::new);
    private static final ConcurrentHashMap<String, Message> messageInstanceMap = new ConcurrentHashMap(128);
    private static final Serializer[] defaultSerializers = new Serializer[]{new DateSerializer(), new BigDecimalSerializer(), new TimestampSerializer(), new BigIntegerSerializer()};
    private static final List<SerializerResolver> extResolver = new ArrayList<SerializerResolver>();
    public static int MAX_ELEM_SIZE = 100000;
    private static SerializerFactory serializerFactory = new DefaultSerializerFactory();

    public static Serializer getSerializer(Class clz) {
        return Breeze.getSerializerFactory().getSerializer(clz);
    }

    public static Serializer getSerializer(String name) {
        return Breeze.getSerializerFactory().getSerializer(name);
    }

    public static void registerSerializer(Serializer serializer) throws BreezeException {
        Breeze.getSerializerFactory().registerSerializer(serializer);
    }

    public static void registerSerializer(String name, Serializer serializer) throws BreezeException {
        Breeze.getSerializerFactory().registerSerializer(name, serializer);
    }

    public static void registerSchema(SchemaDesc schemaDesc) throws BreezeException {
        for (Schema schema : schemaDesc.getSchemas()) {
            Breeze.registerSerializer(new CommonSerializer(schema));
        }
    }

    public static SerializerFactory getSerializerFactory() {
        return serializerFactory;
    }

    public static void setSerializerFactory(SerializerFactory serializerFactory) {
        Breeze.serializerFactory = serializerFactory;
    }

    public static void addResolver(SerializerResolver resolver) {
        if (resolver != null) {
            extResolver.add(resolver);
        }
    }

    public static Message getMessageInstance(String name) {
        Message message = messageInstanceMap.get(name);
        if (message != null && message != NoMessage.instance) {
            return message.defaultInstance();
        }
        if (message == null) {
            try {
                Class<?> clz = Class.forName(name, true, Thread.currentThread().getContextClassLoader());
                if (Message.class.isAssignableFrom(clz)) {
                    messageInstanceMap.put(name, (Message)clz.newInstance());
                    return messageInstanceMap.get(name).defaultInstance();
                }
            }
            catch (ReflectiveOperationException ignore) {
                messageInstanceMap.put(name, NoMessage.instance);
            }
        }
        return null;
    }

    public static Message putMessageInstance(String name, Message message) {
        return messageInstanceMap.put(name, message);
    }

    public static void withStaticField(boolean with) {
        CommonSerializer.WITH_STATIC_FIELD = with;
    }

    public static boolean withStaticField() {
        return CommonSerializer.WITH_STATIC_FIELD;
    }

    public static int getMaxWriteCount() {
        return BreezeWriter.MAX_WRITE_COUNT;
    }

    public static void setMaxWriteCount(int maxWriteCount) {
        BreezeWriter.MAX_WRITE_COUNT = maxWriteCount;
    }

    public static boolean preLoadSchemas() {
        return SchemaLoader.loadAllSchema();
    }

    public static String getCleanName(String name) {
        if (name.contains("$")) {
            name = name.replaceAll("\\$", "");
        }
        return name;
    }

    public static BreezeType getBreezeType(Class clz, String fieldName) throws BreezeException {
        try {
            return Breeze.getBreezeType(clz.getDeclaredField(fieldName).getGenericType());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static BreezeType getBreezeTypeByObject(Object object) throws BreezeException {
        if (object == null) {
            throw new BreezeException("can not get breeze type by null object");
        }
        if (object instanceof GenericMessage) {
            return new TypeMessage((Message)object);
        }
        BreezeType breezeType = Breeze.getBreezeType(object.getClass());
        if (breezeType == null) {
            throw new BreezeException("can not get breeze type by " + object.getClass().getName());
        }
        return breezeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BreezeType getBreezeType(Type type) throws BreezeException {
        Class clz;
        ParameterizedType pt = null;
        if (type instanceof Class) {
            clz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            pt = (ParameterizedType)type;
            clz = (Class)pt.getRawType();
        } else {
            return null;
        }
        if (Message.class.isAssignableFrom(clz)) {
            return new TypeMessage(clz);
        }
        if (clz == String.class) {
            return Types.TYPE_STRING;
        }
        if (clz == Integer.class || clz == Integer.TYPE) {
            return Types.TYPE_INT32;
        }
        if (Map.class.isAssignableFrom(clz)) {
            if (pt != null && pt.getActualTypeArguments().length == 2) {
                try {
                    return new TypePackedMap(pt.getActualTypeArguments()[0], pt.getActualTypeArguments()[1]);
                }
                catch (BreezeException e) {
                    return Types.TYPE_MAP;
                }
            }
            if (BreezeWriter.IS_PACK) {
                return new TypePackedMap();
            }
            return Types.TYPE_MAP;
        }
        if (Collection.class.isAssignableFrom(clz)) {
            if (pt != null && pt.getActualTypeArguments().length == 1) {
                try {
                    return new TypePackedArray(pt.getActualTypeArguments()[0]);
                }
                catch (BreezeException e) {
                    return Types.TYPE_ARRAY;
                }
            }
            if (BreezeWriter.IS_PACK) {
                return new TypePackedArray();
            }
            return Types.TYPE_ARRAY;
        }
        if (clz == Boolean.class || clz == Boolean.TYPE) {
            return Types.TYPE_BOOL;
        }
        if (clz == Long.class || clz == Long.TYPE) {
            return Types.TYPE_INT64;
        }
        if (clz == Float.class || clz == Float.TYPE) {
            return Types.TYPE_FLOAT32;
        }
        if (clz == Double.class || clz == Double.TYPE) {
            return Types.TYPE_FLOAT64;
        }
        if (clz == Byte.class || clz == Byte.TYPE) {
            return Types.TYPE_BYTE;
        }
        if (clz == Short.class || clz == Short.TYPE) {
            return Types.TYPE_INT16;
        }
        if (clz.isArray()) {
            if (clz.getComponentType() == Byte.TYPE) {
                return Types.TYPE_BYTE_ARRAY;
            }
            return new TypePackedArray();
        }
        if (GET_SERIALIZER_SET.get().contains(clz.getName())) {
            return new TypePlaceHolder(clz);
        }
        try {
            GET_SERIALIZER_SET.get().add(clz.getName());
            Serializer serializer = Breeze.getSerializer(clz);
            if (serializer != null) {
                TypeMessage typeMessage = new TypeMessage(serializer);
                return typeMessage;
            }
            BreezeType breezeType = null;
            return breezeType;
        }
        finally {
            GET_SERIALIZER_SET.get().remove(clz.getName());
        }
    }

    static {
        for (Serializer serializer : defaultSerializers) {
            try {
                Breeze.registerSerializer(serializer);
            }
            catch (BreezeException e) {
                logger.warn("register default breeze serializer fail. serializer:{}, e:{}", (Object)serializer.getClass().getName(), (Object)e.getMessage());
            }
        }
        try {
            SerializerResolver protobufResolver = (SerializerResolver)Class.forName("com.weibo.breeze.protobuf.ProtoBufResolver").newInstance();
            Breeze.addResolver(protobufResolver);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class DefaultSerializerFactory
    implements SerializerFactory {
        private final ConcurrentHashMap<String, Serializer> serializerMap = new ConcurrentHashMap(32);
        private final ConcurrentHashMap<String, Boolean> missedSerializers = new ConcurrentHashMap();

        private DefaultSerializerFactory() {
        }

        public static Serializer getSerializerClassByName(String className) {
            try {
                Class<?> serializerClass = Class.forName(Breeze.getCleanName(className) + Breeze.BREEZE_SERIALIZER_SUFFIX);
                if (Serializer.class.isAssignableFrom(serializerClass)) {
                    Serializer serializer = (Serializer)serializerClass.newInstance();
                    Breeze.registerSerializer(serializer);
                    return serializer;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Serializer getSerializer(Class clz) {
            if (clz != null) {
                String name = clz.getName();
                Serializer serializer = this.getSerializer(name);
                if (serializer != null) {
                    return serializer;
                }
                if (this.missedSerializers.containsKey(name)) {
                    return null;
                }
                String string = name.intern();
                synchronized (string) {
                    if (clz.isEnum()) {
                        try {
                            Class.forName(name);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    for (Class cur = clz; cur != null && cur != Object.class; cur = cur.getSuperclass()) {
                        serializer = this.getSerializer(cur.getName());
                        if (serializer != null) {
                            return serializer;
                        }
                        serializer = DefaultSerializerFactory.getSerializerClassByName(cur.getName());
                        if (serializer == null) continue;
                        return serializer;
                    }
                    if (clz.isEnum()) {
                        try {
                            serializer = new EnumSerializer(clz);
                            this.registerSerializer(serializer);
                            return serializer;
                        }
                        catch (BreezeException e) {
                            logger.warn("create enum serializer fail. clz:{}, e:{}", (Object)name, (Object)e.getMessage());
                            this.missedSerializers.put(name, false);
                            return null;
                        }
                    }
                    for (SerializerResolver resolver : extResolver) {
                        serializer = resolver.getSerializer(clz);
                        if (serializer == null) continue;
                        try {
                            this.registerSerializer(serializer);
                            return serializer;
                        }
                        catch (BreezeException e) {
                            logger.warn("register ext serializer fail. clz:{}, e:{}", (Object)name, (Object)e.getMessage());
                        }
                    }
                    if (clz != Object.class && !clz.isInterface()) {
                        try {
                            Schema schema = SchemaLoader.loadSchema(name);
                            CommonSerializer commonSerializer = schema != null ? new CommonSerializer(schema) : new CommonSerializer(clz);
                            this.registerSerializer(commonSerializer);
                            return commonSerializer;
                        }
                        catch (BreezeException e) {
                            Class<?>[] interfaces;
                            logger.warn("create common serializer fail. clz:{}, e:{}", (Object)name, (Object)e.getMessage());
                            for (Class<?> interfaceClass : interfaces = clz.getInterfaces()) {
                                serializer = this.getSerializer(interfaceClass.getName());
                                if (serializer == null) continue;
                                return serializer;
                            }
                        }
                    }
                }
                this.missedSerializers.put(name, false);
            }
            return null;
        }

        @Override
        public Serializer getSerializer(String name) {
            return this.serializerMap.get(name);
        }

        @Override
        public Serializer removeSerializer(String name) {
            return this.serializerMap.remove(name);
        }

        @Override
        public void registerSerializer(Serializer serializer) throws BreezeException {
            if (serializer != null) {
                for (String name : serializer.getNames()) {
                    this.registerSerializer(name, serializer);
                }
            }
        }

        @Override
        public void registerSerializer(String name, Serializer serializer) throws BreezeException {
            if (serializer == null) {
                throw new BreezeException("serializer is null. name: " + name);
            }
            Serializer old = this.serializerMap.put(name, serializer);
            if (old != null) {
                logger.warn("DefaultSerializerFactory-serializer name {}: {} replaced by {}", new Object[]{name, old.getClass(), serializer.getClass()});
            }
            logger.info("register breeze serializer:" + name);
        }

        @Override
        public Map<String, Serializer> getSerializers() {
            return Collections.unmodifiableMap(this.serializerMap);
        }
    }

    private static class NoMessage
    implements Message {
        static final NoMessage instance = new NoMessage();

        private NoMessage() {
        }

        @Override
        public void writeToBuf(BreezeBuffer buffer) throws BreezeException {
        }

        @Override
        public Message readFromBuf(BreezeBuffer buffer) throws BreezeException {
            return null;
        }

        @Override
        public String messageName() {
            return null;
        }

        @Override
        public String messageAlias() {
            return null;
        }

        @Override
        public Message defaultInstance() {
            return null;
        }

        @Override
        public Schema schema() {
            return null;
        }
    }

    public static interface SerializerResolver {
        public Serializer getSerializer(Class<?> var1);
    }
}

