/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze;

import com.weibo.breeze.Breeze;
import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.SchemaLoader;
import com.weibo.breeze.message.GenericMessage;
import com.weibo.breeze.message.Message;
import com.weibo.breeze.message.Schema;
import com.weibo.breeze.serializer.CommonSerializer;
import com.weibo.breeze.serializer.Serializer;
import com.weibo.breeze.type.BreezeType;
import com.weibo.breeze.type.TypeByte;
import com.weibo.breeze.type.TypeByteArray;
import com.weibo.breeze.type.TypeFloat32;
import com.weibo.breeze.type.TypeFloat64;
import com.weibo.breeze.type.TypeInt16;
import com.weibo.breeze.type.TypeInt32;
import com.weibo.breeze.type.TypeInt64;
import com.weibo.breeze.type.TypeMap;
import com.weibo.breeze.type.TypeMessage;
import com.weibo.breeze.type.TypePackedArray;
import com.weibo.breeze.type.TypePackedMap;
import com.weibo.breeze.type.TypeString;
import com.weibo.breeze.type.Types;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class BreezeReader {
    public static Boolean readBool(BreezeBuffer buffer) throws BreezeException {
        return (Boolean)Types.TYPE_BOOL.read(buffer);
    }

    public static Byte readByte(BreezeBuffer buffer) throws BreezeException {
        return (Byte)Types.TYPE_BYTE.read(buffer);
    }

    public static Short readInt16(BreezeBuffer buffer) throws BreezeException {
        return (Short)Types.TYPE_INT16.read(buffer);
    }

    public static Integer readInt32(BreezeBuffer buffer) throws BreezeException {
        return (Integer)Types.TYPE_INT32.read(buffer);
    }

    public static Long readInt64(BreezeBuffer buffer) throws BreezeException {
        return (Long)Types.TYPE_INT64.read(buffer);
    }

    public static Float readFloat32(BreezeBuffer buffer) throws BreezeException {
        return (Float)Types.TYPE_FLOAT32.read(buffer);
    }

    public static Double readFloat64(BreezeBuffer buffer) throws BreezeException {
        return (Double)Types.TYPE_FLOAT64.read(buffer);
    }

    public static String readString(BreezeBuffer buffer) throws BreezeException {
        return (String)Types.TYPE_STRING.read(buffer);
    }

    public static byte[] readBytes(BreezeBuffer buffer) throws BreezeException {
        return (byte[])Types.TYPE_BYTE_ARRAY.read(buffer);
    }

    public static <T, K> void readMap(BreezeBuffer buffer, Map<T, K> map, Type keyType, Type valueType) throws BreezeException {
        byte type = buffer.get();
        if (type != -39 && type != -37) {
            throw new BreezeException("cannot read to map. type:" + type);
        }
        BreezeReader.readMapWithoutType(buffer, map, keyType, valueType, type == -37);
    }

    public static <T> void readCollection(BreezeBuffer buffer, Collection<T> collection, Type valueType) throws BreezeException {
        byte type = buffer.get();
        if (type != -38 && type != -36) {
            throw new BreezeException("cannot read to collection. type:" + type);
        }
        int size = (int)buffer.getVarint();
        BreezeReader.readCollectionWithoutType(buffer, collection, valueType, size, type == -36);
    }

    public static Message readMessage(BreezeBuffer buffer, Class<? extends Message> clz) throws BreezeException {
        byte type = buffer.get();
        if (type == -103) {
            return null;
        }
        String name = BreezeReader.readMessageName(buffer, type);
        return BreezeReader.readMessageWithoutType(buffer, clz, name);
    }

    public static void readMessage(BreezeBuffer buffer, ReadField readField) throws BreezeException {
        int size = BreezeReader.getAndCheckSize(buffer);
        if (size == 0) {
            return;
        }
        int startPos = buffer.position();
        int endPos = startPos + size;
        while (buffer.position() < endPos) {
            int index = (int)buffer.getVarint();
            readField.readIndexField(index);
        }
        if (buffer.position() != endPos) {
            throw new BreezeException("Breeze deserialize wrong message size, except: " + size + " actual: " + (buffer.position() - startPos));
        }
    }

    public static Schema readSchema(BreezeBuffer buffer, boolean withType) throws BreezeException {
        throw new BreezeException("todo: read schema");
    }

    public static void checkType(BreezeBuffer buffer, byte type) throws BreezeException {
        byte bufType = buffer.get();
        if (bufType != type) {
            throw new BreezeException("message type not correct. expect type:" + type + ", real type:" + bufType);
        }
    }

    public static <T> T readObject(BreezeBuffer buffer, Class<T> clz) throws BreezeException {
        return (T)BreezeReader.readObjectByType(buffer, clz);
    }

    public static Object readObjectByType(BreezeBuffer buffer, Type type) throws BreezeException {
        Class<Cloneable> clz;
        if (type == null) {
            type = Object.class;
        }
        ParameterizedType pt = null;
        if (type instanceof Class) {
            clz = (Class<Cloneable>)type;
        } else if (type instanceof ParameterizedType) {
            pt = (ParameterizedType)type;
            clz = (Class)pt.getRawType();
        } else {
            throw new BreezeException("unknown read type :" + type);
        }
        byte bType = buffer.get();
        if (bType >= 0 && bType <= 63) {
            String string = bType == 63 ? TypeString.readString(buffer) : TypeString.readString(buffer, bType);
            if (clz == String.class || clz == Object.class) {
                return string;
            }
            return BreezeReader.adaptFromString(string, clz);
        }
        if (bType >= 64 && bType <= 127) {
            Integer integer = bType == 127 ? Integer.valueOf(TypeInt32.readInt32(buffer)) : Integer.valueOf(bType - 80);
            if (clz == Integer.TYPE || clz == Integer.class || clz == Object.class) {
                return integer;
            }
            return BreezeReader.adaptFromNumber(integer, clz);
        }
        if (bType >= -128 && bType <= -104) {
            Long aLong = bType == -104 ? Long.valueOf(TypeInt64.readInt64(buffer)) : Long.valueOf(bType - -120);
            if (clz == Long.TYPE || clz == Long.class || clz == Object.class) {
                return aLong;
            }
            return BreezeReader.adaptFromNumber(aLong, clz);
        }
        if (bType >= -34 && bType <= -1) {
            Serializer serializer;
            String name = BreezeReader.readMessageName(buffer, bType);
            if (Message.class.isAssignableFrom(clz)) {
                return BreezeReader.readMessageWithoutType(buffer, (Class<? extends Message>)clz, name);
            }
            if (clz == Object.class || clz.isInterface()) {
                Schema schema22;
                Message message = Breeze.getMessageInstance(name);
                if (message != null) {
                    return message.readFromBuf(buffer);
                }
                serializer = Breeze.getSerializer(name);
                if (serializer == null && (schema22 = SchemaLoader.loadSchema(name)) != null) {
                    serializer = new CommonSerializer(schema22);
                    Breeze.registerSerializer(name, serializer);
                }
                if (serializer != null) {
                    return serializer.readFromBuf(buffer);
                }
                try {
                    clz = Class.forName(name);
                }
                catch (ClassNotFoundException schema22) {
                    // empty catch block
                }
                if (clz == Object.class) {
                    GenericMessage genericMessage = new GenericMessage();
                    genericMessage.setName(name);
                    genericMessage.readFromBuf(buffer);
                    return genericMessage;
                }
            }
            if ((serializer = Breeze.getSerializer(clz)) != null) {
                return serializer.readFromBuf(buffer);
            }
            throw new BreezeException("can not serialize message named " + name);
        }
        Object o = null;
        switch (bType) {
            case -102: {
                if (clz != Boolean.TYPE && clz != Boolean.class && clz != Object.class) break;
                return Boolean.TRUE;
            }
            case -101: {
                if (clz != Boolean.TYPE && clz != Boolean.class && clz != Object.class) break;
                return Boolean.FALSE;
            }
            case -39: 
            case -37: {
                Object keyType = Object.class;
                Object valueType = Object.class;
                if (pt != null && pt.getActualTypeArguments().length == 2) {
                    keyType = pt.getActualTypeArguments()[0];
                    valueType = pt.getActualTypeArguments()[1];
                }
                if (clz.isAssignableFrom(HashMap.class)) {
                    return BreezeReader.readMapWithoutType(buffer, null, keyType, valueType, bType == -37);
                }
                if (clz.isInterface() || !Map.class.isAssignableFrom(clz)) break;
                Map map = null;
                try {
                    map = (Map)clz.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (map == null) break;
                BreezeReader.readMapWithoutType(buffer, map, (Type)keyType, (Type)valueType, bType == -37);
                return map;
            }
            case -38: 
            case -36: {
                int size;
                Object valueType = Object.class;
                if (pt != null && pt.getActualTypeArguments().length == 1) {
                    valueType = pt.getActualTypeArguments()[0];
                }
                if ((size = (int)buffer.getVarint()) > Breeze.MAX_ELEM_SIZE) {
                    throw new BreezeException("breeze array size over limit. size" + size);
                }
                if (clz.isArray()) {
                    ArrayList list = new ArrayList(size);
                    BreezeReader.readCollectionWithoutType(buffer, list, clz.getComponentType(), size, bType == -36);
                    Object objects = Array.newInstance(clz.getComponentType(), list.size());
                    for (int i = 0; i < list.size(); ++i) {
                        Array.set(objects, i, list.get(i));
                    }
                    return objects;
                }
                if (clz.isAssignableFrom(ArrayList.class)) {
                    ArrayList list = new ArrayList(size);
                    BreezeReader.readCollectionWithoutType(buffer, list, (Type)valueType, size, bType == -36);
                    return list;
                }
                if (clz.isAssignableFrom(HashSet.class)) {
                    HashSet hs = new HashSet(TypeMap.calculateInitSize(size));
                    BreezeReader.readCollectionWithoutType(buffer, hs, (Type)valueType, size, bType == -36);
                    return hs;
                }
                if (clz.isInterface() || !Collection.class.isAssignableFrom(clz)) break;
                Collection collection = null;
                try {
                    collection = (Collection)clz.newInstance();
                }
                catch (Exception objects) {
                    // empty catch block
                }
                if (collection == null) break;
                BreezeReader.readCollectionWithoutType(buffer, collection, (Type)valueType, size, bType == -36);
                return collection;
            }
            case -103: {
                return null;
            }
            case -97: {
                Float aFloat = Float.valueOf(TypeFloat32.readFloat32(buffer));
                if (clz == Float.TYPE || clz == Float.class || clz == Object.class) {
                    return aFloat;
                }
                o = BreezeReader.adaptFromNumber(aFloat, clz);
                break;
            }
            case -96: {
                Double aDouble = TypeFloat64.readFloat64(buffer);
                if (clz == Double.TYPE || clz == Double.class || clz == Object.class) {
                    return aDouble;
                }
                o = BreezeReader.adaptFromNumber(aDouble, clz);
                break;
            }
            case -98: {
                Short aShort = TypeInt16.readInt16(buffer);
                if (clz == Short.TYPE || clz == Short.class || clz == Object.class) {
                    return aShort;
                }
                o = BreezeReader.adaptFromNumber(aShort, clz);
                break;
            }
            case -100: {
                Byte aByte = TypeByte.readByte(buffer);
                if (clz != Byte.TYPE && clz != Byte.class && clz != Object.class) break;
                return aByte;
            }
            case -99: {
                byte[] bytes = TypeByteArray.readBytes(buffer);
                if (clz != byte[].class && clz != Object.class) break;
                return bytes;
            }
            default: {
                throw new BreezeException("Breeze not support " + bType + " with receiver type:" + clz);
            }
        }
        if (o != null) {
            return o;
        }
        Serializer serializer = Breeze.getSerializer(clz);
        if (serializer != null) {
            return serializer.readFromBuf(buffer);
        }
        throw new BreezeException("Breeze not support " + bType + " with receiver type:" + clz);
    }

    private static <T> T adaptFromString(String string, Class<T> clz) throws BreezeException {
        if (clz == Boolean.TYPE || clz == Boolean.class) {
            return (T)Boolean.valueOf(string);
        }
        if (clz == byte[].class || clz == Object.class) {
            try {
                return (T)string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        if (clz == Short.TYPE || clz == Short.class) {
            return (T)Short.valueOf(string);
        }
        if (clz == Integer.TYPE || clz == Integer.class) {
            return (T)Integer.valueOf(string);
        }
        if (clz == Long.TYPE || clz == Long.class) {
            return (T)Long.valueOf(string);
        }
        if (clz == Float.TYPE || clz == Float.class) {
            return (T)Float.valueOf(string);
        }
        if (clz == Double.TYPE || clz == Double.class) {
            return (T)Double.valueOf(string);
        }
        if ((clz == Character.TYPE || clz == Character.class) && string.length() == 1) {
            return (T)new Character(string.charAt(0));
        }
        throw new BreezeException("can not convert string to class:" + clz);
    }

    public static <T> T adaptFromNumber(Number number, Class<T> clz) throws BreezeException {
        if (clz == Integer.TYPE || clz == Integer.class) {
            return (T)Integer.valueOf(number.intValue());
        }
        if (clz == Long.TYPE || clz == Long.class) {
            return (T)Long.valueOf(number.longValue());
        }
        if (clz == Short.TYPE || clz == Short.class) {
            return (T)Short.valueOf(number.shortValue());
        }
        if (clz == Float.TYPE || clz == Float.class) {
            return (T)Float.valueOf(number.floatValue());
        }
        if (clz == Double.TYPE || clz == Double.class) {
            return (T)Double.valueOf(number.doubleValue());
        }
        throw new BreezeException("can not convert number to class:" + clz);
    }

    private static <T, K> Map<T, K> readMapWithoutType(BreezeBuffer buffer, Map<T, K> map, Type keyType, Type valueType, boolean isPacked) throws BreezeException {
        if (isPacked) {
            return new TypePackedMap().read(buffer, map, keyType, valueType, false);
        }
        return Types.TYPE_MAP.read(buffer, map, keyType, valueType, false);
    }

    private static <T> void readCollectionWithoutType(BreezeBuffer buffer, Collection<T> collection, Type type, int size, boolean isPacked) throws BreezeException {
        if (isPacked) {
            new TypePackedArray().readBySize(buffer, collection, type, size, true);
        } else {
            Types.TYPE_ARRAY.readBySize(buffer, collection, type, size);
        }
    }

    private static Message readMessageWithoutType(BreezeBuffer buffer, Class<? extends Message> clz, String name) throws BreezeException {
        Message message;
        try {
            message = clz.newInstance();
        }
        catch (Exception e) {
            throw new BreezeException("create new default Message fail. Message must have a constructor without arguments. e:" + e.getMessage());
        }
        if (name != null && (name.equalsIgnoreCase(message.messageName()) || name.equalsIgnoreCase(message.messageAlias()))) {
            return message.readFromBuf(buffer);
        }
        throw new BreezeException("message name not correct. message clase:" + message.getClass().getName() + ", serialized name:" + name);
    }

    public static int getAndCheckSize(BreezeBuffer buffer) throws BreezeException {
        int size = buffer.getInt();
        if (size > buffer.remaining()) {
            throw new BreezeException("Breeze deserialize fail! buffer not enough!need size:" + size);
        }
        return size;
    }

    public static void skipType(BreezeBuffer buffer) throws BreezeException {
        byte type = buffer.get();
        if (type == -34) {
            buffer.getContext().putMessageType(TypeString.readString(buffer));
        } else if (type == -33) {
            buffer.getVarint();
        }
    }

    public static BreezeType readBreezeType(BreezeBuffer buffer, Type type) throws BreezeException {
        byte bType = buffer.get();
        if (bType == -34 || bType >= -33 && bType <= -1) {
            Class<?> clz;
            if (type == null) {
                type = Object.class;
            }
            if (type instanceof Class) {
                clz = (Class<?>)type;
            } else if (type instanceof ParameterizedType) {
                clz = (Class)((ParameterizedType)type).getRawType();
            } else {
                throw new BreezeException("unknown read type :" + type);
            }
            String name = BreezeReader.readMessageName(buffer, bType);
            if (clz == Object.class || clz.isInterface()) {
                Schema schema22;
                Message message = Breeze.getMessageInstance(name);
                if (message != null) {
                    return new TypeMessage(message);
                }
                CommonSerializer serializer = Breeze.getSerializer(name);
                if (serializer == null && (schema22 = SchemaLoader.loadSchema(name)) != null) {
                    serializer = new CommonSerializer(schema22);
                    Breeze.registerSerializer(name, serializer);
                }
                if (serializer != null) {
                    return new TypeMessage(serializer);
                }
                try {
                    clz = Class.forName(name);
                }
                catch (ClassNotFoundException schema22) {
                    // empty catch block
                }
                if (clz == Object.class) {
                    GenericMessage genericMessage = new GenericMessage();
                    genericMessage.setName(name);
                    return new TypeMessage(genericMessage);
                }
            }
            return new TypeMessage(clz);
        }
        switch (bType) {
            case 63: {
                return Types.TYPE_STRING;
            }
            case 127: {
                return Types.TYPE_INT32;
            }
            case -102: {
                return Types.TYPE_BOOL;
            }
            case -104: {
                return Types.TYPE_INT64;
            }
            case -39: {
                return Types.TYPE_MAP;
            }
            case -37: {
                return new TypePackedMap();
            }
            case -38: {
                return Types.TYPE_ARRAY;
            }
            case -36: {
                return new TypePackedArray();
            }
            case -97: {
                return Types.TYPE_FLOAT32;
            }
            case -96: {
                return Types.TYPE_FLOAT64;
            }
            case -98: {
                return Types.TYPE_INT16;
            }
            case -100: {
                return Types.TYPE_BYTE;
            }
            case -99: {
                return Types.TYPE_BYTE_ARRAY;
            }
        }
        throw new BreezeException("can not read breeze type from buffer, type: " + bType);
    }

    public static String readMessageName(BreezeBuffer buffer, byte typeByte) throws BreezeException {
        String name = null;
        int index = 0;
        if (typeByte == -34) {
            name = TypeString.readString(buffer);
            buffer.getContext().putMessageType(name);
        } else if (typeByte == -33) {
            index = (int)buffer.getVarint();
        } else if (typeByte > -33 && typeByte <= -1) {
            index = typeByte - -33;
        } else {
            throw new BreezeException("message type not correct. type:" + typeByte);
        }
        if (index > 0 && (name = buffer.getContext().getMessageTypeName(index)) == null) {
            throw new BreezeException("wrong breeze message ref. index:" + index);
        }
        return name;
    }

    @FunctionalInterface
    public static interface ReadField {
        public void readIndexField(int var1) throws BreezeException;
    }
}

