/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze;

import com.weibo.breeze.Breeze;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.SchemaUtil;
import com.weibo.breeze.message.Message;
import com.weibo.breeze.message.Schema;
import com.weibo.breeze.serializer.CommonSerializer;
import com.weibo.breeze.serializer.EnumSerializer;
import com.weibo.breeze.serializer.Serializer;
import com.weibo.breeze.type.BreezeType;
import com.weibo.breeze.type.TypeArray;
import com.weibo.breeze.type.TypeBool;
import com.weibo.breeze.type.TypeByte;
import com.weibo.breeze.type.TypeByteArray;
import com.weibo.breeze.type.TypeFloat32;
import com.weibo.breeze.type.TypeFloat64;
import com.weibo.breeze.type.TypeInt16;
import com.weibo.breeze.type.TypeInt32;
import com.weibo.breeze.type.TypeInt64;
import com.weibo.breeze.type.TypeMap;
import com.weibo.breeze.type.TypeMessage;
import com.weibo.breeze.type.TypePackedArray;
import com.weibo.breeze.type.TypePackedMap;
import com.weibo.breeze.type.TypeString;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BreezeUtil {
    public static final String WITH_STATIC_FIELD_KEY = "withStaticField";
    private static final Set<Class<?>> NOT_PROCESS_CLASS = new HashSet<Class>(Arrays.asList(Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Double.class, Float.class, Object.class, String.class, Void.TYPE));
    private static final Pattern classNamePattern = Pattern.compile("\\w+\\.\\w+(\\.\\w+)*");
    public static int DEFAULT_MAX_FIELD_SIZE = 1000;

    public static void generateBreezeFiles(Class<?> clz, String path) throws IOException {
        BreezeUtil.generateBreezeFiles(clz, path, new HashMap<String, String>(), false);
    }

    public static void generateBreezeFiles(Class<?> clz, String path, Map<String, String> configs, boolean withSerializer) throws IOException {
        File directory = new File(path);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (!directory.isDirectory()) {
            throw new BreezeException("'path' is not a directory");
        }
        Map<Class<?>, GenerateClassResult> resultMap = BreezeUtil.generateSchema(clz, configs);
        for (Map.Entry<Class<?>, GenerateClassResult> entry : resultMap.entrySet()) {
            if (!entry.getValue().success) continue;
            Files.write(Paths.get(path + "/" + entry.getKey().getSimpleName() + ".breeze", new String[0]), SchemaUtil.toFileContent(entry.getValue().schema).getBytes(), new OpenOption[0]);
            if (!withSerializer) continue;
            try {
                Files.write(Paths.get(path + "/" + entry.getKey().getSimpleName() + "Serializer.java", new String[0]), BreezeUtil.toSerializerContent(entry.getValue().schema).getBytes(), new OpenOption[0]);
            }
            catch (BreezeException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public static Map<Class<?>, GenerateClassResult> generateSchema(Class<?> clz) {
        return BreezeUtil.generateSchema(clz, new HashMap<String, String>());
    }

    public static Map<Class<?>, GenerateClassResult> generateSchema(Class<?> clz, Map<String, String> configs) {
        HashMap result = new HashMap();
        HashMap needProcessClasses = new HashMap();
        BreezeUtil.findClassNeedProcess(clz, needProcessClasses);
        HashMap willBeProcessedClasses = new HashMap(needProcessClasses);
        for (Map.Entry entry : needProcessClasses.entrySet()) {
            try {
                BreezeUtil.generateClassSchema0((Class)entry.getValue(), configs, willBeProcessedClasses, result);
            }
            catch (BreezeException e) {
                System.out.println("[WARN] BreezeUtil: generate class schema fail. class:" + (String)entry.getKey() + ", error:" + e.getMessage());
            }
        }
        return result;
    }

    public static void findClassNeedProcess(Class<?> clz, Map<String, Class<?>> needProcessClasses) {
        HashMap willBeProcessedClasses = new HashMap();
        if (clz.isInterface()) {
            for (Method method : clz.getMethods()) {
                for (Type param : method.getGenericParameterTypes()) {
                    BreezeUtil.needProcess(param, needProcessClasses, willBeProcessedClasses);
                }
                BreezeUtil.needProcess(method.getGenericReturnType(), needProcessClasses, willBeProcessedClasses);
            }
        } else {
            BreezeUtil.needProcess(clz, needProcessClasses, willBeProcessedClasses);
        }
    }

    public static void generateClassSchema0(Class<?> clz, Map<String, String> configs, Map<String, Class<?>> willBeProcessedClasses, Map<Class<?>, GenerateClassResult> result) throws BreezeException {
        if (configs == null) {
            throw new BreezeException("config map is null");
        }
        if (result == null) {
            throw new BreezeException("result map is null");
        }
        if (willBeProcessedClasses == null) {
            throw new BreezeException("willBeProcessedClasses map is null");
        }
        GenerateClassResult generateClassResult = new GenerateClassResult(clz);
        result.put(clz, generateClassResult);
        if (clz.isEnum()) {
            generateClassResult.schema = BreezeUtil.buildEnumSchema(clz, configs, willBeProcessedClasses, result);
            generateClassResult.success = true;
            return;
        }
        String name = BreezeUtil.getCleanName(clz);
        Schema schema = Schema.newSchema(name);
        if (clz.getName().contains("$")) {
            schema.setJavaName(clz.getName());
        }
        int index = 1;
        int round = 1;
        Method[] methods = clz.getMethods();
        HashSet<String> addedFields = new HashSet<String>();
        Class<?> curClz = clz;
        do {
            Field[] fields;
            block1: for (Field field : fields = curClz.getDeclaredFields()) {
                if (!BreezeUtil.checkField(field, "true".equals(configs.get(WITH_STATIC_FIELD_KEY)))) continue;
                if (Modifier.isPublic(field.getModifiers())) {
                    BreezeUtil.addField(schema, field, index++, addedFields, configs, willBeProcessedClasses, result);
                    continue;
                }
                if (methods.length <= 0) continue;
                for (Method method : methods) {
                    if (!method.getName().equalsIgnoreCase("get" + field.getName()) && (field.getType() != Boolean.TYPE || !method.getName().equalsIgnoreCase("is" + field.getName()))) continue;
                    BreezeUtil.addField(schema, field, index++, addedFields, configs, willBeProcessedClasses, result);
                    continue block1;
                }
            }
            if (curClz.getSuperclass() != Object.class && fields.length > DEFAULT_MAX_FIELD_SIZE) {
                throw new BreezeException("field size over limit. class:" + curClz.getName() + ", field size:" + fields.length);
            }
            curClz = curClz.getSuperclass();
            index = round * DEFAULT_MAX_FIELD_SIZE + 1;
            ++round;
        } while (curClz != null && curClz != Object.class);
        generateClassResult.schema = schema;
        generateClassResult.success = true;
    }

    private static Schema buildEnumSchema(Class<?> clz, Map<String, String> configs, Map<String, Class<?>> willBeProcessedClasses, Map<Class<?>, GenerateClassResult> result) throws BreezeException {
        String name = BreezeUtil.getCleanName(clz);
        Schema schema = Schema.newSchema(name);
        if (clz.getName().contains("$")) {
            schema.setJavaName(clz.getName());
        }
        ArrayList<Field> targetFields = new ArrayList<Field>();
        for (Field field : clz.getDeclaredFields()) {
            int modifier = field.getModifiers();
            if (!Modifier.isPrivate(modifier) || Modifier.isStatic(modifier) || "$VALUES".equals(field.getName())) continue;
            field.setAccessible(true);
            targetFields.add(field);
        }
        ?[] enums = clz.getEnumConstants();
        if (targetFields.isEmpty()) {
            schema.setEnum(true);
            for (Object obj : enums) {
                schema.addEnumValue(((Enum)obj).ordinal(), ((Enum)obj).name());
            }
        } else if (targetFields.size() == 1 && (((Field)targetFields.get(0)).getType() == Integer.TYPE || ((Field)targetFields.get(0)).getType() == Integer.class)) {
            schema.setEnum(true);
            for (Object obj : enums) {
                try {
                    schema.addEnumValue((Integer)((Field)targetFields.get(0)).get(obj), ((Enum)obj).name());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        } else {
            schema.putField(1, "enumValue", "string");
            HashSet<String> addedFields = new HashSet<String>();
            int index = 2;
            for (Field field : targetFields) {
                BreezeUtil.addField(schema, field, index++, addedFields, configs, willBeProcessedClasses, result);
            }
        }
        return schema;
    }

    public static String getCleanName(Class<?> clz) {
        String name = clz.getName();
        if (name.contains("$")) {
            name = name.replaceAll("\\$", "");
        }
        return name;
    }

    private static boolean checkField(Field field, boolean withStaticField) {
        return !Modifier.isFinal(field.getModifiers()) && (withStaticField || !Modifier.isStatic(field.getModifiers()));
    }

    private static void addField(Schema schema, Field field, int index, Set<String> addedFields, Map<String, String> configs, Map<String, Class<?>> willBeProcessedClasses, Map<Class<?>, GenerateClassResult> result) {
        if (!addedFields.contains(field.getName())) {
            HashMap associateClasses = new HashMap();
            BreezeUtil.needProcess(field.getGenericType(), associateClasses, willBeProcessedClasses);
            willBeProcessedClasses.putAll(associateClasses);
            for (Class clz : associateClasses.values()) {
                try {
                    BreezeUtil.generateClassSchema0(clz, configs, willBeProcessedClasses, result);
                }
                catch (BreezeException e) {
                    System.out.println("[WARN] BreezeUtil: generate field associate schema fail. base class:" + schema.getName() + ", field name:" + field.getName() + ", field index:" + index + ", field associate class:" + clz + "\uff0cerror: " + e.getMessage());
                }
            }
            try {
                schema.putField(index, field.getName(), BreezeUtil.getBreezeType(field.getGenericType(), schema.getName().substring(0, schema.getName().lastIndexOf("."))));
                addedFields.add(field.getName());
            }
            catch (BreezeException e) {
                System.out.println("[WARN] BreezeUtil: add schema field fail. class:" + schema.getName() + ", field name:" + field.getName() + ", field index:" + index + "\uff0c error: " + e.getMessage());
            }
        }
    }

    private static void needProcess(Type type, Map<String, Class<?>> needProcessClasses, Map<String, Class<?>> willBeProcessedClasses) {
        String superClz;
        Class clz;
        if (type == null) {
            return;
        }
        if (type instanceof Class) {
            clz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            clz = (Class)pt.getRawType();
            for (Type tp : pt.getActualTypeArguments()) {
                BreezeUtil.needProcess(tp, needProcessClasses, willBeProcessedClasses);
            }
        } else {
            return;
        }
        if (NOT_PROCESS_CLASS.contains(clz) || clz.isInterface() || clz.isPrimitive() || Map.class.isAssignableFrom(clz) || List.class.isAssignableFrom(clz) || Set.class.isAssignableFrom(clz)) {
            return;
        }
        if (clz.isArray()) {
            BreezeUtil.needProcess(clz.getComponentType(), needProcessClasses, willBeProcessedClasses);
            return;
        }
        String name = BreezeUtil.getCleanName(clz);
        if (willBeProcessedClasses.containsKey(name) || needProcessClasses.containsKey(name)) {
            return;
        }
        if (Message.class.isAssignableFrom(clz)) {
            return;
        }
        Serializer serializer = Breeze.DefaultSerializerFactory.getSerializerClassByName(name);
        if (serializer != null) {
            System.out.println("[INFO] BreezeUtil:" + name + " already has custom serializer " + serializer.getClass().getName());
            return;
        }
        if (clz.isEnum()) {
            try {
                Class.forName(clz.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if ((serializer = Breeze.getSerializer(name)) != null && !(serializer instanceof CommonSerializer) && !(serializer instanceof EnumSerializer)) {
            System.out.println("[INFO] BreezeUtil:" + name + " already has custom serializer " + serializer.getClass().getName());
            return;
        }
        if (clz.getSuperclass() != null && ("com.google.protobuf.GeneratedMessage".equals(superClz = clz.getSuperclass().getName()) || "com.google.protobuf.GeneratedMessageV3".equals(superClz))) {
            System.out.println("[INFO] BreezeUtil: skip protobuf message " + clz.getName());
            return;
        }
        if (!clz.isEnum()) {
            try {
                new CommonSerializer(clz);
            }
            catch (BreezeException be) {
                System.out.println("[WARN] BreezeUtil: " + clz.getName() + " can not create commonSerializer. info:" + be.getMessage());
                return;
            }
        }
        needProcessClasses.put(name, clz);
    }

    private static String getBreezeType(Type type, String packageName) throws BreezeException {
        Class clz;
        if (type == Object.class) {
            throw new BreezeException("can not support Object.class as breeze type.");
        }
        ParameterizedType pt = null;
        if (type instanceof Class) {
            clz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            pt = (ParameterizedType)type;
            clz = (Class)pt.getRawType();
        } else {
            throw new BreezeException("unsupported type :" + type);
        }
        if (clz == String.class || clz == Character.TYPE || clz == Character.class || clz == Void.TYPE) {
            return "string";
        }
        if (clz == Byte.class || clz == Byte.TYPE) {
            return "byte";
        }
        if (clz == Boolean.class || clz == Boolean.TYPE) {
            return "bool";
        }
        if (clz == Short.class || clz == Short.TYPE) {
            return "int16";
        }
        if (clz == Integer.class || clz == Integer.TYPE) {
            return "int32";
        }
        if (clz == Long.class || clz == Long.TYPE) {
            return "int64";
        }
        if (clz == Float.class || clz == Float.TYPE) {
            return "float32";
        }
        if (clz == Double.class || clz == Double.TYPE) {
            return "float64";
        }
        if (Map.class.isAssignableFrom(clz)) {
            if (pt == null || pt.getActualTypeArguments().length != 2) {
                throw new BreezeException("class must has two argument generic type when the class is a subclass of map. type:" + type);
            }
            return "map<" + BreezeUtil.getBreezeType(pt.getActualTypeArguments()[0], packageName) + ", " + BreezeUtil.getBreezeType(pt.getActualTypeArguments()[1], packageName) + ">";
        }
        if (clz.isArray()) {
            if (clz.getComponentType() == Byte.TYPE) {
                return "bytes";
            }
            return "array<" + BreezeUtil.getBreezeType(clz.getComponentType(), packageName) + ">";
        }
        if (Collection.class.isAssignableFrom(clz)) {
            if (pt == null || pt.getActualTypeArguments().length != 1) {
                throw new BreezeException("class must has a argument generic type when the class is a subclass of Collection. type:" + type);
            }
            return "array<" + BreezeUtil.getBreezeType(pt.getActualTypeArguments()[0], packageName) + ">";
        }
        String name = BreezeUtil.getCleanName(clz);
        if (name.startsWith(packageName + ".") && !name.substring(packageName.length() + 1).contains(".")) {
            return name.substring(packageName.length() + 1);
        }
        return name;
    }

    public static String toSerializerContent(Schema schema) throws BreezeException {
        Schema.Field field;
        if (schema.isEnum()) {
            throw new BreezeException("enum schema can use EnumSerializer directly");
        }
        CommonSerializer serializer = new CommonSerializer(schema);
        StringBuilder dynamicImports = new StringBuilder(256);
        ArrayList<Schema.Field> specialFields = new ArrayList<Schema.Field>();
        for (Map.Entry<Integer, Schema.Field> entry : schema.getFields().entrySet()) {
            BreezeType breezeType = entry.getValue().getBreezeType();
            if (breezeType == null) {
                breezeType = Breeze.getBreezeType(entry.getValue().getGenericType());
                entry.getValue().setBreezeType(breezeType);
            }
            if (!BreezeUtil.isSpecialType(breezeType)) continue;
            specialFields.add(entry.getValue());
        }
        Class<?> clazz = serializer.newInstance().getClass();
        String packageName = clazz.getPackage().getName();
        StringBuilder content = new StringBuilder(1024);
        content.append("package ").append(packageName).append(";\n\n");
        content.append("import com.weibo.breeze.*;\nimport com.weibo.breeze.serializer.Serializer;\nimport com.weibo.breeze.type.BreezeType;\n");
        boolean containsList = false;
        boolean containsMap = false;
        boolean containsArray = false;
        for (Schema.Field field2 : specialFields) {
            if (field2.getType().contains(".")) {
                Matcher matcher = classNamePattern.matcher(field2.getType());
                while (matcher.find()) {
                    content.append("import ").append(matcher.group()).append(";\n");
                }
            }
            if (field2.getBreezeType() instanceof TypePackedArray) {
                containsList = true;
            }
            if (field2.getBreezeType() instanceof TypePackedMap) {
                containsMap = true;
            }
            if (!field2.getField().getType().isArray()) continue;
            containsArray = true;
        }
        if (containsList) {
            content.append("import java.util.List;\n");
        }
        if (containsMap) {
            content.append("import java.util.Map;\n");
        }
        if (containsArray) {
            content.append("import java.util.Arrays;\nimport java.util.stream.Collectors;\n");
        }
        content.append("import static com.weibo.breeze.type.Types.*;\n\n");
        content.append("@SuppressWarnings(\"unchecked\")\npublic class ").append(clazz.getSimpleName()).append("Serializer implements Serializer<").append(clazz.getSimpleName()).append("> {\n");
        for (Schema.Field field3 : specialFields) {
            content.append("    private static BreezeType<").append(BreezeUtil.simpleClassType(field3.getGenericType())).append("> ").append(field3.getName()).append("BreezeType;\n");
        }
        content.append("\n    static {\n        try {\n");
        for (Schema.Field field4 : specialFields) {
            content.append("            ").append(field4.getName()).append("BreezeType = Breeze.getBreezeType(").append(clazz.getSimpleName()).append(".class, \"").append(field4.getName()).append("\");\n");
        }
        content.append("        } catch (BreezeException ignore) {\n        }\n    }\n\n");
        content.append("    String[] names = new String[]{").append(clazz.getSimpleName()).append(".class.getName()};\n");
        content.append("    @Override\n    public void writeToBuf(").append(clazz.getSimpleName()).append(" obj, BreezeBuffer buffer) throws BreezeException {\n").append("        BreezeWriter.writeMessage(buffer, () -> {\n");
        for (Map.Entry entry : schema.getFields().entrySet()) {
            field = (Schema.Field)entry.getValue();
            content.append("            ").append(BreezeUtil.buildBreezeTypeString(field)).append(".writeMessageField(buffer, ").append(field.getIndex()).append(", ").append(BreezeUtil.buildGetterString(field)).append(");\n");
        }
        content.append("        });\n    }\n\n");
        content.append("    @Override\n    public ").append(clazz.getSimpleName()).append(" readFromBuf(BreezeBuffer buffer) throws BreezeException {\n").append("        ").append(BreezeUtil.buildConstructorString(clazz)).append("\n").append("        BreezeReader.readMessage(buffer, (int index) -> {\n            switch (index) {\n");
        for (Map.Entry entry : schema.getFields().entrySet()) {
            field = (Schema.Field)entry.getValue();
            String valueString = BreezeUtil.buildBreezeTypeString(field) + ".read(buffer)";
            content.append("                case ").append(field.getIndex()).append(":\n").append("                    ").append(BreezeUtil.buildSetterString(field, valueString)).append("\n").append("                    break;\n");
        }
        content.append("                default: //skip unknown field\n                    BreezeReader.readObject(buffer, Object.class);\n            }\n        });\n        return obj;\n    }");
        content.append("\n    @Override\n    public String[] getNames() {\n        return names;\n    }\n\n}");
        return content.toString();
    }

    private static String buildBreezeTypeString(Schema.Field field) {
        if (field.getBreezeType() instanceof TypeBool) {
            return "TYPE_BOOL";
        }
        if (field.getBreezeType() instanceof TypeInt16) {
            return "TYPE_INT16";
        }
        if (field.getBreezeType() instanceof TypeInt32) {
            return "TYPE_INT32";
        }
        if (field.getBreezeType() instanceof TypeInt64) {
            return "TYPE_INT64";
        }
        if (field.getBreezeType() instanceof TypeFloat32) {
            return "TYPE_FLOAT32";
        }
        if (field.getBreezeType() instanceof TypeFloat64) {
            return "TYPE_FLOAT64";
        }
        if (field.getBreezeType() instanceof TypeByte) {
            return "TYPE_BYTE";
        }
        if (field.getBreezeType() instanceof TypeByteArray) {
            return "TYPE_BYTE_ARRAY";
        }
        if (field.getBreezeType() instanceof TypeString) {
            return "TYPE_STRING";
        }
        if (field.getBreezeType() instanceof TypeMap) {
            return "TYPE_MAP";
        }
        if (field.getBreezeType() instanceof TypeArray) {
            return "TYPE_ARRAY";
        }
        return field.getName() + "BreezeType";
    }

    private static boolean isSpecialType(BreezeType<?> breezeType) {
        return breezeType instanceof TypePackedArray || breezeType instanceof TypePackedMap || breezeType instanceof TypeMessage;
    }

    private static String buildGetterString(Schema.Field field) throws BreezeException {
        String getterString = "obj.";
        getterString = Modifier.isPublic(field.getField().getModifiers()) ? getterString + field.getName() : (field.getField().getType() == Boolean.TYPE ? getterString + "is" + BreezeUtil.firstUpper(field.getName()) + "()" : getterString + "get" + BreezeUtil.firstUpper(field.getName()) + "()");
        if (field.getField().getType().isArray()) {
            getterString = field.getField().getType().getComponentType().isPrimitive() ? "Arrays.stream(" + getterString + ").boxed().collect(Collectors.toList())" : "Arrays.asList(" + getterString + ")";
        }
        return getterString;
    }

    private static String buildSetterString(Schema.Field field, String valueString) throws BreezeException {
        String setterString = "obj.";
        if (field.getField().getType().isArray()) {
            valueString = field.getField().getType().getComponentType().isPrimitive() ? (field.getField().getType().getComponentType() == Integer.TYPE ? valueString + ".stream().mapToInt(Integer::intValue).toArray()" : (field.getField().getType().getComponentType() == Long.TYPE ? valueString + ".stream().mapToLong(Long::longValue).toArray();" : valueString + "->FIXME:convert List to primitive array")) : valueString + ".toArray(new " + field.getField().getType().getComponentType().getSimpleName() + "[0])";
        }
        setterString = Modifier.isPublic(field.getField().getModifiers()) ? setterString + field.getName() + " = " + valueString + ";" : setterString + "set" + BreezeUtil.firstUpper(field.getName()) + "(" + valueString + ");";
        return setterString;
    }

    private static String buildConstructorString(Class<?> clz) {
        try {
            clz.newInstance();
            return clz.getSimpleName() + " obj = new " + clz.getSimpleName() + "();";
        }
        catch (ReflectiveOperationException e) {
            return clz.getSimpleName() + ".builder().build();";
        }
    }

    private static String firstUpper(String text) {
        return text.substring(0, 1).toUpperCase() + text.substring(1);
    }

    private static String simpleClassType(Type fieldType) throws BreezeException {
        if (fieldType instanceof Class) {
            Class clz = (Class)fieldType;
            if (clz.isArray()) {
                return "List<" + BreezeUtil.simpleClassType(clz.getComponentType()) + ">";
            }
            if (clz.isPrimitive()) {
                return ((Class)MethodType.methodType(clz).wrap().returnType()).getSimpleName();
            }
            return clz.getSimpleName();
        }
        if (fieldType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)fieldType;
            Class clz = (Class)pt.getRawType();
            if (Map.class.isAssignableFrom(clz)) {
                if (pt.getActualTypeArguments().length != 2) {
                    throw new BreezeException("class must has two argument generic type when the class is a subclass of map. type:" + fieldType);
                }
                return "Map<" + BreezeUtil.simpleClassType(pt.getActualTypeArguments()[0]) + ", " + BreezeUtil.simpleClassType(pt.getActualTypeArguments()[1]) + ">";
            }
            if (Collection.class.isAssignableFrom(clz)) {
                if (pt.getActualTypeArguments().length != 1) {
                    throw new BreezeException("class must has a argument generic type when the class is a subclass of Collection. type:" + fieldType);
                }
                return "List<" + BreezeUtil.simpleClassType(pt.getActualTypeArguments()[0]) + ">";
            }
            return clz.getSimpleName();
        }
        throw new BreezeException("unsupported type :" + fieldType);
    }

    public static class GenerateClassResult {
        public Class<?> clz;
        public Schema schema;
        public Serializer<?> serializer;
        public Map<String, String> failedFieldInfo = new HashMap<String, String>();
        public boolean success;

        public GenerateClassResult(Class<?> clz) {
            this.clz = clz;
        }

        public GenerateClassResult(Class<?> clz, Schema schema) {
            this.clz = clz;
            this.schema = schema;
            this.success = true;
        }
    }
}

