/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze.type;

import com.weibo.breeze.Breeze;
import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.BreezeReader;
import com.weibo.breeze.BreezeWriter;
import com.weibo.breeze.type.BreezeType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TypePackedArray
implements BreezeType<List<?>> {
    private volatile BreezeType valueType;
    private Type vType;

    public TypePackedArray() {
    }

    public TypePackedArray(Type type) throws BreezeException {
        if (type == null) {
            throw new BreezeException("value type must not null in TypePackedArray");
        }
        this.vType = type;
        this.valueType = Breeze.getBreezeType(type);
        if (this.valueType == null) {
            throw new BreezeException("value type must not null in TypePackedArray");
        }
    }

    @Override
    public byte getType() {
        return -36;
    }

    @Override
    public List<?> read(BreezeBuffer buffer, boolean withType) throws BreezeException {
        int size;
        int type = -36;
        if (withType) {
            type = buffer.get();
            if (type == -103) {
                return null;
            }
            if (type != -36 && type != -38) {
                throw new BreezeException("unsupported by TypePackedArray. type:" + type);
            }
        }
        if ((size = (int)buffer.getVarint()) > Breeze.MAX_ELEM_SIZE) {
            throw new BreezeException("breeze array size over limit. size" + size);
        }
        ArrayList list = new ArrayList(size);
        this.readBySize(buffer, list, this.vType, size, type == -36);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void readBySize(BreezeBuffer buffer, Collection<T> collection, Type vType, int size, boolean isPacked) throws BreezeException {
        if (size == 0) {
            return;
        }
        if (isPacked) {
            if (this.valueType == null) {
                TypePackedArray typePackedArray = this;
                synchronized (typePackedArray) {
                    if (this.valueType == null) {
                        this.valueType = BreezeReader.readBreezeType(buffer, vType);
                    } else {
                        BreezeReader.skipType(buffer);
                    }
                }
            } else {
                BreezeReader.skipType(buffer);
            }
            for (int j = 0; j < size; ++j) {
                collection.add(this.valueType.read(buffer, false));
            }
        } else if (this.valueType != null) {
            for (int j = 0; j < size; ++j) {
                collection.add(this.valueType.read(buffer));
            }
        } else {
            for (int j = 0; j < size; ++j) {
                collection.add(BreezeReader.readObjectByType(buffer, vType));
            }
        }
    }

    @Override
    public void write(BreezeBuffer buffer, List<?> value, boolean withType) throws BreezeException {
        this.writeCollection(buffer, value, withType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCollection(BreezeBuffer buffer, Collection<?> value, boolean withType) throws BreezeException {
        BreezeWriter.checkWriteCount(buffer, value);
        if (withType) {
            buffer.put((byte)-36);
        }
        int size = value.size();
        buffer.putVarint(size);
        if (size == 0) {
            return;
        }
        if (this.valueType != null) {
            this.valueType.putType(buffer);
        }
        for (Object v : value) {
            if (v == null) {
                throw new BreezeException("not support null value in breeze packed array");
            }
            if (this.valueType == null) {
                TypePackedArray typePackedArray = this;
                synchronized (typePackedArray) {
                    if (this.valueType == null) {
                        this.valueType = Breeze.getBreezeTypeByObject(v);
                    }
                }
                this.valueType.putType(buffer);
            }
            this.valueType.write(buffer, v, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeArray(BreezeBuffer buffer, Object[] value, boolean withType) throws BreezeException {
        if (withType) {
            buffer.put((byte)-36);
        }
        int size = value.length;
        buffer.putVarint(size);
        if (size == 0) {
            return;
        }
        if (this.valueType != null) {
            this.valueType.putType(buffer);
        }
        for (Object v : value) {
            if (v == null) {
                throw new BreezeException("not support null value in breeze packed array");
            }
            if (this.valueType == null) {
                TypePackedArray typePackedArray = this;
                synchronized (typePackedArray) {
                    if (this.valueType == null) {
                        this.valueType = Breeze.getBreezeTypeByObject(v);
                    }
                }
                this.valueType.putType(buffer);
            }
            this.valueType.write(buffer, v, false);
        }
    }
}

