/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze.maven.plugin;

import com.weibo.breeze.Breeze;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.SchemaUtil;
import com.weibo.breeze.message.Message;
import com.weibo.breeze.message.Schema;
import com.weibo.breeze.serializer.CommonSerializer;
import com.weibo.breeze.serializer.EnumSerializer;
import com.weibo.breeze.serializer.Serializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="schema", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class SchemaMojo
extends AbstractMojo {
    private static final String DEFAULT_INCLUDES = "**/*.xml";
    private static final String BREEZE_DIR = "META-INF" + File.separator + "breeze";
    private static final String HEADER_PREFIX = "// auto generated by breeze-maven-plugin (https://github.com/weibreeze/breeze)";
    @Parameter(defaultValue="${basedir}/src/main/resources")
    private String xmlPath;
    @Parameter(defaultValue="**/*.xml")
    private String includes;
    @Parameter
    private String excludes;
    @Parameter
    private List<String> classes;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="false")
    private Boolean withStaticField;
    private ClassRealm classRealm;
    private Map<String, Class> beanClasses = new HashMap<String, Class>();
    private Map<String, Boolean> processResult = new HashMap<String, Boolean>();
    private String srcBreezeDir;
    private String targetBreezeDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"breeze-maven-plugin:start generating schema");
        try {
            Set<String> classNames = this.getInterfaces();
            if (this.classes != null && !this.classes.isEmpty()) {
                classNames.addAll(this.classes);
            }
            this.addToBeanClasses(classNames);
            if (!this.beanClasses.isEmpty()) {
                this.srcBreezeDir = this.project.getBasedir().getAbsolutePath() + File.separator + "src" + File.separator + "main" + File.separator + "resources" + File.separator + BREEZE_DIR;
                this.targetBreezeDir = this.project.getBasedir().getAbsolutePath() + File.separator + "target" + File.separator + "classes" + File.separator + BREEZE_DIR;
                FileUtils.mkdir((String)this.srcBreezeDir);
                FileUtils.mkdir((String)this.targetBreezeDir);
                for (Class clz : this.beanClasses.values()) {
                    this.generateSchema(clz);
                }
            }
        }
        catch (MojoFailureException failException) {
            throw failException;
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"breeze-maven-plugin: generate schema fail.", (Throwable)e);
        }
    }

    private Set<String> getInterfaces() throws IOException, XmlPullParserException {
        HashSet<String> interfaces = new HashSet<String>();
        List list = FileUtils.getFiles((File)new File(this.xmlPath), (String)this.includes, (String)this.excludes);
        for (File file : list) {
            Xpp3Dom[] referers;
            Xpp3Dom dom = Xpp3DomBuilder.build((InputStream)new FileInputStream(file), null);
            for (Xpp3Dom ref : referers = dom.getChildren("motan:referer")) {
                if (ref.getAttribute("interface") != null) {
                    interfaces.add(ref.getAttribute("interface"));
                }
                if (ref.getAttribute("serviceInterface") == null) continue;
                interfaces.add(ref.getAttribute("serviceInterface"));
            }
        }
        return interfaces;
    }

    private void addToBeanClasses(Set<String> classNames) throws MalformedURLException, DependencyResolutionRequiredException {
        if (!classNames.isEmpty()) {
            this.initClassRealm();
            for (String className : classNames) {
                try {
                    Class clz = this.classRealm.loadClass(className);
                    if (clz.isInterface()) {
                        for (Method method : clz.getMethods()) {
                            for (Type param : method.getGenericParameterTypes()) {
                                this.needProcess(param, this.beanClasses);
                            }
                            this.needProcess(method.getGenericReturnType(), this.beanClasses);
                        }
                        continue;
                    }
                    this.needProcess(clz, this.beanClasses);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
    }

    private void needProcess(Type type, Map<String, Class> needProcessClasses) {
        String superClz;
        Class clz;
        if (type == null) {
            return;
        }
        if (type instanceof Class) {
            clz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            clz = (Class)pt.getRawType();
            for (Type tp : pt.getActualTypeArguments()) {
                this.needProcess(tp, needProcessClasses);
            }
        } else {
            return;
        }
        if (clz.isInterface() || ClassUtils.isPrimitiveOrWrapper((Class)clz) || clz == Object.class || clz == String.class || Map.class.isAssignableFrom(clz) || List.class.isAssignableFrom(clz) || Set.class.isAssignableFrom(clz)) {
            return;
        }
        if (clz.isArray()) {
            this.needProcess(clz.getComponentType(), needProcessClasses);
            return;
        }
        String name = this.getCleanName(clz);
        if (this.beanClasses.containsKey(name) || needProcessClasses.containsKey(name)) {
            return;
        }
        if (Message.class.isAssignableFrom(clz)) {
            return;
        }
        Serializer serializer = Breeze.DefaultSerializerFactory.getSerializerClassByName((String)name);
        if (serializer != null) {
            this.getLog().info((CharSequence)(name + " already has custom serializer " + serializer.getClass().getName()));
            return;
        }
        serializer = Breeze.getSerializer((String)name);
        if (serializer != null && !(serializer instanceof CommonSerializer) && !(serializer instanceof EnumSerializer)) {
            this.getLog().info((CharSequence)(name + " already has custom serializer " + serializer.getClass().getName()));
            return;
        }
        if (clz.getSuperclass() != null && ("com.google.protobuf.GeneratedMessage".equals(superClz = clz.getSuperclass().getName()) || "com.google.protobuf.GeneratedMessageV3".equals(superClz))) {
            this.getLog().info((CharSequence)("skip protobuf message " + clz.getName()));
            return;
        }
        if (!clz.isEnum()) {
            try {
                new CommonSerializer(clz);
            }
            catch (BreezeException be) {
                this.getLog().warn((CharSequence)(clz.getName() + " can not create commonSerializer. info:" + be.getMessage()));
                return;
            }
        }
        try {
            Enumeration enumeration = this.classRealm.getResources("META-INF/breeze/" + name + ".breeze");
            URL elem = null;
            while (enumeration.hasMoreElements()) {
                elem = (URL)enumeration.nextElement();
                if (!"jar".equals(elem.toURI().getScheme())) continue;
                this.getLog().info((CharSequence)(name + " already has schema in jar " + elem.toURI()));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        needProcessClasses.put(name, clz);
    }

    private void generateSchema(Class beanClass) throws MojoFailureException {
        String name = this.getCleanName(beanClass);
        if (this.processResult.containsKey(name)) {
            return;
        }
        this.processResult.put(name, false);
        boolean result = false;
        String fileName = this.srcBreezeDir + File.separator + name + ".breeze";
        Schema oldSchema = null;
        try {
            String jarFileName = this.getJarFileName(beanClass);
            if (FileUtils.fileExists((String)fileName)) {
                String content = FileUtils.fileRead((String)fileName, (String)"UTF-8");
                if (!content.startsWith(HEADER_PREFIX) || jarFileName != null && content.contains(jarFileName)) {
                    this.processResult.put(name, true);
                    this.getLog().info((CharSequence)("skip update schema for " + name + ", because old schema is not auto generated by plugin, or with same version."));
                    return;
                }
                oldSchema = SchemaUtil.parseSchema((String)content);
            }
            Schema schema = this.buildSchema(beanClass);
            if (oldSchema != null) {
                this.checkCompatible(schema, oldSchema);
            }
            String header = HEADER_PREFIX;
            if (jarFileName != null) {
                header = header + " jar:" + jarFileName;
            }
            String content = header + "\n" + SchemaUtil.toFileContent((Schema)schema);
            FileUtils.fileWrite((String)fileName, (String)"UTF-8", (String)content);
            FileUtils.fileWrite((String)(this.targetBreezeDir + File.separator + name + ".breeze"), (String)"UTF-8", (String)content);
            result = true;
        }
        catch (MojoFailureException failException) {
            throw failException;
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("breeze-maven-plugin: generate schema fail. class: " + name + ", error: " + e.getMessage()));
        }
        this.processResult.put(name, result);
        this.getLog().info((CharSequence)("breeze-maven-plugin: generate schema:" + name + ":" + result));
    }

    private String getJarFileName(Class clz) {
        String file = clz.getProtectionDomain().getCodeSource().getLocation().getFile();
        if (file.endsWith(".jar")) {
            return file.substring(file.lastIndexOf(File.separator) + 1);
        }
        return null;
    }

    private void initClassRealm() throws DependencyResolutionRequiredException, MalformedURLException {
        this.classRealm = ((PluginDescriptor)this.getPluginContext().get("pluginDescriptor")).getClassRealm();
        HashSet<String> classpathElements = new HashSet<String>();
        classpathElements.add(this.project.getBuild().getOutputDirectory());
        classpathElements.addAll(this.project.getCompileClasspathElements());
        classpathElements.addAll(this.project.getRuntimeClasspathElements());
        for (String cp : classpathElements) {
            this.classRealm.addURL(new File(cp).toURI().toURL());
        }
    }

    private Schema buildSchema(Class clz) throws MojoFailureException, BreezeException {
        if (clz.isEnum()) {
            return this.buildEnumSchema(clz);
        }
        String name = this.getCleanName(clz);
        Schema schema = Schema.newSchema((String)name);
        if (clz.getName().contains("$")) {
            schema.setJavaName(clz.getName());
        }
        int index = 1;
        int round = 1;
        Method[] methods = clz.getMethods();
        HashSet<String> addedFields = new HashSet<String>();
        do {
            Field[] fields;
            block1: for (Field field : fields = clz.getDeclaredFields()) {
                if (!this.checkField(field)) continue;
                if (Modifier.isPublic(field.getModifiers())) {
                    this.addField(schema, field, index++, addedFields);
                    continue;
                }
                if (methods.length <= 0) continue;
                for (Method method : methods) {
                    if (!method.getName().equalsIgnoreCase("get" + field.getName()) && (field.getType() != Boolean.TYPE || !method.getName().equalsIgnoreCase("is" + field.getName()))) continue;
                    this.addField(schema, field, index++, addedFields);
                    continue block1;
                }
            }
            clz = clz.getSuperclass();
            index = fields.length < 100 ? round * 100 : ++round * 100;
            ++round;
        } while (clz != null && clz != Object.class);
        return schema;
    }

    private Schema buildEnumSchema(Class clz) throws BreezeException, MojoFailureException {
        String name = this.getCleanName(clz);
        Schema schema = Schema.newSchema((String)name);
        if (clz.getName().contains("$")) {
            schema.setJavaName(clz.getName());
        }
        ArrayList<Field> targetFields = new ArrayList<Field>();
        for (Field field : clz.getDeclaredFields()) {
            int modifier = field.getModifiers();
            if (!Modifier.isPrivate(modifier) || Modifier.isStatic(modifier) || "$VALUES".equals(field.getName())) continue;
            field.setAccessible(true);
            targetFields.add(field);
        }
        T[] enums = clz.getEnumConstants();
        if (targetFields.isEmpty()) {
            schema.setEnum(true);
            for (Object obj : enums) {
                schema.addEnumValue(Integer.valueOf(((Enum)obj).ordinal()), ((Enum)obj).name());
            }
        } else if (targetFields.size() == 1 && (((Field)targetFields.get(0)).getType() == Integer.TYPE || ((Field)targetFields.get(0)).getType() == Integer.class)) {
            schema.setEnum(true);
            for (Object obj : enums) {
                try {
                    schema.addEnumValue((Integer)((Field)targetFields.get(0)).get(obj), ((Enum)obj).name());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        } else {
            schema.putField(1, "enumValue", "string");
            HashSet<String> addedFields = new HashSet<String>();
            int index = 2;
            for (Field field : targetFields) {
                this.addField(schema, field, index++, addedFields);
            }
        }
        return schema;
    }

    private void checkCompatible(Schema s1, Schema s2) throws MojoFailureException {
        if (!s1.getName().equals(s2.getName())) {
            throw new MojoFailureException("breeze field name not compatible with old version. schema:" + s1.getName());
        }
        if (s1.isEnum()) {
            Map values1 = s1.getEnumValues();
            Map values2 = s2.getEnumValues();
            for (Map.Entry entry : values1.entrySet()) {
                if (values2.get(entry.getKey()) == null || ((String)values2.get(entry.getKey())).equals(entry.getValue())) continue;
                throw new MojoFailureException("breeze enum value not compatible with old version. schema:" + s1.getName() + ", enum:" + (String)entry.getValue() + ", index:" + entry.getKey() + ", old value:" + (String)values2.get(entry.getKey()));
            }
        } else {
            for (Schema.Field field : s1.getFields().values()) {
                Schema.Field otherField = s2.getFieldByName(field.getName());
                if (otherField == null || otherField.getIndex() == field.getIndex()) continue;
                throw new MojoFailureException("breeze field index not compatible with old version. schema:" + s1.getName() + ", field:" + field.getName() + ", index:" + field.getIndex() + ", old index:" + otherField.getIndex());
            }
        }
    }

    private boolean checkField(Field field) {
        return !Modifier.isFinal(field.getModifiers()) && (this.withStaticField != false || !Modifier.isStatic(field.getModifiers()));
    }

    private void addField(Schema schema, Field field, int index, Set<String> addedFields) throws MojoFailureException {
        if (!addedFields.contains(field.getName())) {
            HashMap<String, Class> associateClasses = new HashMap<String, Class>();
            this.needProcess(field.getGenericType(), associateClasses);
            for (Class clz : associateClasses.values()) {
                this.generateSchema(clz);
            }
            try {
                schema.putField(index, field.getName(), this.getBreezeType(field.getGenericType(), schema.getName().substring(0, schema.getName().lastIndexOf("."))));
                addedFields.add(field.getName());
            }
            catch (BreezeException e) {
                this.getLog().warn((CharSequence)("breeze-maven-plugin: add field fail. class:" + schema.getName() + ", field name:" + field.getName() + ", field index:" + index + "\uff0c error: " + e.getMessage()));
            }
        }
    }

    private String getBreezeType(Type type, String packageName) throws BreezeException {
        Class clz;
        if (type == Object.class) {
            throw new BreezeException("can not support Object.class as breeze type.");
        }
        ParameterizedType pt = null;
        if (type instanceof Class) {
            clz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            pt = (ParameterizedType)type;
            clz = (Class)pt.getRawType();
        } else {
            throw new BreezeException("unsupported type :" + type);
        }
        if (clz == String.class || clz == Character.TYPE || clz == Character.class || clz == Void.TYPE) {
            return "string";
        }
        if (clz == Byte.class || clz == Byte.TYPE) {
            return "byte";
        }
        if (clz == Boolean.class || clz == Boolean.TYPE) {
            return "bool";
        }
        if (clz == Short.class || clz == Short.TYPE) {
            return "int16";
        }
        if (clz == Integer.class || clz == Integer.TYPE) {
            return "int32";
        }
        if (clz == Long.class || clz == Long.TYPE) {
            return "int64";
        }
        if (clz == Float.class || clz == Float.TYPE) {
            return "float32";
        }
        if (clz == Double.class || clz == Double.TYPE) {
            return "float64";
        }
        if (Map.class.isAssignableFrom(clz)) {
            if (pt == null || pt.getActualTypeArguments().length != 2) {
                throw new BreezeException("class must has two argument generic type when the class is a subclass of map. type:" + type);
            }
            return "map<" + this.getBreezeType(pt.getActualTypeArguments()[0], packageName) + ", " + this.getBreezeType(pt.getActualTypeArguments()[1], packageName) + ">";
        }
        if (clz.isArray()) {
            if (clz.getComponentType() == Byte.TYPE) {
                return "bytes";
            }
            return "array<" + this.getBreezeType(clz.getComponentType(), packageName) + ">";
        }
        if (Collection.class.isAssignableFrom(clz)) {
            if (pt == null || pt.getActualTypeArguments().length != 1) {
                throw new BreezeException("class must has a argument generic type when the class is a subclass of Collection. type:" + type);
            }
            return "array<" + this.getBreezeType(pt.getActualTypeArguments()[0], packageName) + ">";
        }
        String name = this.getCleanName(clz);
        if (name.startsWith(packageName + ".") && !name.substring(packageName.length() + 1).contains(".")) {
            return name.substring(packageName.length() + 1);
        }
        return name;
    }

    private String getCleanName(Class clz) {
        String name = clz.getName();
        if (name.contains("$")) {
            name = name.replaceAll("\\$", "");
        }
        return name;
    }
}

