/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.config;

import com.weibo.api.motan.cluster.support.ClusterSupport;
import com.weibo.api.motan.common.MotanConstants;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.config.AbstractRefererConfig;
import com.weibo.api.motan.config.BasicRefererInterfaceConfig;
import com.weibo.api.motan.config.MethodConfig;
import com.weibo.api.motan.config.ProtocolConfig;
import com.weibo.api.motan.config.annotation.ConfigDesc;
import com.weibo.api.motan.config.handler.ConfigHandler;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.registry.RegistryService;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.CollectionUtil;
import com.weibo.api.motan.util.StringTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;

public class RefererConfig<T>
extends AbstractRefererConfig {
    private static final long serialVersionUID = -2299754608229467887L;
    private Class<T> interfaceClass;
    protected List<MethodConfig> methods;
    private String directUrl;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private T ref;
    private BasicRefererInterfaceConfig basicReferer;
    private List<ClusterSupport<T>> clusterSupports;

    public List<MethodConfig> getMethods() {
        return this.methods;
    }

    public void setMethods(List<MethodConfig> methods) {
        this.methods = methods;
    }

    public void setMethods(MethodConfig methods) {
        this.methods = Collections.singletonList(methods);
    }

    public boolean hasMethods() {
        return this.methods != null && !this.methods.isEmpty();
    }

    public T getRef() {
        if (this.ref == null) {
            this.initRef();
        }
        return this.ref;
    }

    public synchronized void initRef() {
        if (this.initialized.get()) {
            return;
        }
        try {
            this.interfaceClass = Class.forName(this.interfaceClass.getName(), true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new MotanFrameworkException("ReferereConfig initRef Error: Class not found " + this.interfaceClass.getName(), e, MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
        }
        if (CollectionUtil.isEmpty(this.protocols)) {
            throw new MotanFrameworkException(String.format("%s RefererConfig is malformed, for protocol not set correctly!", this.interfaceClass.getName()));
        }
        this.checkInterfaceAndMethods(this.interfaceClass, this.methods);
        this.clusterSupports = new ArrayList<ClusterSupport<T>>(this.protocols.size());
        ArrayList clusters = new ArrayList(this.protocols.size());
        String proxy = null;
        ConfigHandler configHandler = ExtensionLoader.getExtensionLoader(ConfigHandler.class).getExtension("default");
        List<URL> registryUrls = this.loadRegistryUrls();
        String localIp = this.getLocalHostAddress(registryUrls);
        for (ProtocolConfig protocol : this.protocols) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(URLParamType.nodeType.getName(), "referer");
            params.put(URLParamType.version.getName(), URLParamType.version.getValue());
            params.put(URLParamType.refreshTimestamp.getName(), String.valueOf(System.currentTimeMillis()));
            RefererConfig.collectConfigParams(params, protocol, this.basicReferer, this.extConfig, this);
            RefererConfig.collectMethodConfigParams(params, this.getMethods());
            URL refUrl = new URL(protocol.getName(), localIp, 0, this.interfaceClass.getName(), params);
            ClusterSupport<T> clusterSupport = this.createClusterSupport(refUrl, configHandler, registryUrls);
            this.clusterSupports.add(clusterSupport);
            clusters.add(clusterSupport.getCluster());
            proxy = proxy == null ? refUrl.getParameter(URLParamType.proxy.getName(), URLParamType.proxy.getValue()) : proxy;
        }
        this.ref = configHandler.refer(this.interfaceClass, clusters, proxy);
        this.initialized.set(true);
    }

    private ClusterSupport<T> createClusterSupport(URL refUrl, ConfigHandler configHandler, List<URL> registryUrls) {
        ArrayList<URL> regUrls = new ArrayList<URL>();
        if (StringUtils.isNotBlank((CharSequence)this.directUrl) || "injvm".equals(refUrl.getProtocol())) {
            URL regUrl = new URL("local", "127.0.0.1", 0, RegistryService.class.getName());
            if (StringUtils.isNotBlank((CharSequence)this.directUrl)) {
                String[] dus;
                StringBuilder duBuf = new StringBuilder(128);
                for (String du : dus = MotanConstants.COMMA_SPLIT_PATTERN.split(this.directUrl)) {
                    if (!du.contains(":")) continue;
                    String[] hostPort = du.split(":");
                    URL durl = refUrl.createCopy();
                    durl.setHost(hostPort[0].trim());
                    durl.setPort(Integer.parseInt(hostPort[1].trim()));
                    durl.addParameter(URLParamType.nodeType.getName(), "service");
                    duBuf.append(StringTools.urlEncode(durl.toFullStr())).append(",");
                }
                if (duBuf.length() > 0) {
                    duBuf.deleteCharAt(duBuf.length() - 1);
                    regUrl.addParameter(URLParamType.directUrl.getName(), duBuf.toString());
                }
            }
            regUrls.add(regUrl);
        } else {
            if (registryUrls == null || registryUrls.isEmpty()) {
                throw new IllegalStateException(String.format("No registry to reference %s on the consumer %s , please config <motan:registry address=\"...\" /> in your spring config.", this.interfaceClass, "127.0.0.1"));
            }
            for (URL url : registryUrls) {
                regUrls.add(url.createCopy());
            }
        }
        for (URL url : regUrls) {
            url.addParameter(URLParamType.embed.getName(), StringTools.urlEncode(refUrl.toFullStr()));
        }
        return configHandler.buildClusterSupport(this.interfaceClass, regUrls);
    }

    public synchronized void destroy() {
        if (this.clusterSupports != null) {
            for (ClusterSupport<T> clusterSupport : this.clusterSupports) {
                clusterSupport.destroy();
            }
        }
        this.ref = null;
        this.initialized.set(false);
    }

    public void setInterface(Class<T> interfaceClass) {
        if (interfaceClass != null && !interfaceClass.isInterface()) {
            throw new IllegalStateException("The interface class " + interfaceClass + " is not a interface!");
        }
        this.interfaceClass = interfaceClass;
    }

    public Class<?> getInterface() {
        return this.interfaceClass;
    }

    public String getDirectUrl() {
        return this.directUrl;
    }

    public void setDirectUrl(String directUrl) {
        this.directUrl = directUrl;
    }

    @ConfigDesc(excluded=true)
    public BasicRefererInterfaceConfig getBasicReferer() {
        return this.basicReferer;
    }

    public void setBasicReferer(BasicRefererInterfaceConfig basicReferer) {
        this.basicReferer = basicReferer;
    }

    public List<ClusterSupport<T>> getClusterSupports() {
        return this.clusterSupports;
    }

    public AtomicBoolean getInitialized() {
        return this.initialized;
    }
}

