/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.filter;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.Activation;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanBizException;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.filter.Filter;
import com.weibo.api.motan.rpc.Caller;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.ReflectUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;

@SpiMeta(name="mock")
@Activation(sequence=100)
public class ServiceMockFilter
implements Filter {
    private static String RETURN_PREFIX = "return";
    private static ConcurrentHashMap<String, MockInfo> mockServices = new ConcurrentHashMap();

    public static boolean isDefault(String value) {
        return "true".equalsIgnoreCase(value) || "default".equalsIgnoreCase(value);
    }

    private static MockInfo getServiceStat(URL url) {
        MockInfo info = mockServices.get(url.getIdentity());
        if (info == null) {
            info = new MockInfo(url);
            mockServices.putIfAbsent(url.getIdentity(), info);
            info = mockServices.get(url.getIdentity());
        }
        return info;
    }

    @Override
    public Response filter(Caller<?> caller, Request request) {
        String mockServiceName = caller.getUrl().getParameter(URLParamType.mock.getName());
        if (StringUtils.isEmpty((CharSequence)mockServiceName) || "false".equals(mockServiceName)) {
            return caller.call(request);
        }
        MockInfo info = ServiceMockFilter.getServiceStat(caller.getUrl());
        DefaultResponse response = new DefaultResponse();
        if (mockServiceName.startsWith(RETURN_PREFIX)) {
            String value = mockServiceName.substring(RETURN_PREFIX.length());
            try {
                info.callNum.addAndGet(1L);
                long sleepTime = this.caclSleepTime(info);
                Thread.sleep(sleepTime);
                response.setValue(this.parseMockValue(value));
            }
            catch (RuntimeException e) {
                if (e.getCause() != null) {
                    response.setException(new MotanBizException("mock service call process error", e.getCause()));
                }
                response.setException(new MotanBizException("mock service call process error", e));
            }
            catch (Exception e) {
                throw new IllegalStateException("Illegal mock json value in <motan:service ... mock=\"" + mockServiceName + "\" />");
            }
        } else {
            try {
                Class<?> mockClass;
                Class<?> clazz = mockClass = ServiceMockFilter.isDefault(mockServiceName) ? ReflectUtil.forName(caller.getInterface().getName() + "Mock") : ReflectUtil.forName(mockServiceName);
                if (!caller.getInterface().isAssignableFrom(mockClass)) {
                    throw new MotanFrameworkException("The mock implemention class " + mockClass.getName() + " not implement interface " + caller.getInterface().getName());
                }
                try {
                    mockClass.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("No such empty constructor \"public " + mockClass.getSimpleName() + "()\" in mock implemention class " + mockClass.getName());
                }
                String methodDesc = ReflectUtil.getMethodDesc(request.getMethodName(), request.getParamtersDesc());
                Method[] methods = mockClass.getMethods();
                boolean invoke = false;
                for (Method method : methods) {
                    if (!methodDesc.equals(ReflectUtil.getMethodDesc(method))) continue;
                    Object value = this.invoke(mockClass.newInstance(), method, request.getArguments(), info);
                    response.setValue(value);
                    invoke = true;
                    break;
                }
                if (!invoke) {
                    throw new MotanFrameworkException("Mock method is not found." + methodDesc);
                }
            }
            catch (ClassNotFoundException e) {
                throw new MotanFrameworkException("Mock service is not found." + (ServiceMockFilter.isDefault(mockServiceName) ? caller.getInterface().getName() + "Mock" : mockServiceName));
            }
            catch (Exception e) {
                if (e.getCause() != null) {
                    response.setException(new MotanBizException("mock service call process error", e.getCause()));
                }
                response.setException(new MotanBizException("mock service call process error", e));
            }
        }
        return response;
    }

    private Object invoke(Object clz, Method method, Object[] args, MockInfo info) throws InterruptedException, InvocationTargetException, IllegalAccessException {
        info.callNum.addAndGet(1L);
        long sleepTime = this.caclSleepTime(info);
        Thread.sleep(sleepTime);
        return method.invoke(clz, args);
    }

    private long caclSleepTime(MockInfo info) {
        double rMean = info.totalSleepTime.doubleValue() / (double)info.callNum.get();
        int n = new Random().nextInt(1000);
        long delta = (long)(rMean - (double)info.mean + 1.0);
        long sleepTime = n < 900 ? info.p90 : (900 <= n && n < 990 ? info.p99 : (990 <= n && n < 999 ? info.p999 : info.p999 + 1L));
        sleepTime = delta > 0L ? 0L : sleepTime;
        info.totalSleepTime.addAndGet(sleepTime);
        if (info.errorRate != 0.0) {
            int rate = 1;
            while (info.errorRate * (double)rate < 1.0) {
                rate *= 10;
            }
            if (new Random().nextInt(rate) == 1) {
                throw new RuntimeException();
            }
        }
        return sleepTime;
    }

    public Object parseMockValue(String mock) throws Exception {
        return this.parseMockValue(mock, null);
    }

    public Object parseMockValue(String mock, Type[] returnTypes) {
        Object value = "empty".equals(mock) ? ReflectUtil.getEmptyObject(returnTypes != null && returnTypes.length > 0 ? (Class)returnTypes[0] : null) : ("null".equals(mock) ? null : ("true".equals(mock) ? Boolean.valueOf(true) : ("false".equals(mock) ? Boolean.valueOf(false) : (mock.length() >= 2 && (mock.startsWith("\"") && mock.endsWith("\"") || mock.startsWith("'") && mock.endsWith("'")) ? mock.subSequence(1, mock.length() - 1) : (returnTypes != null && returnTypes.length > 0 && returnTypes[0] == String.class ? mock : mock)))));
        return value;
    }

    public static class MockInfo {
        private long mean;
        private long p90;
        private long p99;
        private long p999;
        private double errorRate;
        private AtomicLong callNum = new AtomicLong(0L);
        private AtomicLong totalSleepTime = new AtomicLong(0L);

        public MockInfo(URL url) {
            this.mean = Long.valueOf(url.getParameter(URLParamType.mean.getName(), URLParamType.mean.getValue()));
            this.p90 = Long.valueOf(url.getParameter(URLParamType.p90.getName(), URLParamType.p90.getValue()));
            this.p99 = Long.valueOf(url.getParameter(URLParamType.p99.getName(), URLParamType.p99.getValue()));
            this.p999 = Long.valueOf(url.getParameter(URLParamType.p999.getName(), URLParamType.p999.getValue()));
            this.errorRate = Double.valueOf(url.getParameter(URLParamType.errorRate.getName(), URLParamType.errorRate.getValue()));
        }
    }
}

