/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.filter;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.filter.InitializableFilter;
import com.weibo.api.motan.rpc.Caller;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

@SpiMeta(name="threadProtected")
public class ThreadProtectedFilter
implements InitializableFilter {
    protected static ConcurrentHashMap<String, AtomicInteger> portTotalMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, AtomicInteger> methodMap = new ConcurrentHashMap();
    protected AtomicInteger totalCount;
    protected int maxThread;
    protected int totalLimit;
    protected int methodLimit;
    protected boolean isProvider = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response filter(Caller<?> caller, Request request) {
        if (this.isProvider) {
            String requestKey = MotanFrameworkUtil.getFullMethodString(request);
            AtomicInteger methodCount = this.methodMap.get(requestKey);
            if (methodCount == null) {
                this.methodMap.putIfAbsent(requestKey, new AtomicInteger());
                methodCount = this.methodMap.get(requestKey);
            }
            try {
                int tCount = this.totalCount.incrementAndGet();
                int mCount = methodCount.incrementAndGet();
                if (tCount > this.totalLimit && mCount > this.methodLimit) {
                    Response response = this.reject(request.getInterfaceName() + "." + request.getMethodName(), mCount, tCount);
                    return response;
                }
                Response response = caller.call(request);
                return response;
            }
            finally {
                this.totalCount.decrementAndGet();
                methodCount.decrementAndGet();
            }
        }
        return caller.call(request);
    }

    private Response reject(String method, int requestCounter, int totalCounter) {
        DefaultResponse response = new DefaultResponse();
        MotanServiceException exception = new MotanServiceException("ThreadProtectedFilter reject request: request_counter=" + requestCounter + " total_counter=" + totalCounter + " max_thread=" + this.maxThread, MotanErrorMsgConstant.SERVICE_REJECT);
        exception.setStackTrace(new StackTraceElement[0]);
        response.setException(exception);
        LoggerUtil.error("ThreadProtectedFilter reject request: request_method=" + method + " request_counter=" + requestCounter + " =" + totalCounter + " max_thread=" + this.maxThread);
        return response;
    }

    @Override
    public void init(Caller<?> caller) {
        if (caller instanceof Provider) {
            String port = String.valueOf(caller.getUrl().getPort());
            this.totalCount = portTotalMap.get(port);
            if (this.totalCount == null) {
                portTotalMap.putIfAbsent(port, new AtomicInteger());
                this.totalCount = portTotalMap.get(port);
            }
            this.maxThread = caller.getUrl().getIntParameter(URLParamType.maxWorkerThread.getName(), URLParamType.maxWorkerThread.getIntValue());
            this.totalLimit = this.maxThread > 600 ? this.maxThread - 150 : this.maxThread * 3 / 4;
            int active = caller.getUrl().getIntParameter(URLParamType.actives.getName(), URLParamType.actives.getIntValue());
            this.methodLimit = active > 0 ? active : this.maxThread / 2;
            this.isProvider = true;
        }
    }
}

