/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.rpc;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanBizException;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.AbstractProvider;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.ExceptionUtil;
import com.weibo.api.motan.util.LoggerUtil;
import java.lang.reflect.Method;

@SpiMeta(name="motan")
public class DefaultProvider<T>
extends AbstractProvider<T> {
    protected T proxyImpl;

    public DefaultProvider(T proxyImpl, URL url, Class<T> clz) {
        super(url, clz);
        this.proxyImpl = proxyImpl;
    }

    @Override
    public T getImpl() {
        return this.proxyImpl;
    }

    @Override
    public Response invoke(Request request) {
        boolean transExceptionStack;
        DefaultResponse response = new DefaultResponse();
        Method method = this.lookupMethod(request.getMethodName(), request.getParamtersDesc());
        if (method == null) {
            MotanServiceException exception = new MotanServiceException("Service method not exist: " + request.getInterfaceName() + "." + request.getMethodName() + "(" + request.getParamtersDesc() + ")", MotanErrorMsgConstant.SERVICE_UNFOUND);
            response.setException(exception);
            return response;
        }
        boolean defaultThrowExceptionStack = URLParamType.transExceptionStack.getBooleanValue();
        try {
            Object value = method.invoke(this.proxyImpl, request.getArguments());
            response.setValue(value);
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                response.setException(new MotanBizException("provider call process error", e.getCause()));
            } else {
                response.setException(new MotanBizException("provider call process error", e));
            }
            boolean logException = true;
            for (Class<?> clazz : method.getExceptionTypes()) {
                if (!clazz.isInstance(response.getException().getCause())) continue;
                logException = false;
                defaultThrowExceptionStack = false;
                break;
            }
            if (logException) {
                LoggerUtil.error("Exception caught when during method invocation. request:" + request.toString(), e);
            } else {
                LoggerUtil.info("Exception caught when during method invocation. request:" + request.toString() + ", exception:" + response.getException().getCause().toString());
            }
        }
        catch (Throwable t) {
            if (t.getCause() != null) {
                response.setException(new MotanServiceException("provider has encountered a fatal error!", t.getCause()));
            } else {
                response.setException(new MotanServiceException("provider has encountered a fatal error!", t));
            }
            LoggerUtil.error("Exception caught when during method invocation. request:" + request.toString(), t);
        }
        if (response.getException() != null && !(transExceptionStack = this.url.getBooleanParameter(URLParamType.transExceptionStack.getName(), defaultThrowExceptionStack).booleanValue())) {
            ExceptionUtil.setMockStackTrace(response.getException().getCause());
        }
        response.setRpcProtocolVersion(request.getRpcProtocolVersion());
        response.setAttachments(request.getAttachments());
        return response;
    }
}

