/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.cluster.support;

import com.weibo.api.motan.closable.ShutDownHook;
import com.weibo.api.motan.cluster.Cluster;
import com.weibo.api.motan.cluster.HaStrategy;
import com.weibo.api.motan.cluster.LoadBalance;
import com.weibo.api.motan.common.MotanConstants;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.protocol.support.ProtocolFilterDecorator;
import com.weibo.api.motan.registry.NotifyListener;
import com.weibo.api.motan.registry.Registry;
import com.weibo.api.motan.registry.RegistryFactory;
import com.weibo.api.motan.rpc.Protocol;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.CollectionUtil;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanSwitcherUtil;
import com.weibo.api.motan.util.StringTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ClusterSupport<T>
implements NotifyListener {
    private static ConcurrentHashMap<String, Protocol> protocols = new ConcurrentHashMap();
    private static ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
    private static Set<ClusterSupport> refreshSet = new HashSet<ClusterSupport>();
    private Cluster<T> cluster;
    private List<URL> registryUrls;
    private URL url;
    private Class<T> interfaceClass;
    private Protocol protocol;
    private ConcurrentHashMap<URL, List<Referer<T>>> registryReferers = new ConcurrentHashMap();
    private int selectNodeCount;
    private ConcurrentHashMap<URL, Map<String, GroupUrlsSelector>> registryGroupUrlsSelectorMap = new ConcurrentHashMap();

    public ClusterSupport(Class<T> interfaceClass, List<URL> registryUrls, URL refUrl) {
        this.registryUrls = registryUrls;
        this.interfaceClass = interfaceClass;
        this.url = refUrl;
        this.protocol = this.getDecorateProtocol(this.url.getProtocol());
        int maxConnectionCount = this.url.getIntParameter(URLParamType.maxConnectionPerGroup.getName(), URLParamType.maxConnectionPerGroup.getIntValue());
        int maxClientConnection = this.url.getIntParameter(URLParamType.maxClientConnection.getName(), URLParamType.maxClientConnection.getIntValue());
        this.selectNodeCount = (int)Math.ceil(1.0 * (double)maxConnectionCount / (double)maxClientConnection);
    }

    public void init() {
        long start = System.currentTimeMillis();
        this.prepareCluster();
        URL subUrl = this.toSubscribeUrl(this.url);
        for (URL ru : this.registryUrls) {
            List<URL> directUrls;
            String directUrlStr = ru.getParameter(URLParamType.directUrl.getName());
            if (StringUtils.isNotBlank((CharSequence)directUrlStr) && !(directUrls = this.parseDirectUrls(directUrlStr)).isEmpty()) {
                this.notify(ru, directUrls);
                LoggerUtil.info("Use direct urls, refUrl={}, directUrls={}", this.url, directUrls);
                continue;
            }
            Registry registry = this.getRegistry(ru);
            registry.subscribe(subUrl, this);
        }
        boolean check = Boolean.parseBoolean(this.url.getParameter(URLParamType.check.getName(), URLParamType.check.getValue()));
        if (!CollectionUtil.isEmpty(this.cluster.getReferers()) || !check) {
            this.cluster.init();
            if (CollectionUtil.isEmpty(this.cluster.getReferers()) && !check) {
                LoggerUtil.warn(String.format("refer:%s", this.url.getPath() + "/" + this.url.getVersion()), "No services");
            }
            LoggerUtil.info("cluster init cost " + (System.currentTimeMillis() - start) + ", refer size:" + (this.cluster.getReferers() == null ? 0 : this.cluster.getReferers().size()) + ", cluster:" + this.cluster.getUrl().toSimpleString());
            return;
        }
        throw new MotanFrameworkException(String.format("ClusterSupport No service urls for the refer:%s, registries:%s", this.url.getIdentity(), this.registryUrls), MotanErrorMsgConstant.SERVICE_UNFOUND);
    }

    public void destroy() {
        URL subscribeUrl = this.toSubscribeUrl(this.url);
        for (URL ru : this.registryUrls) {
            try {
                Registry registry = this.getRegistry(ru);
                registry.unsubscribe(subscribeUrl, this);
                if ("referer".equals(this.url.getParameter(URLParamType.nodeType.getName()))) continue;
                registry.unregister(this.url);
            }
            catch (Exception e) {
                LoggerUtil.warn(String.format("Unregister or unsubscribe false for url (%s), registry= %s", this.url, ru.getIdentity()), e);
            }
        }
        try {
            this.getCluster().destroy();
        }
        catch (Exception e) {
            LoggerUtil.warn(String.format("Exception when destroy cluster: %s", this.getCluster().getUrl()));
        }
    }

    protected Registry getRegistry(URL url) {
        RegistryFactory registryFactory = ExtensionLoader.getExtensionLoader(RegistryFactory.class).getExtension(url.getProtocol());
        return registryFactory.getRegistry(url);
    }

    private URL toSubscribeUrl(URL url) {
        URL subUrl = url.createCopy();
        subUrl.addParameter(URLParamType.nodeType.getName(), "service");
        return subUrl;
    }

    @Override
    public synchronized void notify(URL registryUrl, List<URL> urls) {
        if (CollectionUtil.isEmpty(urls)) {
            this.onRegistryEmpty(registryUrl);
            LoggerUtil.warn("ClusterSupport config change notify, urls is empty: registry={} service={} urls=[]", registryUrl.getUri(), this.url.getIdentity());
            return;
        }
        LoggerUtil.info("ClusterSupport config change notify: registry={} service={} urls={}", registryUrl.getUri(), this.url.getIdentity(), this.getIdentities(urls));
        this.processWeights(urls);
        List<URL> serviceUrls = urls;
        if (this.selectNodeCount > 0 && MotanSwitcherUtil.switcherIsOpenWithDefault("feature.motan.partial.server", true)) {
            refreshSet.add(this);
            serviceUrls = this.selectUrls(registryUrl, urls);
        } else {
            refreshSet.remove(this);
        }
        this.doRefreshReferersByUrls(registryUrl, serviceUrls);
    }

    private void doRefreshReferersByUrls(URL registryUrl, List<URL> serviceUrls) {
        ArrayList<Referer<T>> newReferers = new ArrayList<Referer<T>>();
        for (URL u : serviceUrls) {
            if (!u.canServe(this.url)) continue;
            Referer<T> referer = this.getExistingReferer(u, this.registryReferers.get(registryUrl));
            if (referer == null) {
                URL refererURL = u.createCopy();
                this.mergeClientConfigs(refererURL);
                referer = this.protocol.refer(this.interfaceClass, refererURL, u);
            }
            if (referer == null) continue;
            newReferers.add(referer);
        }
        if (CollectionUtil.isEmpty(newReferers)) {
            this.onRegistryEmpty(registryUrl);
            return;
        }
        this.registryReferers.put(registryUrl, newReferers);
        this.refreshCluster();
    }

    protected List<URL> selectUrls(URL registryUrl, List<URL> urls) {
        HashMap groupUrlsMap = new HashMap();
        for (URL uRL : urls) {
            String string = uRL.getGroup();
            if (!groupUrlsMap.containsKey(string)) {
                groupUrlsMap.put(string, new ArrayList());
            }
            if (!uRL.canServe(this.url)) continue;
            ((List)groupUrlsMap.get(string)).add(uRL);
        }
        Map selectorMap = this.registryGroupUrlsSelectorMap.computeIfAbsent(registryUrl, k -> new HashMap());
        for (Map.Entry entry : groupUrlsMap.entrySet()) {
            GroupUrlsSelector groupUrlsSelector = selectorMap.computeIfAbsent(entry.getKey(), k -> new GroupUrlsSelector());
            if (((List)entry.getValue()).size() <= this.selectNodeCount) {
                LoggerUtil.info("ClusterSupport config change notify: registry={} service={} group={} size={} non increased", registryUrl.getUri(), this.url.getIdentity(), entry.getKey(), ((List)entry.getValue()).size());
            }
            groupUrlsSelector.updateBaseUrls((List)entry.getValue());
        }
        HashSet hashSet = new HashSet(selectorMap.keySet());
        hashSet.removeAll(groupUrlsMap.keySet());
        if (!CollectionUtil.isEmpty(hashSet)) {
            for (String removeGroup : hashSet) {
                selectorMap.remove(removeGroup);
            }
        }
        return this.doSelectUrls(registryUrl);
    }

    private List<URL> doSelectUrls(URL registryUrl) {
        ArrayList<URL> result = new ArrayList<URL>();
        Map selectors = this.registryGroupUrlsSelectorMap.getOrDefault(registryUrl, Collections.emptyMap());
        for (Map.Entry entry : selectors.entrySet()) {
            List<URL> urls = ((GroupUrlsSelector)entry.getValue()).selectUrls();
            result.addAll(urls);
            LoggerUtil.info("ClusterSupport select group urls: registry={} service={} group={} expectSize={} size={} urls={}", registryUrl.getUri(), this.url.getIdentity(), entry.getKey(), ((GroupUrlsSelector)entry.getValue()).getSelectSize(), urls.size(), this.getIdentities(urls));
        }
        return result;
    }

    protected void refreshReferers() {
        for (Map.Entry<URL, List<Referer<T>>> entry : this.registryReferers.entrySet()) {
            URL registryUrl = entry.getKey();
            LoggerUtil.info("ClusterSupport refreshReferers: registry={} service={}", registryUrl.getUri(), this.url.getIdentity());
            Map<String, GroupUrlsSelector> groupSelectorMap = this.registryGroupUrlsSelectorMap.get(registryUrl);
            if (groupSelectorMap == null || groupSelectorMap.size() == 0) {
                LoggerUtil.warn("ClusterSupport refreshReferers, groupSelectorMap is empty: registry={} service={}", registryUrl.getUri(), this.url.getIdentity());
                continue;
            }
            HashMap<String, Integer> groupAvailableCounter = new HashMap<String, Integer>(groupSelectorMap.size());
            for (Referer<T> referer : entry.getValue()) {
                String group = referer.getServiceUrl().getGroup();
                if (!referer.isAvailable()) continue;
                groupAvailableCounter.put(group, groupAvailableCounter.getOrDefault(group, 0) + 1);
            }
            boolean needRefresh = false;
            for (Map.Entry counter : groupAvailableCounter.entrySet()) {
                int selectSize;
                String group = (String)counter.getKey();
                int available = (Integer)counter.getValue();
                GroupUrlsSelector selector = groupSelectorMap.get(group);
                if (selector == null) {
                    LoggerUtil.warn("ClusterSupport refreshReferers ,urls selector is null: registry={} service={} group={}", registryUrl.getUri(), this.url.getIdentity(), group);
                    continue;
                }
                int newSize = selectSize = selector.getSelectSize();
                if ((double)available <= 1.0 * (double)this.selectNodeCount * 2.0 / 3.0 && selector.getBaseUrlsSize() > selectSize) {
                    newSize = Math.min(selectSize + (this.selectNodeCount - available), selector.getBaseUrlsSize());
                } else if ((double)available >= 1.0 * (double)this.selectNodeCount * 4.0 / 3.0) {
                    newSize = selectSize - (available - this.selectNodeCount);
                }
                if (newSize == selectSize) continue;
                needRefresh = true;
                selector.setSelectSize(newSize);
                LoggerUtil.info("ClusterSupport refreshReferers selectSize changed: registry={} service={} group={} newSize={} oldSize={}", registryUrl.getUri(), this.url.getIdentity(), group, newSize, selectSize);
            }
            if (!needRefresh) continue;
            List<URL> list = this.doSelectUrls(registryUrl);
            this.doRefreshReferersByUrls(registryUrl, list);
        }
    }

    private void processWeights(List<URL> urls) {
        if (urls != null && !urls.isEmpty()) {
            URL ruleUrl = urls.get(0);
            String weights = URLParamType.weights.getValue();
            if ("rule".equalsIgnoreCase(ruleUrl.getProtocol())) {
                weights = ruleUrl.getParameter(URLParamType.weights.getName(), URLParamType.weights.getValue());
                urls.remove(0);
            }
            LoggerUtil.info("refresh weight. weight=" + weights);
            this.cluster.getLoadBalance().setWeightString(weights);
        }
    }

    private void onRegistryEmpty(URL excludeRegistryUrl) {
        boolean noMoreOtherRefers;
        boolean bl = noMoreOtherRefers = this.registryReferers.size() == 1 && this.registryReferers.containsKey(excludeRegistryUrl);
        if (noMoreOtherRefers) {
            LoggerUtil.warn(String.format("Ignore notify for no more referers in this cluster, registry: %s, cluster=%s", excludeRegistryUrl, this.getUrl()));
        } else {
            this.registryReferers.remove(excludeRegistryUrl);
            this.refreshCluster();
        }
    }

    protected Protocol getDecorateProtocol(String protocolName) {
        Protocol decorateProtocol = protocols.get(protocolName);
        if (decorateProtocol == null) {
            protocols.putIfAbsent(protocolName, new ProtocolFilterDecorator(ExtensionLoader.getExtensionLoader(Protocol.class).getExtension(protocolName)));
            decorateProtocol = protocols.get(protocolName);
        }
        return decorateProtocol;
    }

    private Referer<T> getExistingReferer(URL url, List<Referer<T>> referers) {
        if (referers == null) {
            return null;
        }
        for (Referer<T> r : referers) {
            if (!ObjectUtils.equals((Object)url, (Object)r.getUrl()) && !ObjectUtils.equals((Object)url, (Object)r.getServiceUrl())) continue;
            return r;
        }
        return null;
    }

    private void mergeClientConfigs(URL refererURL) {
        String application = refererURL.getParameter(URLParamType.application.getName(), URLParamType.application.getValue());
        String module = refererURL.getParameter(URLParamType.module.getName(), URLParamType.module.getValue());
        refererURL.addParameters(this.url.getParameters());
        refererURL.addParameter(URLParamType.application.getName(), application);
        refererURL.addParameter(URLParamType.module.getName(), module);
    }

    private void refreshCluster() {
        ArrayList referers = new ArrayList();
        for (List<Referer<T>> refs : this.registryReferers.values()) {
            referers.addAll(refs);
        }
        this.cluster.onRefresh(referers);
    }

    public Cluster<T> getCluster() {
        return this.cluster;
    }

    public URL getUrl() {
        return this.url;
    }

    private String getIdentities(List<URL> urls) {
        if (urls == null || urls.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (URL u : urls) {
            builder.append(u.getIdentity()).append(",");
        }
        builder.setLength(builder.length() - 1);
        builder.append("]");
        return builder.toString();
    }

    private void prepareCluster() {
        String clusterName = this.url.getParameter(URLParamType.cluster.getName(), URLParamType.cluster.getValue());
        String loadbalanceName = this.url.getParameter(URLParamType.loadbalance.getName(), URLParamType.loadbalance.getValue());
        String haStrategyName = this.url.getParameter(URLParamType.haStrategy.getName(), URLParamType.haStrategy.getValue());
        this.cluster = ExtensionLoader.getExtensionLoader(Cluster.class).getExtension(clusterName);
        LoadBalance loadBalance = ExtensionLoader.getExtensionLoader(LoadBalance.class).getExtension(loadbalanceName);
        HaStrategy ha = ExtensionLoader.getExtensionLoader(HaStrategy.class).getExtension(haStrategyName);
        ha.setUrl(this.url);
        this.cluster.setLoadBalance(loadBalance);
        this.cluster.setHaStrategy(ha);
        this.cluster.setUrl(this.url);
    }

    private List<URL> parseDirectUrls(String directUrlStr) {
        String[] durlArr = MotanConstants.COMMA_SPLIT_PATTERN.split(directUrlStr);
        ArrayList<URL> directUrls = new ArrayList<URL>();
        for (String dus : durlArr) {
            URL du = URL.valueOf(StringTools.urlDecode(dus));
            if (du == null) continue;
            directUrls.add(du);
        }
        return directUrls;
    }

    static {
        executorService.scheduleAtFixedRate(() -> {
            for (ClusterSupport clusterSupport : refreshSet) {
                clusterSupport.refreshReferers();
            }
        }, 60L, 60L, TimeUnit.SECONDS);
        ShutDownHook.registerShutdownHook(() -> {
            if (!executorService.isShutdown()) {
                executorService.shutdown();
            }
        });
    }

    private class GroupUrlsSelector {
        private List<URL> baseUrls = new ArrayList<URL>();
        private int selectSize;

        GroupUrlsSelector() {
            this.selectSize = ClusterSupport.this.selectNodeCount;
        }

        void updateBaseUrls(List<URL> newBaseUrls) {
            this.baseUrls.retainAll(newBaseUrls);
            HashSet<URL> addedUrls = new HashSet<URL>(newBaseUrls);
            addedUrls.removeAll(this.baseUrls);
            for (URL addedUrl : addedUrls) {
                int addPosition = ThreadLocalRandom.current().nextInt(this.baseUrls.size() + 1);
                this.baseUrls.add(addPosition, addedUrl);
            }
        }

        List<URL> selectUrls() {
            ArrayList<URL> result = new ArrayList<URL>(this.selectSize);
            if (this.baseUrls.size() >= this.selectSize) {
                result.addAll(this.baseUrls.subList(0, this.selectSize));
            } else {
                result.addAll(this.baseUrls);
            }
            return result;
        }

        int getSelectSize() {
            return this.selectSize;
        }

        void setSelectSize(int selectSize) {
            this.selectSize = selectSize;
        }

        int getBaseUrlsSize() {
            return this.baseUrls.size();
        }
    }
}

