/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.rpc;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.rpc.AbstractExporter;
import com.weibo.api.motan.rpc.Exporter;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.transport.EndpointFactory;
import com.weibo.api.motan.transport.ProviderMessageRouter;
import com.weibo.api.motan.transport.Server;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultRpcExporter<T>
extends AbstractExporter<T> {
    protected final ConcurrentHashMap<String, ProviderMessageRouter> ipPort2RequestRouter;
    protected final ConcurrentHashMap<String, Exporter<?>> exporterMap;
    protected Server server;
    protected EndpointFactory endpointFactory;

    public DefaultRpcExporter(Provider<T> provider, URL url, ConcurrentHashMap<String, ProviderMessageRouter> ipPort2RequestRouter, ConcurrentHashMap<String, Exporter<?>> exporterMap) {
        super(provider, url);
        this.exporterMap = exporterMap;
        this.ipPort2RequestRouter = ipPort2RequestRouter;
        ProviderMessageRouter requestRouter = this.initRequestRouter(url);
        this.endpointFactory = ExtensionLoader.getExtensionLoader(EndpointFactory.class).getExtension(url.getParameter(URLParamType.endpointFactory.getName(), URLParamType.endpointFactory.getValue()));
        this.server = this.endpointFactory.createServer(url, requestRouter);
    }

    @Override
    public void unexport() {
        ProviderMessageRouter requestRouter;
        String protocolKey = MotanFrameworkUtil.getProtocolKey(this.url);
        String ipPort = this.url.getServerPortStr();
        Exporter<?> exporter = this.exporterMap.remove(protocolKey);
        if (exporter != null) {
            exporter.destroy();
        }
        if ((requestRouter = this.ipPort2RequestRouter.get(ipPort)) != null) {
            requestRouter.removeProvider(this.provider);
        }
        LoggerUtil.info("DefaultRpcExporter unexport Success: url={}", this.url);
    }

    @Override
    protected boolean doInit() {
        boolean result = this.server.open();
        if (result && this.getUrl().getPort() == 0) {
            ProviderMessageRouter requestRouter = this.ipPort2RequestRouter.remove(this.getUrl().getServerPortStr());
            if (requestRouter == null) {
                throw new MotanFrameworkException("can not find message router. url:" + this.getUrl().getIdentity());
            }
            this.updateRealServerPort(this.server.getLocalAddress().getPort());
            this.ipPort2RequestRouter.put(this.getUrl().getServerPortStr(), requestRouter);
        }
        return result;
    }

    @Override
    public boolean isAvailable() {
        return this.server.isAvailable();
    }

    @Override
    public void destroy() {
        this.endpointFactory.safeReleaseResource(this.server, this.url);
        LoggerUtil.info("DefaultRpcExporter destroy Success: url={}", this.url);
    }

    protected ProviderMessageRouter initRequestRouter(URL url) {
        String ipPort = url.getServerPortStr();
        ProviderMessageRouter requestRouter = this.ipPort2RequestRouter.get(ipPort);
        if (requestRouter == null) {
            ProviderMessageRouter router = new ProviderMessageRouter(url);
            this.ipPort2RequestRouter.putIfAbsent(ipPort, router);
            requestRouter = this.ipPort2RequestRouter.get(ipPort);
        }
        requestRouter.addProvider(this.provider);
        return requestRouter;
    }
}

