/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.util;

import com.codahale.metrics.Histogram;
import com.weibo.api.motan.util.AccessStatisticResult;
import com.weibo.api.motan.util.InternalMetricsFactory;
import com.weibo.api.motan.util.StatsUtil;
import java.util.concurrent.atomic.AtomicInteger;

class AccessStatisticItem {
    private String name;
    private int currentIndex;
    private AtomicInteger[] costTimes = null;
    private AtomicInteger[] bizProcessTimes = null;
    private AtomicInteger[] totalCounter = null;
    private AtomicInteger[] slowCounter = null;
    private AtomicInteger[] bizExceptionCounter = null;
    private AtomicInteger[] otherExceptionCounter = null;
    private Histogram histogram = null;
    private int length;

    public AccessStatisticItem(String name, long currentTimeMillis) {
        this(name, currentTimeMillis, 60);
    }

    public AccessStatisticItem(String name, long currentTimeMillis, int length) {
        this.name = name;
        this.costTimes = this.initAtomicIntegerArr(length);
        this.bizProcessTimes = this.initAtomicIntegerArr(length);
        this.totalCounter = this.initAtomicIntegerArr(length);
        this.slowCounter = this.initAtomicIntegerArr(length);
        this.bizExceptionCounter = this.initAtomicIntegerArr(length);
        this.otherExceptionCounter = this.initAtomicIntegerArr(length);
        this.length = length;
        this.currentIndex = this.getIndex(currentTimeMillis, length);
        this.histogram = InternalMetricsFactory.getRegistryInstance(name).histogram(StatsUtil.HISTOGRAM_NAME);
    }

    private AtomicInteger[] initAtomicIntegerArr(int size) {
        AtomicInteger[] arrs = new AtomicInteger[size];
        for (int i = 0; i < arrs.length; ++i) {
            arrs[i] = new AtomicInteger(0);
        }
        return arrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void statistic(long currentTimeMillis, long costTimeMillis, long bizProcessTime, int slowCost, StatsUtil.AccessStatus accessStatus) {
        int tempIndex = this.getIndex(currentTimeMillis, this.length);
        if (this.currentIndex != tempIndex) {
            AccessStatisticItem accessStatisticItem = this;
            synchronized (accessStatisticItem) {
                if (this.currentIndex != tempIndex) {
                    this.reset(tempIndex);
                    this.currentIndex = tempIndex;
                }
            }
        }
        this.costTimes[this.currentIndex].addAndGet((int)costTimeMillis);
        this.bizProcessTimes[this.currentIndex].addAndGet((int)bizProcessTime);
        this.totalCounter[this.currentIndex].incrementAndGet();
        if (costTimeMillis >= (long)slowCost) {
            this.slowCounter[this.currentIndex].incrementAndGet();
        }
        if (accessStatus == StatsUtil.AccessStatus.BIZ_EXCEPTION) {
            this.bizExceptionCounter[this.currentIndex].incrementAndGet();
        } else if (accessStatus == StatsUtil.AccessStatus.OTHER_EXCEPTION) {
            this.otherExceptionCounter[this.currentIndex].incrementAndGet();
        }
        this.histogram.update(costTimeMillis);
        String[] names = this.name.split("\\|");
        String appName = names[1] + "|" + names[2];
        InternalMetricsFactory.getRegistryInstance(appName).histogram(StatsUtil.HISTOGRAM_NAME).update(costTimeMillis);
    }

    private int getIndex(long currentTimeMillis, int periodSecond) {
        return (int)(currentTimeMillis / 1000L % (long)periodSecond);
    }

    private void reset(int index) {
        this.costTimes[index].set(0);
        this.totalCounter[index].set(0);
        this.bizProcessTimes[index].set(0);
        this.slowCounter[index].set(0);
        this.bizExceptionCounter[index].set(0);
        this.otherExceptionCounter[index].set(0);
    }

    AccessStatisticResult getStatisticResult(long currentTimeMillis, int peroidSecond) {
        long currentTimeSecond = currentTimeMillis / 1000L;
        int startIndex = this.getIndex(--currentTimeSecond * 1000L, this.length);
        AccessStatisticResult result = new AccessStatisticResult();
        for (int i = 0; i < peroidSecond; ++i) {
            int currentIndex = (startIndex - i + this.length) % this.length;
            result.costTime += (double)this.costTimes[currentIndex].get();
            result.bizTime += (double)this.bizProcessTimes[currentIndex].get();
            result.totalCount += this.totalCounter[currentIndex].get();
            result.slowCount += this.slowCounter[currentIndex].get();
            result.bizExceptionCount += this.bizExceptionCounter[currentIndex].get();
            result.otherExceptionCount += this.otherExceptionCounter[currentIndex].get();
            if (this.totalCounter[currentIndex].get() > result.maxCount) {
                result.maxCount = this.totalCounter[currentIndex].get();
                continue;
            }
            if (this.totalCounter[currentIndex].get() >= result.minCount && result.minCount != -1) continue;
            result.minCount = this.totalCounter[currentIndex].get();
        }
        return result;
    }

    void clearStatistic(long currentTimeMillis, int peroidSecond) {
        long currentTimeSecond = currentTimeMillis / 1000L;
        int startIndex = this.getIndex(--currentTimeSecond * 1000L, this.length);
        for (int i = 0; i < peroidSecond; ++i) {
            int currentIndex = (startIndex - i + this.length) % this.length;
            this.reset(currentIndex);
        }
    }
}

