/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty;

import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.execution.ExecutionHandler;

public class ProtectedExecutionHandler
extends ExecutionHandler {
    private ThreadPoolExecutor threadPoolExecutor;

    ProtectedExecutionHandler(ThreadPoolExecutor threadPoolExecutor) {
        super((Executor)threadPoolExecutor);
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public void handleUpstream(ChannelHandlerContext context, ChannelEvent e) throws Exception {
        block2: {
            try {
                super.handleUpstream(context, e);
            }
            catch (RejectedExecutionException rejectException) {
                if (!(e instanceof MessageEvent) || !(((MessageEvent)e).getMessage() instanceof Request)) break block2;
                Request request = (Request)((MessageEvent)e).getMessage();
                DefaultResponse response = new DefaultResponse();
                response.setRequestId(request.getRequestId());
                response.setException((Exception)((Object)new MotanServiceException("process thread pool is full, reject", MotanErrorMsgConstant.SERVICE_REJECT)));
                e.getChannel().write((Object)response);
                LoggerUtil.debug((String)"process thread pool is full, reject, active={} poolSize={} corePoolSize={} maxPoolSize={} taskCount={} requestId={}", (Object[])new Object[]{this.threadPoolExecutor.getActiveCount(), this.threadPoolExecutor.getPoolSize(), this.threadPoolExecutor.getCorePoolSize(), this.threadPoolExecutor.getMaximumPoolSize(), this.threadPoolExecutor.getTaskCount(), request.getRequestId()});
            }
        }
    }
}

