/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty;

import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.transport.netty.NettyChannel;
import com.weibo.api.motan.transport.netty.NettyClient;
import com.weibo.api.motan.util.LoggerUtil;
import org.apache.commons.pool.BasePoolableObjectFactory;

public class NettyChannelFactory
extends BasePoolableObjectFactory {
    private String factoryName = "";
    private NettyClient nettyClient;

    public NettyChannelFactory(NettyClient nettyClient) {
        this.nettyClient = nettyClient;
        this.factoryName = "NettyChannelFactory_" + nettyClient.getUrl().getHost() + "_" + nettyClient.getUrl().getPort();
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public String toString() {
        return this.factoryName;
    }

    public Object makeObject() throws Exception {
        NettyChannel nettyChannel = new NettyChannel(this.nettyClient);
        nettyChannel.open();
        return nettyChannel;
    }

    public void destroyObject(Object obj) throws Exception {
        if (obj instanceof NettyChannel) {
            NettyChannel client = (NettyChannel)obj;
            URL url = this.nettyClient.getUrl();
            try {
                client.close();
                LoggerUtil.info((String)(this.factoryName + " client disconnect Success: " + url.getUri()));
            }
            catch (Exception e) {
                LoggerUtil.error((String)(this.factoryName + " client disconnect Error: " + url.getUri()), (Throwable)e);
            }
        }
    }

    public boolean validateObject(Object obj) {
        if (obj instanceof NettyChannel) {
            NettyChannel client = (NettyChannel)obj;
            try {
                return client.isAvailable();
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public void activateObject(Object obj) throws Exception {
        NettyChannel client;
        if (obj instanceof NettyChannel && !(client = (NettyChannel)obj).isAvailable()) {
            client.open();
        }
    }

    public void passivateObject(Object obj) throws Exception {
    }
}

