/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty4;

import com.weibo.api.motan.common.ChannelState;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.exception.MotanAbstractException;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.ResponseFuture;
import com.weibo.api.motan.rpc.RpcContext;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.transport.AbstractSharedPoolClient;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.transport.MessageHandler;
import com.weibo.api.motan.transport.SharedObjectFactory;
import com.weibo.api.motan.transport.TransportException;
import com.weibo.api.motan.transport.netty4.NettyChannelFactory;
import com.weibo.api.motan.transport.netty4.NettyChannelHandler;
import com.weibo.api.motan.transport.netty4.NettyDecoder;
import com.weibo.api.motan.transport.netty4.NettyEncoder;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import com.weibo.api.motan.util.StatisticCallback;
import com.weibo.api.motan.util.StatsUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class NettyClient
extends AbstractSharedPoolClient
implements StatisticCallback {
    private static final NioEventLoopGroup nioEventLoopGroup = new NioEventLoopGroup();
    private static ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(1);
    protected ConcurrentMap<Long, ResponseFuture> callbackMap = new ConcurrentHashMap<Long, ResponseFuture>();
    private ScheduledFuture<?> timeMonitorFuture = null;
    private Bootstrap bootstrap;
    private int fusingThreshold;
    private AtomicLong errorCount = new AtomicLong(0L);

    public NettyClient(URL url) {
        super(url);
        this.fusingThreshold = url.getIntParameter(URLParamType.fusingThreshold.getName(), URLParamType.fusingThreshold.getIntValue());
        this.timeMonitorFuture = scheduledExecutor.scheduleWithFixedDelay(new TimeoutMonitor("timeout_monitor_" + url.getHost() + "_" + url.getPort()), 100L, 100L, TimeUnit.MILLISECONDS);
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    protected SharedObjectFactory createChannelFactory() {
        return new NettyChannelFactory(this);
    }

    public Response request(Request request) throws TransportException {
        if (!this.isAvailable()) {
            throw new MotanServiceException("NettyChannel is unavailable: url=" + this.url.getUri() + MotanFrameworkUtil.toString((Request)request));
        }
        boolean isAsync = false;
        Object async = RpcContext.getContext().getAttribute((Object)"Async");
        if (async != null && async instanceof Boolean) {
            isAsync = (Boolean)async;
        }
        return this.request(request, isAsync);
    }

    public void heartbeat(Request request) {
        if (this.state.isUnInitState() || this.state.isCloseState()) {
            LoggerUtil.warn((String)"NettyClient heartbeat Error: state={} url={}", (Object[])new Object[]{this.state.name(), this.url.getUri()});
            return;
        }
        LoggerUtil.info((String)"NettyClient heartbeat request: url={}", (Object[])new Object[]{this.url.getUri()});
        try {
            this.request(request, true);
        }
        catch (Exception e) {
            LoggerUtil.error((String)"NettyClient heartbeat Error: url={}, {}", (Object[])new Object[]{this.url.getUri(), e.getMessage()});
        }
    }

    private Response request(Request request, boolean async) throws TransportException {
        Response response;
        try {
            Channel channel = this.getChannel();
            MotanFrameworkUtil.logEvent((Request)request, (String)"TRACE_CONNECTION");
            if (channel == null) {
                LoggerUtil.error((String)("NettyClient borrowObject null: url=" + this.url.getUri() + " " + MotanFrameworkUtil.toString((Request)request)));
                return null;
            }
            response = channel.request(request);
        }
        catch (Exception e) {
            LoggerUtil.error((String)("NettyClient request Error: url=" + this.url.getUri() + " " + MotanFrameworkUtil.toString((Request)request) + ", " + e.getMessage()));
            if (e instanceof MotanAbstractException) {
                throw (MotanAbstractException)e;
            }
            throw new MotanServiceException("NettyClient request Error: url=" + this.url.getUri() + " " + MotanFrameworkUtil.toString((Request)request), (Throwable)e);
        }
        response = this.asyncResponse(response, async);
        return response;
    }

    private Response asyncResponse(Response response, boolean async) {
        if (async || !(response instanceof ResponseFuture)) {
            return response;
        }
        return new DefaultResponse(response);
    }

    public synchronized boolean open() {
        if (this.isAvailable()) {
            return true;
        }
        this.bootstrap = new Bootstrap();
        int timeout = this.getUrl().getIntParameter(URLParamType.connectTimeout.getName(), URLParamType.connectTimeout.getIntValue());
        if (timeout <= 0) {
            throw new MotanFrameworkException("NettyClient init Error: timeout(" + timeout + ") <= 0 is forbid.", MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
        }
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)timeout);
        this.bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        final int maxContentLength = this.url.getIntParameter(URLParamType.maxContentLength.getName(), URLParamType.maxContentLength.getIntValue());
        ((Bootstrap)((Bootstrap)this.bootstrap.group((EventLoopGroup)nioEventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)new NettyDecoder(NettyClient.this.codec, (Channel)NettyClient.this, maxContentLength));
                pipeline.addLast("encoder", (ChannelHandler)new NettyEncoder());
                pipeline.addLast("handler", (ChannelHandler)new NettyChannelHandler((Channel)NettyClient.this, new MessageHandler(){

                    public Object handle(Channel channel, Object message) {
                        Response response = (Response)message;
                        ResponseFuture responseFuture = NettyClient.this.removeCallback(response.getRequestId());
                        if (responseFuture == null) {
                            LoggerUtil.warn((String)"NettyClient has response from server, but responseFuture not exist, requestId={}", (Object[])new Object[]{response.getRequestId()});
                            return null;
                        }
                        if (response.getException() != null) {
                            responseFuture.onFailure(response);
                        } else {
                            responseFuture.onSuccess(response);
                        }
                        return null;
                    }
                }));
            }
        });
        this.initPool();
        LoggerUtil.info((String)"NettyClient finish Open: url={}", (Object[])new Object[]{this.url});
        StatsUtil.registryStatisticCallback((StatisticCallback)this);
        this.state = ChannelState.ALIVE;
        return true;
    }

    public synchronized void close() {
        this.close(0);
    }

    public synchronized void close(int timeout) {
        if (this.state.isCloseState()) {
            return;
        }
        try {
            this.cleanup();
            if (this.state.isUnInitState()) {
                LoggerUtil.info((String)"NettyClient close fail: state={}, url={}", (Object[])new Object[]{this.state.value, this.url.getUri()});
                return;
            }
            this.state = ChannelState.CLOSE;
            LoggerUtil.info((String)"NettyClient close Success: url={}", (Object[])new Object[]{this.url.getUri()});
        }
        catch (Exception e) {
            LoggerUtil.error((String)("NettyClient close Error: url=" + this.url.getUri()), (Throwable)e);
        }
    }

    public void cleanup() {
        this.timeMonitorFuture.cancel(true);
        this.callbackMap.clear();
        this.closeAllChannels();
        StatsUtil.unRegistryStatisticCallback((StatisticCallback)this);
    }

    public boolean isClosed() {
        return this.state.isCloseState();
    }

    public boolean isAvailable() {
        return this.state.isAliveState();
    }

    public URL getUrl() {
        return this.url;
    }

    public String statisticCallback() {
        if (this.isAvailable() && this.callbackMap.size() < 100) {
            return null;
        }
        return String.format("identity: %s available: %s concurrent_count: %s", this.url.getIdentity(), this.isAvailable(), this.callbackMap.size());
    }

    public ResponseFuture removeCallback(long requestId) {
        return (ResponseFuture)this.callbackMap.remove(requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrErrorCount() {
        long count = this.errorCount.incrementAndGet();
        if (count >= (long)this.fusingThreshold && this.state.isAliveState()) {
            NettyClient nettyClient = this;
            synchronized (nettyClient) {
                count = this.errorCount.longValue();
                if (count >= (long)this.fusingThreshold && this.state.isAliveState()) {
                    LoggerUtil.error((String)("NettyClient unavailable Error: url=" + this.url.getIdentity() + " " + this.url.getServerPortStr()));
                    this.state = ChannelState.UNALIVE;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetErrorCount() {
        this.errorCount.set(0L);
        if (this.state.isAliveState()) {
            return;
        }
        NettyClient nettyClient = this;
        synchronized (nettyClient) {
            long count;
            if (this.state.isAliveState()) {
                return;
            }
            if (this.state.isUnAliveState() && (count = this.errorCount.longValue()) < (long)this.fusingThreshold) {
                this.state = ChannelState.ALIVE;
                LoggerUtil.info((String)("NettyClient recover available: url=" + this.url.getIdentity() + " " + this.url.getServerPortStr()));
            }
        }
    }

    public void registerCallback(long requestId, ResponseFuture responseFuture) {
        if (this.callbackMap.size() >= 20000) {
            throw new MotanServiceException("NettyClient over of max concurrent request, drop request, url: " + this.url.getUri() + " requestId=" + requestId, MotanErrorMsgConstant.SERVICE_REJECT, false);
        }
        this.callbackMap.put(requestId, responseFuture);
    }

    class TimeoutMonitor
    implements Runnable {
        private String name;

        public TimeoutMonitor(String name) {
            this.name = name;
        }

        @Override
        public void run() {
            long currentTime = System.currentTimeMillis();
            for (Map.Entry entry : NettyClient.this.callbackMap.entrySet()) {
                try {
                    ResponseFuture future = (ResponseFuture)entry.getValue();
                    if (future.getCreateTime() + (long)future.getTimeout() >= currentTime) continue;
                    NettyClient.this.removeCallback((Long)entry.getKey());
                    future.cancel();
                }
                catch (Exception e) {
                    LoggerUtil.error((String)(this.name + " clear timeout future Error: uri=" + NettyClient.this.url.getUri() + " requestId=" + entry.getKey()), (Throwable)e);
                }
            }
        }
    }
}

