/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.bean;

import com.weicoder.common.params.StateParams;

public final class StateCode {
    public static final StateCode SUCCESS = new StateCode(StateParams.SUCCESS, StateParams.SUCCESS_MSG);
    public static final StateCode ERROR = new StateCode(StateParams.ERROR, StateParams.getMessage(StateParams.ERROR));
    public static final StateCode NULL = new StateCode(StateParams.NULL, StateParams.getMessage(StateParams.NULL));
    private int code;
    private Object content;
    private String message;

    public static StateCode build(int code) {
        return StateCode.build(code, StateParams.getMessage(code));
    }

    public static StateCode build(int code, String message) {
        return new StateCode(code, message);
    }

    public static StateCode build(Object content) {
        return new StateCode(content);
    }

    public boolean success() {
        return this.equals(SUCCESS);
    }

    public Object[] to() {
        return new Object[]{this.code, this.message};
    }

    public Object getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.code;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StateCode other = (StateCode)obj;
        return this.code == other.code;
    }

    public String toString() {
        return "StateCode [code=" + this.code + ", content=" + this.content + ", message=" + this.message + "]";
    }

    private StateCode(int code, String message) {
        this.code = code;
        this.content = message;
        this.message = message;
    }

    private StateCode(Object content) {
        this.code = StateParams.SUCCESS;
        this.content = content;
        this.message = StateParams.SUCCESS_MSG;
    }

    private StateCode() {
    }
}

