/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.config;

import com.weicoder.common.U;
import com.weicoder.common.W;
import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.lang.Lists;
import com.weicoder.common.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

public final class Config {
    private Properties ps;

    public Config(String fileName) {
        this.ps = new Properties();
        try (InputStream in = U.R.loadResource(fileName);){
            if (in != null) {
                this.ps.load(in);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Config(Properties ps) {
        this.ps = ps;
    }

    public Properties getProperties() {
        return this.ps;
    }

    public List<String> getList(String key, List<String> defaultValue) {
        return Lists.newList(this.getStringArray(key, U.E.isEmpty(defaultValue) ? ArrayConstants.STRING_EMPTY : Lists.toArray(defaultValue)));
    }

    public String[] getStringArray(String key) {
        return this.getStringArray(key, ArrayConstants.STRING_EMPTY);
    }

    public String[] getStringArray(String key, String[] defaultValue) {
        String s = this.getString(key);
        if (U.E.isEmpty(s)) {
            return defaultValue;
        }
        return s.split(",");
    }

    public String getString(String key) {
        return this.getString(key, "");
    }

    public String getString(String key, String defaultValue) {
        return StringUtil.trim(this.ps.getProperty(key, defaultValue));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return W.C.toBoolean(this.getString(key), defaultValue);
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        return W.C.toInt(this.getString(key), defaultValue);
    }

    public byte getByte(String key) {
        return this.getByte(key, Byte.parseByte("0"));
    }

    public byte getByte(String key, byte defaultValue) {
        return W.C.toByte(this.getString(key), defaultValue);
    }

    public long getLong(String key, long defaultValue) {
        return W.C.toLong(this.getString(key), defaultValue);
    }

    public short getShort(String key, short defaultValue) {
        return W.C.toShort(this.getString(key), defaultValue);
    }

    public boolean exists(String key) {
        return this.ps.containsKey(key);
    }

    public String toString() {
        return "Config [ps=" + this.ps + "]";
    }
}

