/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.crypto;

import com.weicoder.common.U;
import com.weicoder.common.codec.Hex;
import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.crypto.Digest;
import com.weicoder.common.crypto.base.BaseCrypt;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.StringUtil;

public class Decrypts
extends BaseCrypt {
    public static byte[] token(String info) {
        String user;
        String ver;
        String t;
        String[] temp;
        String token = StringUtil.replace(StringUtil.trim(info), "\"", "");
        if (U.E.isNotEmpty(token) && token.length() > CommonParams.TOKEN_LENGHT && U.E.isNotEmpty(temp = StringUtil.separate(t = token.toLowerCase(), t.length() / CommonParams.TOKEN_LENGHT)) && temp.length == 2 && (ver = temp[0]).equals(Digest.absolute(user = temp[1], CommonParams.TOKEN_LENGHT))) {
            return Decrypts.rc4(Hex.decode(user));
        }
        return ArrayConstants.BYTES_EMPTY;
    }

    public static String decryptString(String text) {
        return StringUtil.toString(Decrypts.decrypt(text));
    }

    public static byte[] decrypt(String text) {
        return Decrypts.decrypt(Hex.decode(text));
    }

    public static byte[] decrypt(byte[] b) {
        return Decrypts.decrypt(b, CommonParams.ENCRYPT_KEY);
    }

    public static byte[] decrypt(byte[] b, String keys) {
        switch (CommonParams.ENCRYPT_ALGO) {
            case "AES": {
                return Decrypts.aes(b, keys);
            }
            case "DES": {
                return Decrypts.des(b, keys);
            }
            case "RC4": {
                return Decrypts.rc4(b, keys);
            }
        }
        return Decrypts.aes(b, keys);
    }

    public static byte[] des(byte[] b) {
        return Decrypts.des(b, CommonParams.ENCRYPT_KEY);
    }

    public static byte[] des(byte[] b, String keys) {
        return Decrypts.decrypt(b, keys, 8, "DES");
    }

    public static byte[] aes(byte[] b) {
        return Decrypts.aes(b, CommonParams.ENCRYPT_KEY);
    }

    public static byte[] aes(byte[] b, String keys) {
        return Decrypts.decrypt(b, keys, 16, "AES");
    }

    public static byte[] rc4(byte[] b) {
        return Decrypts.rc4(b, CommonParams.ENCRYPT_KEY);
    }

    public static byte[] rc4(byte[] b, String keys) {
        return Decrypts.decrypt(b, keys, 16, "RC4");
    }

    private static byte[] decrypt(byte[] b, String keys, int len, String algorithm) {
        return Decrypts.doFinal(b, keys, len, algorithm, 2);
    }
}

