/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.http;

import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.io.IOUtil;
import com.weicoder.common.lang.Conversion;
import com.weicoder.common.lang.Maps;
import com.weicoder.common.log.Logs;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.EmptyUtil;
import com.weicoder.common.util.StringUtil;
import com.weicoder.common.zip.ZipEngine;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class HttpEngine {
    public static byte[] download(String url) {
        return HttpEngine.download(url, Maps.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] download(String url, Map<String, Object> header) {
        HttpURLConnection conn = null;
        try {
            conn = HttpEngine.getConnection(url);
            if (EmptyUtil.isNotEmpty(header)) {
                for (Map.Entry<String, Object> h : header.entrySet()) {
                    conn.setRequestProperty(h.getKey(), Conversion.toString(h.getValue()));
                }
            }
            conn.setRequestMethod("GET");
            conn.connect();
            Object object = ZipEngine.GZIP.extract(IOUtil.read(conn.getInputStream()));
            return object;
        }
        catch (IOException e) {
            Logs.error(e, "HttpEngine get url={}", url);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return ArrayConstants.BYTES_EMPTY;
    }

    public static String get(String url) {
        String res = StringUtil.toString(HttpEngine.download(url));
        Logs.debug("HttpEngine get url={} res={}", url, res);
        return res;
    }

    public static String get(String url, Map<String, Object> header) {
        String res = StringUtil.toString(HttpEngine.download(url, header));
        Logs.debug("HttpEngine get url={} header={} res={}", url, header, res);
        return res;
    }

    public static String post(String url, Map<String, Object> data) {
        return HttpEngine.post(url, data, Maps.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, Map<String, Object> data, Map<String, Object> header) {
        HttpURLConnection conn = null;
        try {
            conn = HttpEngine.getConnection(url);
            if (EmptyUtil.isNotEmpty(header)) {
                for (Map.Entry<String, Object> h : header.entrySet()) {
                    conn.setRequestProperty(h.getKey(), Conversion.toString(h.getValue()));
                }
            }
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.connect();
            if (EmptyUtil.isNotEmpty(data)) {
                StringBuilder sb = new StringBuilder();
                data.entrySet().forEach(e -> sb.append((String)e.getKey()).append("=").append(e.getValue()).append("&"));
                IOUtil.write(conn.getOutputStream(), sb.substring(0, sb.length() - 1));
            }
            String res = StringUtil.toString(ZipEngine.GZIP.extract(IOUtil.read(conn.getInputStream())));
            Logs.debug("HttpEngine post url={} data={} header={} res={}", url, data, header, res);
            String string = res;
            return string;
        }
        catch (IOException e2) {
            Logs.error(e2, "HttpEngine post url={} data={} header={}", url, data, header);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return "";
    }

    private static HttpURLConnection getConnection(String url) {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; nl; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13");
            conn.setRequestProperty("Accept", "text/xml,text/javascript,application/json,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5");
            conn.setRequestProperty("Accept-Language", "zh-cn,zh;q=0.5");
            conn.setRequestProperty("Accept-Encoding", "gzip,deflate");
            conn.setRequestProperty("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7");
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setConnectTimeout(CommonParams.HTTP_CONNECT_TIMEOUT);
            conn.setReadTimeout(CommonParams.HTTP_READ_TIMEOUT);
        }
        catch (Exception e) {
            Logs.error(e, "HttpEngine getConnection url={}", url);
        }
        return conn;
    }
}

