/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.io;

import com.weicoder.common.io.IO;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class BaseIO
implements IO {
    @Override
    public String readString(InputStream in) {
        return this.readString(in, CommonParams.ENCODING);
    }

    @Override
    public String readString(InputStream in, String charsetName) {
        return this.readString(in, charsetName, true);
    }

    @Override
    public byte[] read(InputStream in) {
        return this.read(in, true);
    }

    @Override
    public boolean write(OutputStream out, String text) {
        return this.write(out, StringUtil.toBytes(text));
    }

    @Override
    public boolean write(OutputStream out, String text, String charsetName) {
        return this.write(out, text, charsetName, true);
    }

    @Override
    public boolean write(OutputStream out, InputStream in) {
        return this.write(out, in, true);
    }

    @Override
    public String readString(InputStream in, String charsetName, boolean isClose) {
        return StringUtil.toString(this.read(in, isClose), charsetName);
    }

    @Override
    public boolean write(OutputStream out, String text, String charsetName, boolean isClose) {
        return this.write(out, StringUtil.toBytes(text, charsetName), isClose);
    }

    @Override
    public boolean write(OutputStream out, byte[] b) {
        return this.write(out, b, true);
    }

    @Override
    public boolean write(OutputStream out, byte[] b, boolean isClose) {
        return this.write(out, new ByteArrayInputStream(b), isClose);
    }
}

