/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.lang;

import com.weicoder.common.U;
import com.weicoder.common.util.MathUtil;
import java.math.BigDecimal;
import java.util.Arrays;

public class Conversion {
    public static Object to(Object obj, Class<?> c) {
        if (c == null) {
            return obj;
        }
        if (String.class == c) {
            return Conversion.toString(obj);
        }
        if (Integer.class == c || Integer.TYPE == c) {
            return Conversion.toInt(obj);
        }
        if (Long.class == c || Long.TYPE == c) {
            return Conversion.toLong(obj);
        }
        if (Float.class == c || Float.TYPE == c) {
            return Float.valueOf(Conversion.toFloat(obj));
        }
        if (Double.class == c || Double.TYPE == c) {
            return Conversion.toDouble(obj);
        }
        if (Short.class == c || Short.TYPE == c) {
            return Conversion.toShort(obj);
        }
        if (Byte.class == c || Byte.TYPE == c) {
            return Conversion.toByte(obj);
        }
        if (BigDecimal.class == c) {
            return Conversion.toBigDecimal(obj);
        }
        if (Boolean.class == c || Boolean.TYPE == c) {
            return Conversion.toBoolean(obj);
        }
        return obj;
    }

    public static String toString(Object obj) {
        return Conversion.toString(obj, "");
    }

    public static String toString(Object obj, String defaultValue) {
        return U.E.isEmpty(obj) ? defaultValue : (obj instanceof Object[] ? Arrays.toString((Object[])obj) : obj.toString());
    }

    public static int toInt(Object obj) {
        return Conversion.toInt(obj, 0);
    }

    public static int toInt(Object obj, int defaultValue) {
        try {
            if (U.E.isEmpty(obj)) {
                return defaultValue;
            }
            if (obj.getClass().isArray()) {
                return Conversion.toInt(((Object[])obj)[0], defaultValue);
            }
            if (obj instanceof Number) {
                return ((Number)obj).intValue();
            }
            if (obj instanceof Boolean) {
                return (Boolean)obj != false ? 1 : 0;
            }
            if (obj instanceof Character) {
                return ((Character)obj).charValue();
            }
            return MathUtil.add(obj).intValue();
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static long toLong(Object obj) {
        return Conversion.toLong(obj, 0L);
    }

    public static long toLong(Object obj, long defaultValue) {
        try {
            if (U.E.isEmpty(obj)) {
                return defaultValue;
            }
            if (obj instanceof Number) {
                return ((Number)obj).longValue();
            }
            if (obj instanceof Boolean) {
                return (Boolean)obj != false ? 1L : 0L;
            }
            if (obj instanceof Character) {
                return ((Character)obj).charValue();
            }
            return MathUtil.add(obj).longValue();
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static float toFloat(Object obj) {
        return Conversion.toFloat(obj, 0.0f);
    }

    public static float toFloat(Object obj, float defaultValue) {
        try {
            if (U.E.isEmpty(obj)) {
                return defaultValue;
            }
            if (obj instanceof Number) {
                return ((Number)obj).floatValue();
            }
            if (obj instanceof String) {
                return Float.parseFloat(obj.toString());
            }
            if (obj instanceof Boolean) {
                return (Boolean)obj != false ? 1.0f : 0.0f;
            }
            if (obj instanceof Character) {
                return ((Character)obj).charValue();
            }
            return Float.parseFloat(Conversion.toString(obj));
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static double toDouble(Object obj) {
        return Conversion.toDouble(obj, 0.0);
    }

    public static double toDouble(Object obj, double defaultValue) {
        try {
            if (U.E.isEmpty(obj)) {
                return defaultValue;
            }
            if (obj instanceof Number) {
                return ((Number)obj).doubleValue();
            }
            if (obj instanceof String) {
                return Double.parseDouble(obj.toString());
            }
            if (obj instanceof Boolean) {
                return (Boolean)obj != false ? 1.0 : 0.0;
            }
            if (obj instanceof Character) {
                return ((Character)obj).charValue();
            }
            return Double.parseDouble(Conversion.toString(obj));
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static short toShort(Object obj) {
        return Conversion.toShort(obj, (short)0);
    }

    public static short toShort(Object obj, short defaultValue) {
        try {
            if (U.E.isEmpty(obj)) {
                return defaultValue;
            }
            if (obj instanceof Number) {
                return ((Number)obj).shortValue();
            }
            if (obj instanceof String) {
                return Short.parseShort(obj.toString());
            }
            if (obj instanceof Boolean) {
                return (short)((Boolean)obj != false ? 1 : 0);
            }
            if (obj instanceof Character) {
                return (short)((Character)obj).charValue();
            }
            return Short.parseShort(Conversion.toString(obj));
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static byte toByte(Object obj) {
        return Conversion.toByte(obj, (byte)0);
    }

    public static byte toByte(Object obj, byte defaultValue) {
        try {
            if (U.E.isEmpty(obj)) {
                return defaultValue;
            }
            if (obj instanceof Number) {
                return ((Number)obj).byteValue();
            }
            if (obj instanceof String) {
                return Byte.parseByte(obj.toString());
            }
            if (obj instanceof Boolean) {
                return (byte)((Boolean)obj != false ? 1 : 0);
            }
            if (obj instanceof Character) {
                return (byte)((Character)obj).charValue();
            }
            return Byte.parseByte(Conversion.toString(obj));
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static BigDecimal toBigDecimal(Object obj) {
        return Conversion.toBigDecimal(obj, BigDecimal.ZERO);
    }

    public static BigDecimal toBigDecimal(Object obj, BigDecimal defaultValue) {
        try {
            if (U.E.isEmpty(obj)) {
                return defaultValue;
            }
            if (obj instanceof BigDecimal) {
                return (BigDecimal)obj;
            }
            if (obj instanceof Long || obj instanceof Integer) {
                return BigDecimal.valueOf(Conversion.toLong(obj));
            }
            if (obj instanceof Double || obj instanceof Float) {
                return BigDecimal.valueOf(Conversion.toDouble(obj));
            }
            if (obj instanceof String) {
                return new BigDecimal(obj.toString());
            }
            if (obj instanceof Boolean) {
                return (Boolean)obj != false ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            if (obj instanceof Character) {
                return new BigDecimal(((Character)obj).charValue());
            }
            return new BigDecimal(Conversion.toString(obj));
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static boolean toBoolean(Object obj) {
        return Conversion.toBoolean(obj, false);
    }

    public static boolean toBoolean(Object obj, boolean defaultValue) {
        try {
            if (U.E.isEmpty(obj)) {
                return defaultValue;
            }
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            if (obj instanceof String) {
                String is = obj.toString();
                return "true".equalsIgnoreCase(is) || "yes".equalsIgnoreCase(is) || "ok".equalsIgnoreCase(is);
            }
            if (obj instanceof Number) {
                return ((Number)obj).intValue() > 0;
            }
            return Boolean.parseBoolean(Conversion.toString(obj));
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static String stringToNull(String str) {
        return Conversion.stringToNull(str, "");
    }

    public static String stringToNull(String str, String eq) {
        return Conversion.toString(eq).equals(str) ? null : str;
    }
}

