/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.util;

import com.weicoder.common.io.FileUtil;
import com.weicoder.common.log.Logs;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ImageUtil {
    private static final String FORMAT = "JPEG";
    private static final Font FONT = new Font("\u5b8b\u4f53", 0, 15);
    private static final Color COLOR = Color.WHITE;

    public static boolean isImage(File img) {
        try {
            return ImageUtil.isImage(ImageIO.read(img));
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isImage(Image img) {
        return img != null && img.getWidth(null) > -1 && img.getHeight(null) > -1;
    }

    public static void compress(File input, OutputStream out, int rate, int scale) {
        ImageUtil.compress(input, out, rate, -1, scale);
    }

    public static void compress(File input, OutputStream out, int width, int height, int scale) {
        try {
            BufferedImage img = ImageIO.read(input);
            if (ImageUtil.isImage(img)) {
                if (height == -1) {
                    height = ((Image)img).getHeight(null) * width / 100;
                    width = ((Image)img).getWidth(null) * width / 100;
                }
                BufferedImage tag = new BufferedImage(width, height, 1);
                tag.getGraphics().drawImage(img.getScaledInstance(width, height, scale), 0, 0, null);
                ImageUtil.write(tag, out);
            }
        }
        catch (Exception e) {
            Logs.warn(e);
        }
    }

    public static void captureScreen(OutputStream out) {
        try {
            ImageIO.write((RenderedImage)new Robot().createScreenCapture(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize())), FORMAT, out);
        }
        catch (Exception e) {
            Logs.warn(e);
        }
    }

    public static void writeString(String text, File file) {
        ImageUtil.writeString(text, file, -1, -1);
    }

    public static void writeString(String text, File file, int x, int y) {
        try {
            ImageUtil.writeString(text, ImageIO.read(file), FileUtil.getOutputStream(file), x, y);
        }
        catch (Exception e) {
            Logs.warn(e);
        }
    }

    public static void writeString(String text, BufferedImage image, OutputStream out) {
        ImageUtil.writeString(text, image, out, -1, -1);
    }

    public static void writeString(String text, BufferedImage image, OutputStream out, int x, int y) {
        Graphics g = image.getGraphics();
        g.setFont(FONT);
        g.setColor(COLOR);
        if (x == -1) {
            x = (image.getWidth(null) - ImageUtil.getStringWidth(text, g.getFontMetrics())) / 2;
        }
        if (y == -1) {
            y = (image.getHeight(null) + FONT.getSize()) / 2;
        }
        g.drawString(text, x, y);
        g.dispose();
        ImageUtil.write(image, out);
    }

    public static void write(BufferedImage image, OutputStream out) {
        try {
            ImageIO.write((RenderedImage)image, FORMAT, out);
        }
        catch (IOException e) {
            Logs.warn(e);
        }
    }

    public static void writeImage(File draw, File image) {
        ImageUtil.writeImage(draw, image, -1, -1);
    }

    public static void writeImage(File draw, File image, int x, int y) {
        try {
            ImageUtil.writeImage(ImageIO.read(draw), ImageIO.read(image), FileUtil.getOutputStream(image), x, y);
        }
        catch (Exception e) {
            Logs.warn(e);
        }
    }

    public static void writeImage(Image draw, BufferedImage image, OutputStream out) {
        ImageUtil.writeImage(draw, image, out, -1, -1);
    }

    public static void writeImage(Image draw, BufferedImage image, OutputStream out, int x, int y) {
        Graphics g = image.getGraphics();
        g.setFont(FONT);
        g.setColor(COLOR);
        if (x == -1) {
            x = (image.getWidth(null) - draw.getWidth(null)) / 2;
        }
        if (y == -1) {
            y = (image.getHeight(null) - draw.getHeight(null)) / 2;
        }
        g.drawImage(draw, x, y, null);
        g.dispose();
        ImageUtil.write(image, out);
    }

    private static int getStringWidth(String text, FontMetrics fm) {
        int intReturn = 0;
        char[] chars = text.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            intReturn += fm.charWidth(chars[i]);
        }
        return intReturn;
    }
}

