/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.util;

import com.weicoder.common.W;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Random;

public class MathUtil {
    private static final RoundingMode ROUND = RoundingMode.HALF_UP;
    private static final Random RANDOM = new Random();

    public static Random random() {
        return RANDOM;
    }

    public static int nextInt() {
        return RANDOM.nextInt();
    }

    public static int nextInt(int n) {
        return RANDOM.nextInt(n);
    }

    public static int nextInt(int m, int n) {
        return m > n ? 0 : MathUtil.nextInt(n - m) + m;
    }

    public static double nextDouble() {
        return RANDOM.nextDouble();
    }

    public static float nextFloat() {
        return RANDOM.nextFloat();
    }

    public static long nextLong() {
        return RANDOM.nextLong();
    }

    public static String random(int len) {
        StringBuilder veryfy = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int n = MathUtil.nextInt(48, 123);
            if (n > 91 && n < 97 || n > 57 && n < 65) {
                n += MathUtil.nextInt(7, 16);
            }
            veryfy.append((char)n);
        }
        return veryfy.toString();
    }

    public static BigDecimal add(Object ... values) {
        BigDecimal result = BigDecimal.ZERO;
        for (int i = 0; i < values.length; ++i) {
            result = result.add(W.C.toBigDecimal(values[i]));
        }
        return result;
    }

    public static BigDecimal subtract(Object v1, Object v2) {
        return MathUtil.scale(v1).subtract(W.C.toBigDecimal(v2));
    }

    public static BigDecimal subtract(Object v1, Object v2, int scale) {
        return MathUtil.subtract(v1, v2).setScale(scale, ROUND);
    }

    public static BigDecimal multiply(Object ... values) {
        BigDecimal result = BigDecimal.ONE;
        for (int i = 0; i < values.length; ++i) {
            result = result.multiply(W.C.toBigDecimal(values[i]));
        }
        return result;
    }

    public static BigDecimal divide(Object v1, Object v2) {
        return MathUtil.divide(v1, v2, 2);
    }

    public static BigDecimal divide(Object v1, Object v2, int scale) {
        return MathUtil.scale(v1, scale).divide(MathUtil.scale(v2, scale), scale, ROUND);
    }

    public static BigDecimal scale(Object v) {
        return MathUtil.scale(v, 2);
    }

    public static BigDecimal scale(Object v, int scale) {
        return W.C.toBigDecimal(v).setScale(scale, ROUND);
    }

    public static String take(String v) {
        return v.indexOf(",") == -1 ? v : v.replaceAll(",", "");
    }

    public static String toString(Object val) {
        return W.C.toBigDecimal(val).toPlainString();
    }
}

