/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.util;

import com.weicoder.common.U;
import com.weicoder.common.log.Logs;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.ImageUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.OutputStream;

public final class VerifyCodeUtil {
    private static final Font CODE_FONT = new Font("Times New Roman", 1, 18);

    public static String make(OutputStream out) {
        return VerifyCodeUtil.make(out, CommonParams.VERIFY_LENGTH);
    }

    public static String make(OutputStream out, int len) {
        String rand = VerifyCodeUtil.randString();
        try {
            int i;
            int height = 20;
            int width = 20 * len;
            int charWidth = (width - height) / len;
            int charHeight = 16;
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics g = image.getGraphics();
            g.setColor(VerifyCodeUtil.getRandColor(10, 50));
            g.drawRect(0, 0, width - 1, height - 1);
            g.setColor(VerifyCodeUtil.getRandColor(200, 240));
            g.fillRect(0, 0, width, height);
            g.setFont(CODE_FONT);
            g.setColor(VerifyCodeUtil.getRandColor(160, 200));
            for (i = 0; i < 155; ++i) {
                int x = U.M.nextInt(width);
                int y = U.M.nextInt(height);
                int xl = U.M.nextInt(12);
                int yl = U.M.nextInt(12);
                g.drawLine(x, y, x + xl, y + yl);
            }
            for (i = 0; i < len; ++i) {
                g.setColor(new Color(20 + U.M.nextInt(110), 20 + U.M.nextInt(110), 20 + U.M.nextInt(110)));
                g.drawString(rand.substring(i, i + 1), charWidth * i + 10, charHeight);
            }
            g.dispose();
            ImageUtil.write(image, out);
        }
        catch (Exception e) {
            Logs.error(e);
        }
        return rand;
    }

    private static String randString() {
        char[] buf = new char[CommonParams.VERIFY_LENGTH];
        char[] code = CommonParams.VERIFY_CODE;
        for (int i = 0; i < CommonParams.VERIFY_LENGTH; ++i) {
            buf[i] = code[U.M.nextInt(CommonParams.VERIFY_LENGTH)];
        }
        return String.valueOf(buf);
    }

    private static Color getRandColor(int fc, int bc) {
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + U.M.nextInt(bc - fc);
        int g = fc + U.M.nextInt(bc - fc);
        int b = fc + U.M.nextInt(bc - fc);
        return new Color(r, g, b);
    }

    private VerifyCodeUtil() {
    }
}

