/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.zip.impl;

import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.io.IOUtil;
import com.weicoder.common.zip.base.BaseZip;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class ZipImpl
extends BaseZip {
    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] compress0(byte[] b) throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ZipOutputStream zip = new ZipOutputStream(baos);){
                zip.putNextEntry(new ZipEntry(""));
                IOUtil.write((OutputStream)zip, b, false);
                zip.finish();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (Exception e) {
            return ArrayConstants.BYTES_EMPTY;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] extract0(byte[] b) throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ZipInputStream zin = new ZipInputStream(new ByteArrayInputStream(b));){
                while (zin.getNextEntry() != null) {
                    baos.write(IOUtil.read(zin, false));
                    baos.flush();
                }
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (Exception e) {
            return ArrayConstants.BYTES_EMPTY;
        }
    }
}

