package com.weicoder.common;

import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.constants.DateConstants;
import com.weicoder.common.constants.EncodingConstants;
import com.weicoder.common.constants.EncryptConstants;
import com.weicoder.common.constants.FileConstants;
import com.weicoder.common.constants.HttpConstants; 
import com.weicoder.common.constants.RegexConstants;
import com.weicoder.common.constants.StringConstants;
import com.weicoder.common.constants.SystemConstants;
import com.weicoder.common.constants.UnitConstants;

/**
 * 保存常量类
 * 
 * @author wudi
 */
public final class C {
	/**
	 * @see    ArrayConstants 数组常量类引用
	 * @author wudi
	 */
	public static class A extends ArrayConstants {
	}

	/**
	 * @see    DateConstants 日期常量类引用
	 * @author wudi
	 */
	public static class D extends DateConstants {
	}

	/**
	 * @see    EncryptConstants 加密常量类引用
	 * @author wudi
	 */
	public static class E extends EncryptConstants {
	}

	/**
	 * @see    EncodingConstants 编码加解密常量类引用
	 * @author wudi
	 */
	public static class En extends EncodingConstants {
	}

	/**
	 * @see    FileConstants 文件常量类引用
	 * @author wudi
	 */
	public static class F extends FileConstants {
	}

	/**
	 * @see    HttpConstants http常量类引用
	 * @author wudi
	 */
	public static class H extends HttpConstants {
	}
  
	/**
	 * @see    RegexConstants 正则常量类引用
	 * @author wudi
	 */
	public static class R extends RegexConstants {
	}

	/**
	 * @see    StringConstants 字符常量类引用
	 * @author wudi
	 */
	public static class S extends StringConstants {
	}

	/**
	 * @see    SystemConstants 系统常量类引用
	 * @author wudi
	 */
	public static class O extends SystemConstants {
	}

	/**
	 * @see    UnitConstants 占位符常量类引用
	 * @author wudi
	 */
	public static class U extends UnitConstants {
	}

	private C() {
	}
}
