/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.bean;

import com.weicoder.common.bean.PageResult;
import com.weicoder.common.params.CommonParams;
import java.util.List;
import java.util.Objects;

public final class Pages {
    private int total;
    private int page;
    private int size = CommonParams.PAGE_SIZE;

    public PageResult result(List<?> list) {
        return new PageResult(list, this);
    }

    public int getTotalPage() {
        return this.total < this.size ? 0 : (this.total % this.size == 0 ? this.total / this.size : this.total / this.size + 1);
    }

    public int getStartPage() {
        return this.page - 5 > 0 ? this.page - 5 : 0;
    }

    public int getEndPage() {
        int current = this.getPage();
        int total = this.getTotalPage();
        return current == 1 || current < 6 ? (total > 10 ? 10 : total) : (current + 5 <= total ? current + 5 : total);
    }

    public int getEnd() {
        return (this.getPage() + 1) * this.getSize();
    }

    public int getStart() {
        return this.getPage() * this.getSize();
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int hashCode() {
        return Objects.hash(this.page, this.size, this.total);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pages other = (Pages)obj;
        return this.page == other.page && this.size == other.size && this.total == other.total;
    }

    public String toString() {
        return "Pages [total=" + this.total + ", page=" + this.page + ", size=" + this.size + "]";
    }
}

