/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.codec;

import com.weicoder.common.U;
import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.lang.Bytes;

public final class Hex {
    private static final char[] DIGITS = "0123456789abcdef".toCharArray();

    public static String encode(Object data) {
        return Hex.encode(Bytes.toBytes(data));
    }

    public static String encode(byte[] data) {
        if (U.E.isEmpty(data)) {
            return "";
        }
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }
        return new String(out);
    }

    public static byte[] decode(String str) {
        if (U.E.isEmpty(str)) {
            return ArrayConstants.BYTES_EMPTY;
        }
        char[] data = str.toCharArray();
        int len = data.length;
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Character.digit(data[j++], 16) << 4;
            out[i] = (byte)((f |= Character.digit(data[j++], 16)) & 0xFF);
            ++i;
        }
        return out;
    }

    private Hex() {
    }
}

