/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.crypto;

import com.weicoder.common.U;
import com.weicoder.common.codec.Hex;
import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.StringUtil;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class HMac {
    public static String sha1(String text) {
        return Hex.encode(HMac.sha1(StringUtil.toBytes(text)));
    }

    public static byte[] sha1(byte[] b) {
        return HMac.sha1(b, CommonParams.ENCRYPT_KEY);
    }

    public static byte[] sha1(byte[] b, String key) {
        return HMac.doFinal(b, "HmacSHA1", key);
    }

    public static String sha256(String text) {
        return Hex.encode(HMac.sha256(StringUtil.toBytes(text)));
    }

    public static byte[] sha256(byte[] b) {
        return HMac.doFinal(b, "HmacSHA256", CommonParams.ENCRYPT_KEY);
    }

    public static String sha384(String text) {
        return Hex.encode(HMac.sha384(StringUtil.toBytes(text)));
    }

    public static byte[] sha384(byte[] b) {
        return HMac.doFinal(b, "HmacSHA384", CommonParams.ENCRYPT_KEY);
    }

    public static String sha512(String text) {
        return Hex.encode(HMac.sha512(StringUtil.toBytes(text)));
    }

    public static byte[] sha512(byte[] b) {
        return HMac.doFinal(b, "HmacSHA512", CommonParams.ENCRYPT_KEY);
    }

    private static byte[] doFinal(byte[] b, String algorithm, String keys) {
        try {
            if (U.E.isEmptys(b, algorithm, keys)) {
                return ArrayConstants.BYTES_EMPTY;
            }
            return HMac.getMac(algorithm, keys).doFinal(b);
        }
        catch (Exception e) {
            return ArrayConstants.BYTES_EMPTY;
        }
    }

    private static Mac getMac(String algorithm, String keys) {
        Mac mac = null;
        try {
            mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(StringUtil.toBytes(keys), algorithm));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mac;
    }

    private HMac() {
    }
}

