/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.io;

import com.weicoder.common.W;
import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.io.IOUtil;
import com.weicoder.common.log.Logs;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public class FileUtil {
    private static final boolean IO = "io".equalsIgnoreCase(CommonParams.IO_MODE);
    private static final boolean AIO = "aio".equalsIgnoreCase(CommonParams.IO_MODE);

    public static boolean mkdirs(String path) {
        return FileUtil.newFile(StringUtil.subStringLastEnd(path, File.separator)).mkdirs();
    }

    public static boolean exists(String name) {
        return FileUtil.newFile(name).exists();
    }

    public static boolean delete(String fileName) {
        return FileUtil.delete(FileUtil.newFile(fileName));
    }

    public static boolean delete(File file) {
        return file.delete();
    }

    public static boolean copy(String src, String target) {
        return FileUtil.write(target, FileUtil.getInputStream(src));
    }

    public static boolean copy(File src, File target) {
        return IOUtil.write((OutputStream)FileUtil.getOutputStream(target), FileUtil.getInputStream(src));
    }

    public static String readString(String fileName) {
        return FileUtil.readString(fileName, CommonParams.ENCODING);
    }

    public static String readString(String fileName, String charsetName) {
        return IOUtil.readString(FileUtil.getInputStream(fileName), charsetName);
    }

    public static byte[] read(String fileName, long pos) {
        if (IO) {
            byte[] byArray;
            block28: {
                RandomAccessFile file = FileUtil.getRandomAccessFile(fileName, "rw", pos);
                try {
                    byte[] b = new byte[W.C.toInt(file.length() - pos)];
                    file.read(b);
                    byArray = b;
                    if (file == null) break block28;
                }
                catch (Throwable b) {
                    try {
                        if (file != null) {
                            try {
                                file.close();
                            }
                            catch (Throwable throwable) {
                                b.addSuppressed(throwable);
                            }
                        }
                        throw b;
                    }
                    catch (IOException e) {
                        Logs.error(e);
                    }
                }
                file.close();
            }
            return byArray;
        } else if (AIO) {
            byte[] byArray;
            block29: {
                AsynchronousFileChannel channel = AsynchronousFileChannel.open(Paths.get(fileName, new String[0]), new OpenOption[0]);
                try {
                    ByteBuffer buf = ByteBuffer.allocate(W.C.toInt(channel.size() - pos));
                    channel.read(buf, pos);
                    byArray = buf.array();
                    if (channel == null) break block29;
                }
                catch (Throwable buf) {
                    try {
                        if (channel != null) {
                            try {
                                channel.close();
                            }
                            catch (Throwable throwable) {
                                buf.addSuppressed(throwable);
                            }
                        }
                        throw buf;
                    }
                    catch (Exception e) {
                        Logs.error(e);
                    }
                }
                channel.close();
            }
            return byArray;
        } else {
            byte[] byArray;
            block30: {
                FileChannel channel = FileChannel.open(Paths.get(fileName, new String[0]), new OpenOption[0]);
                try {
                    ByteBuffer buf = ByteBuffer.allocate(W.C.toInt(channel.size() - pos));
                    channel.read(buf, pos);
                    byArray = buf.array();
                    if (channel == null) break block30;
                }
                catch (Throwable throwable) {
                    try {
                        if (channel != null) {
                            try {
                                channel.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        Logs.error(e);
                    }
                }
                channel.close();
            }
            return byArray;
        }
        return ArrayConstants.BYTES_EMPTY;
    }

    public static byte[] read(String fileName) {
        return IOUtil.read(FileUtil.getInputStream(fileName));
    }

    public static byte[] read(File file) {
        return IOUtil.read(FileUtil.getInputStream(file));
    }

    public static boolean write(String fileName, InputStream is) {
        return IOUtil.write((OutputStream)FileUtil.getOutputStream(fileName), is);
    }

    public static boolean write(String fileName, File file) {
        return IOUtil.write((OutputStream)FileUtil.getOutputStream(fileName), FileUtil.getInputStream(file));
    }

    public static boolean write(String fileName, byte[] b) {
        return FileUtil.write(fileName, b, false);
    }

    public static boolean write(String fileName, byte[] b, boolean append) {
        return IOUtil.write((OutputStream)FileUtil.getOutputStream(fileName, append), b);
    }

    public static void write(String fileName, byte[] b, long pos) {
        if (IO) {
            try (RandomAccessFile file = FileUtil.getRandomAccessFile(fileName, "rw", pos);){
                file.write(b);
            }
            catch (IOException e) {
                Logs.error(e);
            }
        } else if (AIO) {
            try (AsynchronousFileChannel channel = AsynchronousFileChannel.open(Paths.get(fileName, new String[0]), new OpenOption[0]);){
                channel.write(ByteBuffer.wrap(b), pos);
            }
            catch (Exception e) {
                Logs.error(e);
            }
        } else {
            try (FileChannel channel = FileChannel.open(Paths.get(fileName, new String[0]), new OpenOption[0]);){
                channel.write(ByteBuffer.wrap(b), pos);
            }
            catch (Exception e) {
                Logs.error(e);
            }
        }
    }

    public static boolean write(String fileName, String text) {
        return FileUtil.write(fileName, text, true);
    }

    public static boolean write(String fileName, String text, boolean append) {
        return FileUtil.write(fileName, text, CommonParams.ENCODING, append);
    }

    public static boolean write(String fileName, String text, String charsetName) {
        return FileUtil.write(fileName, text, charsetName, true);
    }

    public static boolean write(String fileName, String text, String charsetName, boolean append) {
        return IOUtil.write((OutputStream)FileUtil.getOutputStream(fileName, append), text, charsetName);
    }

    public static File newFile(String fileName) {
        return new File(fileName);
    }

    public static File newFile(URI uri) {
        return new File(uri);
    }

    public static RandomAccessFile getRandomAccessFile(String fileName, String mode, long pos) {
        RandomAccessFile file = null;
        try {
            File f = FileUtil.newFile(fileName);
            if (!f.exists()) {
                FileUtil.mkdirs(fileName);
                f.createNewFile();
            }
            file = new RandomAccessFile(f, mode);
            file.seek(pos);
        }
        catch (Exception e) {
            Logs.error(e);
        }
        return file;
    }

    public static FileInputStream in(String fileName) {
        return FileUtil.getInputStream(fileName);
    }

    public static FileInputStream getInputStream(String fileName) {
        return FileUtil.getInputStream(FileUtil.newFile(fileName));
    }

    public static FileOutputStream out(String fileName) {
        return FileUtil.getOutputStream(fileName);
    }

    public static FileOutputStream getOutputStream(String fileName) {
        return FileUtil.getOutputStream(FileUtil.newFile(fileName));
    }

    public static FileOutputStream getOutputStream(String fileName, boolean append) {
        return FileUtil.getOutputStream(FileUtil.newFile(fileName), append);
    }

    public static FileInputStream getInputStream(File file) {
        try {
            return file == null ? null : (file.exists() ? new FileInputStream(file) : null);
        }
        catch (Exception e) {
            Logs.error(e);
            return null;
        }
    }

    public static FileOutputStream getOutputStream(File file) {
        return FileUtil.getOutputStream(file, false);
    }

    public static FileOutputStream getOutputStream(File file, boolean append) {
        try {
            if (!file.exists()) {
                FileUtil.mkdirs(file.getPath());
                file.createNewFile();
            }
            return new FileOutputStream(file, append);
        }
        catch (Exception e) {
            Logs.error(e);
            return null;
        }
    }
}

