/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.io;

import com.weicoder.common.binary.Buffer;
import com.weicoder.common.interfaces.Callback;
import com.weicoder.common.interfaces.CallbackVoid;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;

interface IO {
    default public String readString(InputStream in) {
        return this.readString(in, CommonParams.ENCODING);
    }

    default public String readString(InputStream in, String charsetName) {
        return this.readString(in, charsetName, true);
    }

    default public byte[] read(InputStream in) {
        return this.read(in, true);
    }

    public byte[] read(InputStream var1, boolean var2);

    public long read(InputStream var1, int var2, boolean var3, CallbackVoid<Buffer> var4);

    default public boolean write(OutputStream out, String text) {
        return this.write(out, StringUtil.toBytes(text));
    }

    default public boolean write(OutputStream out, String text, String charsetName) {
        return this.write(out, text, charsetName, true);
    }

    default public boolean write(OutputStream out, byte[] b) {
        return this.write(out, b, true);
    }

    default public boolean write(OutputStream out, byte[] b, boolean isClose) {
        return this.write(out, new ByteArrayInputStream(b), isClose);
    }

    default public boolean write(OutputStream out, InputStream in) {
        return this.write(out, in, true);
    }

    public boolean write(OutputStream var1, InputStream var2, boolean var3);

    public long write(OutputStream var1, InputStream var2, int var3, boolean var4, Callback<Buffer, Buffer> var5);

    default public String readString(InputStream in, String charsetName, boolean isClose) {
        return StringUtil.toString(this.read(in, isClose), charsetName);
    }

    default public boolean write(OutputStream out, String text, String charsetName, boolean isClose) {
        return this.write(out, StringUtil.toBytes(text, charsetName), isClose);
    }
}

