/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.io;

import com.weicoder.common.binary.Buffer;
import com.weicoder.common.interfaces.Callback;
import com.weicoder.common.interfaces.CallbackVoid;
import com.weicoder.common.io.IO;
import com.weicoder.common.log.Logs;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.CloseUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class OIO
implements IO {
    @Override
    public byte[] read(InputStream in, boolean isClose) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(CommonParams.IO_BUFFERSIZE * 10);
        this.write((OutputStream)out, in, isClose);
        return out.toByteArray();
    }

    @Override
    public boolean write(OutputStream out, InputStream in, boolean isClose) {
        return this.write(out, in, CommonParams.IO_BUFFERSIZE, isClose, r -> r) > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long write(OutputStream out, InputStream in, int buff, boolean isClose, Callback<Buffer, Buffer> call) {
        if (out == null || in == null) {
            return -1L;
        }
        long sum = 0L;
        try {
            byte[] buffer = new byte[buff];
            int num = 0;
            while ((num = in.read(buffer)) > 0) {
                Buffer buf = call.callback(Buffer.wrap(buffer));
                out.write(buf.array(), 0, buf.length());
                out.flush();
                sum += (long)num;
                buffer = new byte[buff];
            }
            if (!isClose) return sum;
        }
        catch (IOException e) {
            try {
                Logs.error(e);
                if (!isClose) return sum;
            }
            catch (Throwable throwable) {
                if (!isClose) throw throwable;
                CloseUtil.close(out, in);
                throw throwable;
            }
            CloseUtil.close(out, in);
            return sum;
        }
        CloseUtil.close(out, in);
        return sum;
    }

    @Override
    public long read(InputStream in, int buff, boolean isClose, CallbackVoid<Buffer> call) {
        return this.write(ByteArrayOutputStream.nullOutputStream(), in, buff, isClose, b -> {
            call.callback((Buffer)b);
            return Buffer.empty();
        });
    }
}

