/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.lang;

import com.weicoder.common.U;
import com.weicoder.common.W;
import com.weicoder.common.binary.Binary;
import com.weicoder.common.binary.Buffer;
import com.weicoder.common.binary.ByteArray;
import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.io.ChannelUtil;
import com.weicoder.common.io.FileUtil;
import com.weicoder.common.io.IOUtil;
import com.weicoder.common.lang.Lists;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.BeanUtil;
import com.weicoder.common.util.ClassUtil;
import com.weicoder.common.util.StringUtil;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.List;

public class Bytes {
    private static final boolean IS_HIGH = "high".equals(CommonParams.BYTES);

    public static boolean isType(Class<?> c) {
        if (c == null) {
            return false;
        }
        return byte[].class == c || Byte[].class == c || String.class == c || Integer.class == c || Integer.TYPE == c || Long.class == c || Long.TYPE == c || Float.class == c || Float.TYPE == c || Double.class == c || Double.TYPE == c || Short.class == c || Short.TYPE == c || Byte.class == c || Byte.TYPE == c || Boolean.class == c || Boolean.TYPE == c || c == Buffer.class || c.isAssignableFrom(ByteArray.class);
    }

    public static Object to(byte[] b, Class<?> c) {
        if (c == null || U.E.isEmpty(b)) {
            return b;
        }
        if (byte[].class == c || Byte[].class == c) {
            return b;
        }
        if (String.class == c) {
            return Bytes.toString(b);
        }
        if (Integer.class == c || Integer.TYPE == c) {
            return Bytes.toInt(b);
        }
        if (Long.class == c || Long.TYPE == c) {
            return Bytes.toLong(b);
        }
        if (Float.class == c || Float.TYPE == c) {
            return Float.valueOf(Bytes.toFloat(b));
        }
        if (Double.class == c || Double.TYPE == c) {
            return Bytes.toDouble(b);
        }
        if (Short.class == c || Short.TYPE == c) {
            return Bytes.toShort(b);
        }
        if (Byte.class == c || Byte.TYPE == c) {
            return Bytes.toByte(b);
        }
        if (Boolean.class == c || Boolean.TYPE == c) {
            return Bytes.toBoolean(b);
        }
        if (c == Buffer.class) {
            return new Buffer(b);
        }
        if (c.isAssignableFrom(ByteArray.class)) {
            return Bytes.toBean((ByteArray)ClassUtil.newInstance(c, new Class[0]), b);
        }
        return Bytes.toBinary(b, c);
    }

    public static byte[] toBytes(Object ... objs) {
        return Bytes.toBytes(Boolean.FALSE, objs);
    }

    public static byte[] toBytes(Boolean is, Object ... objs) {
        int len = objs.length;
        byte[][] bs = new byte[len][];
        for (int i = 0; i < len; ++i) {
            bs[i] = Bytes.toBytes((boolean)is, objs[i]);
        }
        return Bytes.add(bs);
    }

    public static byte[] toBytes(boolean b) {
        return new byte[]{(byte)(b ? 1 : 0)};
    }

    public static byte[] toBytes(Object obj) {
        return Bytes.toBytes(false, obj);
    }

    public static byte[] toBytes(boolean is, Object obj) {
        if (obj == null) {
            return ArrayConstants.BYTES_EMPTY;
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        if (obj instanceof Object[]) {
            return Bytes.toBytes((Object[])obj);
        }
        if (obj instanceof Byte) {
            return new byte[]{(Byte)obj};
        }
        if (obj instanceof Integer) {
            return Bytes.toBytes(W.C.toInt(obj));
        }
        if (obj instanceof Long) {
            return Bytes.toBytes(W.C.toLong(obj));
        }
        if (obj instanceof Float) {
            return Bytes.toBytes(W.C.toFloat(obj));
        }
        if (obj instanceof Double) {
            return Bytes.toBytes(W.C.toDouble(obj));
        }
        if (obj instanceof Short) {
            return Bytes.toBytes(W.C.toShort(obj));
        }
        if (obj instanceof Byte) {
            return new byte[]{(Byte)obj};
        }
        if (obj instanceof Boolean) {
            return Bytes.toBytes(W.C.toBoolean(obj));
        }
        if (obj instanceof String) {
            return Bytes.toBytes(W.C.toString(obj), is);
        }
        if (obj instanceof ByteBuffer) {
            return Bytes.toBytes((ByteBuffer)obj);
        }
        if (obj instanceof ByteArray) {
            return Bytes.toBytes((ByteArray)obj);
        }
        if (obj instanceof Binary || obj.getClass().isAssignableFrom(Binary.class)) {
            return Bytes.toBytes((Binary)obj);
        }
        if (obj instanceof File) {
            return FileUtil.read((File)obj);
        }
        if (obj instanceof InputStream) {
            return IOUtil.read((InputStream)obj, false);
        }
        if (obj instanceof ReadableByteChannel) {
            return ChannelUtil.read((ReadableByteChannel)obj, false);
        }
        return Bytes.binary(obj);
    }

    public static byte[] toBytes(Binary binary) {
        return Bytes.binary(binary);
    }

    public static byte[] binary(Object binary) {
        if (U.E.isEmpty(binary)) {
            return ArrayConstants.BYTES_EMPTY;
        }
        List<Object> values = Lists.newList();
        for (Field field : BeanUtil.getFields(binary.getClass())) {
            if (field.isSynthetic()) continue;
            values.add(BeanUtil.getFieldValue(binary, field));
        }
        return Bytes.toBytes(true, (Object)values.toArray());
    }

    public static byte[] toBytes(ByteArray array) {
        return U.E.isEmpty(array) ? ArrayConstants.BYTES_EMPTY : array.array();
    }

    public static byte[] toBytes(ByteBuffer buff) {
        if (buff == null) {
            return ArrayConstants.BYTES_EMPTY;
        }
        if (buff.hasArray()) {
            return buff.array();
        }
        int len = buff.limit();
        if (len > 0) {
            byte[] dst = new byte[len];
            buff.get(dst);
            return dst;
        }
        return ArrayConstants.BYTES_EMPTY;
    }

    public static byte[] toBytes(int i) {
        byte[] b = new byte[4];
        if (IS_HIGH) {
            b[3] = (byte)(i & 0xFF);
            b[2] = (byte)(i >> 8 & 0xFF);
            b[1] = (byte)(i >> 16 & 0xFF);
            b[0] = (byte)(i >> 24 & 0xFF);
        } else {
            b[0] = (byte)(i & 0xFF);
            b[1] = (byte)(i >> 8 & 0xFF);
            b[2] = (byte)(i >> 16 & 0xFF);
            b[3] = (byte)(i >> 24 & 0xFF);
        }
        return b;
    }

    public static int toInt(byte[] b) {
        return Bytes.toInt(b, 0);
    }

    public static byte toByte(byte[] b) {
        return Bytes.toByte(b, 0);
    }

    public static byte toByte(byte[] b, int offset) {
        return Bytes.copy(b, offset, offset + 1)[0];
    }

    public static boolean toBoolean(byte[] b) {
        return Bytes.toBoolean(b, 0);
    }

    public static boolean toBoolean(byte[] b, int offset) {
        return b[offset] == 1;
    }

    public static int toInt(byte[] b, int offset) {
        int i = 0;
        if (IS_HIGH) {
            i = b[offset + 0] & 0xFF;
            i = i << 8 | b[offset + 1] & 0xFF;
            i = i << 8 | b[offset + 2] & 0xFF;
            i = i << 8 | b[offset + 3] & 0xFF;
        } else {
            i = b[offset + 3] & 0xFF;
            i = i << 8 | b[offset + 2] & 0xFF;
            i = i << 8 | b[offset + 1] & 0xFF;
            i = i << 8 | b[offset + 0] & 0xFF;
        }
        return i;
    }

    public static byte[] toBytes(short s) {
        byte[] b = new byte[2];
        if (IS_HIGH) {
            b[1] = (byte)(s & 0xFF);
            b[0] = (byte)(s >> 8 & 0xFF);
        } else {
            b[0] = (byte)(s & 0xFF);
            b[1] = (byte)(s >> 8 & 0xFF);
        }
        return b;
    }

    public static short toShort(byte[] b) {
        return Bytes.toShort(b, 0);
    }

    public static short toShort(byte[] b, int offset) {
        short s = 0;
        if (IS_HIGH) {
            s = (short)(b[offset + 0] & 0xFF);
            s = (short)(s << 8 | b[offset + 1] & 0xFF);
        } else {
            s = (short)(b[offset + 1] & 0xFF);
            s = (short)(s << 8 | b[offset + 0] & 0xFF);
        }
        return s;
    }

    public static byte[] toBytes(char c) {
        return Bytes.toBytes((short)c);
    }

    public static char toChar(byte[] b) {
        return Bytes.toChar(b, 0);
    }

    public static char toChar(byte[] b, int offset) {
        return (char)Bytes.toShort(b, offset);
    }

    public static byte[] toBytes(float f) {
        return Bytes.toBytes(Float.floatToIntBits(f));
    }

    public static float toFloat(byte[] b) {
        return Bytes.toFloat(b, 0);
    }

    public static float toFloat(byte[] b, int offset) {
        return Float.intBitsToFloat(Bytes.toInt(b, offset));
    }

    public static byte[] toBytes(double d) {
        return Bytes.toBytes(Double.doubleToLongBits(d));
    }

    public static double toDouble(byte[] b) {
        return Bytes.toDouble(b, 0);
    }

    public static double toDouble(byte[] b, int offset) {
        return Double.longBitsToDouble(Bytes.toLong(b, offset));
    }

    public static byte[] toBytes(long l) {
        byte[] b = new byte[8];
        if (IS_HIGH) {
            b[7] = (byte)(l & 0xFFL);
            b[6] = (byte)(l >> 8 & 0xFFL);
            b[5] = (byte)(l >> 16 & 0xFFL);
            b[4] = (byte)(l >> 24 & 0xFFL);
            b[3] = (byte)(l >> 32 & 0xFFL);
            b[2] = (byte)(l >> 40 & 0xFFL);
            b[1] = (byte)(l >> 48 & 0xFFL);
            b[0] = (byte)(l >> 56 & 0xFFL);
        } else {
            b[0] = (byte)(l & 0xFFL);
            b[1] = (byte)(l >> 8 & 0xFFL);
            b[2] = (byte)(l >> 16 & 0xFFL);
            b[3] = (byte)(l >> 24 & 0xFFL);
            b[4] = (byte)(l >> 32 & 0xFFL);
            b[5] = (byte)(l >> 40 & 0xFFL);
            b[6] = (byte)(l >> 48 & 0xFFL);
            b[7] = (byte)(l >> 56 & 0xFFL);
        }
        return b;
    }

    public static long toLong(byte[] b) {
        return Bytes.toLong(b, 0);
    }

    public static long toLong(byte[] b, boolean high) {
        return Bytes.toLong(b, 0, high);
    }

    public static long toLong(byte[] b, int offset) {
        return Bytes.toLong(b, offset, IS_HIGH);
    }

    public static long toLong(byte[] b, int offset, boolean high) {
        long l = 0L;
        if (high) {
            l = b[offset + 0] & 0xFF;
            l = l << 8 | (long)(b[offset + 1] & 0xFF);
            l = l << 8 | (long)(b[offset + 2] & 0xFF);
            l = l << 8 | (long)(b[offset + 3] & 0xFF);
            l = l << 8 | (long)(b[offset + 4] & 0xFF);
            l = l << 8 | (long)(b[offset + 5] & 0xFF);
            l = l << 8 | (long)(b[offset + 6] & 0xFF);
            l = l << 8 | (long)(b[offset + 7] & 0xFF);
        } else {
            l = b[offset + 7] & 0xFF;
            l = l << 8 | (long)(b[offset + 6] & 0xFF);
            l = l << 8 | (long)(b[offset + 5] & 0xFF);
            l = l << 8 | (long)(b[offset + 4] & 0xFF);
            l = l << 8 | (long)(b[offset + 3] & 0xFF);
            l = l << 8 | (long)(b[offset + 2] & 0xFF);
            l = l << 8 | (long)(b[offset + 1] & 0xFF);
            l = l << 8 | (long)(b[offset + 0] & 0xFF);
        }
        return l;
    }

    public static byte[] toBytes(String s) {
        return Bytes.toBytes(s, false);
    }

    public static byte[] toBytes(String s, boolean is) {
        byte[] b = StringUtil.toBytes(s);
        if (is) {
            short size = W.C.toShort(b.length);
            return size == 0 ? Bytes.toBytes(size) : Bytes.toBytes(size, b);
        }
        return b;
    }

    public static String toString(byte[] b) {
        return Bytes.toString(b, 0);
    }

    public static String toString(byte[] b, int offset) {
        return Bytes.toString(b, offset, false);
    }

    public static String toString(byte[] b, int offset, boolean is) {
        return StringUtil.toString(is ? Bytes.copy(b, offset + 2, offset + 2 + Bytes.toShort(b, offset)) : Bytes.copy(b, offset, b.length));
    }

    public static byte[] copy(byte[] b) {
        return Bytes.copy(b, b.length);
    }

    public static byte[] copy(byte[] b, int len) {
        return Arrays.copyOf(b, len);
    }

    public static byte[] copy(byte[] b, int offset, int len) {
        return U.E.isEmpty(b) || offset == 0 && b.length == len ? b : Arrays.copyOfRange(b, offset, len);
    }

    public static ByteArray toBean(ByteArray array, byte[] b) {
        return Bytes.toBean(array, b, 0, b.length);
    }

    public static ByteArray toBean(ByteArray array, byte[] b, int offset) {
        return Bytes.toBean(array, b, offset, b.length);
    }

    public static ByteArray toBean(ByteArray array, byte[] b, int offset, int len) {
        return array.array(Bytes.copy(b, offset, len));
    }

    public static <B> B toBinary(byte[] b, Class<B> c) {
        B binary = ClassUtil.newInstance(c, new Class[0]);
        List<Field> fields = BeanUtil.getFields(c);
        int offset = 0;
        for (Field field : fields) {
            if (b.length <= offset) break;
            if (field.isSynthetic()) continue;
            Class<ByteArray> type = field.getType();
            if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                BeanUtil.setFieldValue(binary, field, (Object)Bytes.toInt(b, offset));
                offset += 4;
                continue;
            }
            if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                BeanUtil.setFieldValue(binary, field, (Object)Bytes.toLong(b, offset));
                offset += 8;
                continue;
            }
            if (type.equals(Double.class) || type.equals(Double.TYPE)) {
                BeanUtil.setFieldValue(binary, field, (Object)Bytes.toDouble(b, offset));
                offset += 8;
                continue;
            }
            if (type.equals(Float.class) || type.equals(Float.TYPE)) {
                BeanUtil.setFieldValue(binary, field, (Object)Float.valueOf(Bytes.toFloat(b, offset)));
                offset += 4;
                continue;
            }
            if (type.equals(Short.class) || type.equals(Short.TYPE)) {
                BeanUtil.setFieldValue(binary, field, (Object)Bytes.toShort(b, offset));
                offset += 2;
                continue;
            }
            if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
                BeanUtil.setFieldValue(binary, field, (Object)Bytes.toByte(b, offset));
                ++offset;
                continue;
            }
            if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                BeanUtil.setFieldValue(binary, field, (Object)Bytes.toBoolean(b, offset));
                ++offset;
                continue;
            }
            if (type.equals(String.class)) {
                String s = Bytes.toString(b, offset);
                BeanUtil.setFieldValue(binary, field, (Object)s);
                offset += Bytes.toShort(b, offset) + 2;
                continue;
            }
            if (type.isAssignableFrom(ByteArray.class)) {
                ByteArray bean = Bytes.toBean((ByteArray)ClassUtil.newInstance(type, new Class[0]), b, offset);
                BeanUtil.setFieldValue(binary, field, (Object)bean);
                offset += bean.array().length;
                continue;
            }
            if (!type.equals(byte[].class)) continue;
            byte[] t = Bytes.copy(b, offset, b.length);
            BeanUtil.setFieldValue(binary, field, (Object)t);
            offset += t.length;
        }
        return binary;
    }

    public static byte[] add(byte[] ... bs) {
        if (U.E.isNotEmpty(bs)) {
            int len = 0;
            for (int i = 0; i < bs.length; ++i) {
                len += bs[i].length;
            }
            byte[] b = new byte[len];
            byte[] d = null;
            int pos = 0;
            for (int i = 0; i < bs.length; ++i) {
                d = bs[i];
                System.arraycopy(d, 0, b, pos, d.length);
                pos += d.length;
            }
            return b;
        }
        return ArrayConstants.BYTES_EMPTY;
    }
}

