/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.lang;

import com.weicoder.common.interfaces.CallbackList;
import com.weicoder.common.interfaces.CallbackVoid;
import com.weicoder.common.queue.AsynQueue;
import com.weicoder.common.queue.AsynQueueList;
import com.weicoder.common.queue.OnlyQueue;
import com.weicoder.common.util.MathUtil;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class Queues {
    public static <E> ConcurrentLinkedQueue<E> newConcurrentQueue() {
        return new ConcurrentLinkedQueue();
    }

    public static <E> LinkedBlockingQueue<E> newLinkedBlockingQueue() {
        return new LinkedBlockingQueue();
    }

    public static <E> OnlyQueue<E> newOnlyQueue() {
        return new OnlyQueue();
    }

    public static <E> AsynQueue<E> newAsynQueue(CallbackVoid<E> callback, long time) {
        return Queues.newAsynQueue(Queues.newLinkedBlockingQueue(), callback, time);
    }

    public static <E> AsynQueue<E> newAsynQueue(CallbackVoid<E> callback, int time) {
        return Queues.newAsynQueue(Queues.newLinkedBlockingQueue(), callback, MathUtil.multiply(time, 1000).longValue());
    }

    public static <E> AsynQueue<E> newAsynQueue(Queue<E> queue, CallbackVoid<E> callback, long time) {
        return new AsynQueue<E>(queue, callback, time);
    }

    public static <E> AsynQueue<E> newAsynQueue(Queue<E> queue, CallbackVoid<E> callback, int time) {
        return Queues.newAsynQueue(queue, callback, MathUtil.multiply(time, 1000).longValue());
    }

    public static <E> AsynQueueList<E> newAsynQueueList(CallbackList<E> callback, long time) {
        return Queues.newAsynQueueList(Queues.newConcurrentQueue(), callback, time);
    }

    public static <E> AsynQueueList<E> newAsynQueueList(Queue<E> queue, CallbackList<E> callback, long time) {
        return new AsynQueueList<E>(queue, callback, time);
    }

    public static <E> AsynQueueList<E> newAsynQueueList(CallbackList<E> callback, int time) {
        return Queues.newAsynQueueList(Queues.newConcurrentQueue(), callback, time);
    }

    public static <E> AsynQueueList<E> newAsynQueueList(Queue<E> queue, CallbackList<E> callback, int time) {
        return Queues.newAsynQueueList(queue, callback, MathUtil.multiply(time, 1000).longValue());
    }
}

