/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.params;

import com.weicoder.common.U;
import com.weicoder.common.W;
import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.constants.SystemConstants;
import com.weicoder.common.lang.Sets;
import java.util.Set;

public final class CommonParams {
    public static final String LOG_CLASS = W.P.getString("log.class", "com.weicoder.log4j.Log4j2");
    public static final int IO_BUFFERSIZE = W.P.getInt("io.buffer", 0x100000);
    public static final String IO_MODE = W.P.getString("io.mode", "nio");
    public static final String ENCODING = W.P.getString("encoding", "UTF-8");
    public static final String DATE_FORMAT = W.P.getString("date.format", "yyyy-MM-dd HH:mm:ss");
    public static final String BYTES = W.P.getString("bytes", "high");
    public static final String ENCRYPT_KEY = W.P.getString("encrypt.key", "www.weicoder.com");
    public static final String ENCRYPT_ALGO = W.P.getString("encrypt.algo", "AES");
    public static final String ENCRYPT_DIGEST = W.P.getString("encrypt.digest", "SHA-1");
    public static final String[] IPS = W.P.getStringArray("ips", ArrayConstants.STRING_EMPTY);
    public static final String TOKEN_KEY = W.P.getString("token.key");
    public static final int TOKEN_LENGHT = W.P.getInt("token.lenght", 8);
    public static final short TOKEN_SIGN = W.P.getShort("token.sign", (short)-128);
    public static final int TOKEN_EXPIRE = W.P.getInt("token.expire", 691200);
    public static final int LOGS_LEN = W.P.getInt("logs.len", 500);
    public static final Set<String> TOKEN_SERVERS = Sets.newSet(W.P.getStringArray("token.servers", ArrayConstants.STRING_EMPTY));
    public static final int HTTP_CONNECT_TIMEOUT = W.P.getInt("http.connect.timeout", 3000);
    public static final int HTTP_READ_TIMEOUT = W.P.getInt("http.read.timeout", 10000);
    public static final int PAGE_SIZE = W.P.getInt("page.size", 20);
    public static final char[] VERIFY_CODE = W.P.getString("verify.code", "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ").toCharArray();
    public static final int VERIFY_LENGTH = W.P.getInt("verify.length", 4);
    public static final boolean MAIN = W.P.getBoolean("main", true);
    private static final String DEFAULT_PACKAGES = "com.weicoder";
    public static final String PACKAGES = CommonParams.getPackages("");
    public static final String[] CLASS_NAMES = W.P.getStringArray("class.names", new String[]{"Action", "Service", "Dao", "Job", "Cache", "Impl", "Http"});

    public static boolean power(String name) {
        return W.P.getBoolean("init.power." + name, true);
    }

    public static String getPackages(String name) {
        String pack = W.P.getString(W.P.getKey("", name, "packages"));
        if (U.E.isEmpty(pack) || DEFAULT_PACKAGES.equals(pack)) {
            return DEFAULT_PACKAGES;
        }
        return "com.weicoder," + pack;
    }

    public static int getScheduledPool(String name) {
        return W.P.getInt(W.P.getKey("scheduled", name, "pool"), SystemConstants.CPU_NUM);
    }

    public static boolean getScheduledDaemon(String name) {
        return W.P.getBoolean(W.P.getKey("scheduled", name, "daemon"), true);
    }

    public static int getExecutorPool(String name) {
        return W.P.getInt(W.P.getKey("executor", name, "pool"), SystemConstants.CPU_NUM);
    }

    public static boolean getExecutorDaemon(String name) {
        return W.P.getBoolean(W.P.getKey("executor", name, "daemon"), true);
    }

    private CommonParams() {
    }
}

