/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.socket;

import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.io.AsynChannelUtil;
import com.weicoder.common.io.ChannelUtil;
import com.weicoder.common.io.IOUtil;
import com.weicoder.common.log.Logs;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;

public final class TcpClient {
    public static void send(String host, int port, byte[] data) {
        TcpClient.send(host, port, data, false);
    }

    public static byte[] send(String host, int port, byte[] data, boolean read) {
        return TcpClient.send(new InetSocketAddress(host, port), data, read);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] send(InetSocketAddress addr, byte[] data, boolean read) {
        try (Socket socket = new Socket();){
            socket.connect(addr);
            IOUtil.write(socket.getOutputStream(), data, false);
            if (!read) return ArrayConstants.BYTES_EMPTY;
            socket.shutdownOutput();
            byte[] byArray = IOUtil.read(socket.getInputStream(), false);
            return byArray;
        }
        catch (IOException e) {
            Logs.error(e);
        }
        return ArrayConstants.BYTES_EMPTY;
    }

    public static void write(String host, int port, byte[] data) {
        TcpClient.write(host, port, data, false);
    }

    public static byte[] write(String host, int port, byte[] data, boolean read) {
        return TcpClient.write(new InetSocketAddress(host, port), data, read);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] write(InetSocketAddress addr, byte[] data, boolean read) {
        try (SocketChannel socket = SocketChannel.open();){
            socket.connect(addr);
            ChannelUtil.write((WritableByteChannel)socket, data, false);
            if (!read) return ArrayConstants.BYTES_EMPTY;
            socket.shutdownOutput();
            byte[] byArray = ChannelUtil.read(socket, false);
            return byArray;
        }
        catch (IOException e) {
            Logs.error(e);
        }
        return ArrayConstants.BYTES_EMPTY;
    }

    public static void asyn(String host, int port, byte[] data) {
        TcpClient.asyn(host, port, data, false);
    }

    public static byte[] asyn(String host, int port, byte[] data, boolean read) {
        return TcpClient.asyn(new InetSocketAddress(host, port), data, read);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] asyn(InetSocketAddress addr, byte[] data, boolean read) {
        try (AsynchronousSocketChannel socket = AsynchronousSocketChannel.open();){
            socket.connect(addr).get();
            AsynChannelUtil.write(socket, data, false);
            if (!read) return ArrayConstants.BYTES_EMPTY;
            socket.shutdownOutput();
            byte[] byArray = AsynChannelUtil.read(socket, false);
            return byArray;
        }
        catch (Exception e) {
            Logs.error(e);
        }
        return ArrayConstants.BYTES_EMPTY;
    }

    private TcpClient() {
    }
}

