/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.util;

import com.weicoder.common.U;
import com.weicoder.common.W;
import com.weicoder.common.annotation.Ioc;
import com.weicoder.common.lang.Lists;
import com.weicoder.common.log.Logs;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.ResourceUtil;
import com.weicoder.common.util.StringUtil;
import jakarta.annotation.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;

public class ClassUtil {
    private static final Map<String, List<Class<?>>> PASSAGES = W.M.newMap();
    private static final Map<String, Class<?>> BEANS = W.M.newMap();
    private static final Map<Class<?>, Map<String, Class<?>>> CLASS_BEANS = W.M.newMap();
    private static final Map<Class<?>, Object> IOC_BEANS = W.M.newMap();
    private static final Map<Class<?>, List<Class<?>>> CLASSES = ClassUtil.init();

    public static <E> E ioc(Class<E> c) {
        return ClassUtil.ioc(ClassUtil.newInstance(c, new Class[0]));
    }

    public static <E> E ioc(Class<? extends E> c, Class<? extends E> def) {
        return (E)ClassUtil.ioc(c == null ? def : c);
    }

    public static <E> E ioc(E o) {
        if (o != null) {
            U.B.getFields(o.getClass()).forEach(f -> {
                Class<?> type = f.getType();
                if (!ClassUtil.isBaseType(type) && (f.isAnnotationPresent(Resource.class) || f.isAnnotationPresent(Ioc.class))) {
                    Class<?> val = null;
                    if (IOC_BEANS.containsKey(type)) {
                        val = IOC_BEANS.get(type);
                    } else if (type.isInterface() || type.isAnnotation()) {
                        val = ClassUtil.ioc(ClassUtil.from(type));
                        IOC_BEANS.put(type, val);
                    } else {
                        val = ClassUtil.ioc(type);
                        IOC_BEANS.put(type, val);
                    }
                    U.B.setFieldValue(o, f, (Object)val);
                }
            });
        }
        return o;
    }

    public static <E> List<Class<E>> pack(String name, Class<E> cls) {
        List list = W.L.newList();
        PASSAGES.get(name).forEach(c -> {
            if (c.isAssignableFrom(cls) || c.isAnnotationPresent(cls)) {
                list.add((Class)c);
            }
        });
        return list;
    }

    public static <E> Class<E> bean(Class<E> c, String name) {
        try {
            return CLASS_BEANS.get(c).get(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <E> Class<E> bean(String name) {
        return BEANS.get(name);
    }

    public static <E> List<Class<E>> list(Class<E> c) {
        return W.L.newList((Collection)CLASSES.get(c)).stream().map(o -> o).collect(Collectors.toList());
    }

    public static <E> Class<E> from(Class<E> c) {
        return ClassUtil.from(c, W.L.size(CLASSES.get(c)));
    }

    public static <E> Class<E> from(Class<E> c, Class<? extends E> def) {
        List<Class<?>> list = CLASSES.get(c);
        if (U.E.isNotEmpty(list) && def != null) {
            for (Class<?> cs : list) {
                if (cs.equals(def)) continue;
                return cs;
            }
        }
        return def == null ? list.get(0) : def;
    }

    public static <E> Class<E> from(Class<E> c, int i) {
        return W.L.get(CLASSES.get(c), i);
    }

    public static Object empty(Class<?> cls) {
        if (Number.class.isAssignableFrom(cls)) {
            return 0;
        }
        return ClassUtil.newInstance(cls, new Class[0]);
    }

    public static boolean isBaseType(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return true;
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return true;
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return true;
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return true;
        }
        if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
            return true;
        }
        if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
            return true;
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return true;
        }
        if (clazz.equals(Character.class) || clazz.equals(Character.TYPE)) {
            return true;
        }
        return clazz.equals(String.class) || clazz.equals(BigDecimal.class);
    }

    public static Class<?> getGenericClass(Class<?> clazz, int index) {
        try {
            return ClassUtil.getGenericClass(clazz)[index];
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class<?>[] getGenericClass(Class<?> clazz) {
        Type[] type;
        Class<?>[] gc = ClassUtil.getGenericClass(clazz.getGenericSuperclass());
        if (gc == null && U.E.isNotEmpty(type = clazz.getGenericInterfaces())) {
            Type t;
            Type[] typeArray = type;
            int n = typeArray.length;
            for (int i = 0; i < n && (gc = ClassUtil.getGenericClass(t = typeArray[i])) == null; ++i) {
            }
        }
        return gc;
    }

    public static Class<?>[] getGenericClass(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)type).getActualTypeArguments();
            Class[] clazzs = new Class[types.length];
            for (int i = 0; i < types.length; ++i) {
                clazzs[i] = (Class)types[i];
            }
            return clazzs;
        }
        return null;
    }

    public static Class<?> getGenericClass(Type type, int index) {
        try {
            return ClassUtil.getGenericClass(type)[index];
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class<?> loadClass(String className) {
        Class<?> theClass = null;
        try {
            theClass = Class.forName(className);
        }
        catch (ClassNotFoundException e1) {
            try {
                theClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e2) {
                try {
                    theClass = ClassUtil.class.getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e3) {
                    return null;
                }
            }
        }
        return theClass;
    }

    public static <E> E newProxyInstance(Class<E> cls, InvocationHandler handler) {
        return (E)Proxy.newProxyInstance(ClassUtil.getClassLoader(), new Class[]{cls}, handler);
    }

    public static Class<?> forName(String className) {
        try {
            if (U.E.isEmpty(className)) {
                return null;
            }
            if ("byte".equals(className)) {
                return Byte.TYPE;
            }
            if ("short".equals(className)) {
                return Short.TYPE;
            }
            if ("int".equals(className)) {
                return Integer.TYPE;
            }
            if ("long".equals(className)) {
                return Long.TYPE;
            }
            if ("float".equals(className)) {
                return Float.TYPE;
            }
            if ("double".equals(className)) {
                return Double.TYPE;
            }
            if ("boolean".equals(className)) {
                return Boolean.TYPE;
            }
            if ("char".equals(className)) {
                return Character.TYPE;
            }
            return Class.forName(className);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object newInstance(String className, Class<?> ... parameterTypes) {
        try {
            if (U.E.isEmpty(className)) {
                return null;
            }
            Class<?> c = ClassUtil.forName(className);
            return c == null || c.isInterface() ? null : c.getDeclaredConstructor(parameterTypes).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <E> E newInstance(String className, E obj) {
        Object o = ClassUtil.newInstance(className);
        return (E)(o == null ? obj : o);
    }

    public static <T> T newInstance(Class<T> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz == null || clazz.isInterface() ? null : (T)clazz.getConstructor(parameterTypes).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Logs.error(e);
            return null;
        }
    }

    public static Object newInstance(String className) {
        return ClassUtil.newInstance(ClassUtil.forName(className), new Class[0]);
    }

    public static List<Method> getPublicMethod(Class<?> c) {
        List<Method> methods = Lists.newList();
        for (Method m : c.getDeclaredMethods()) {
            if (!Modifier.isPublic(m.getModifiers())) continue;
            methods.add(m);
        }
        return methods;
    }

    public static List<Class<?>> getPackageClasses() {
        return ClassUtil.getPackageClasses(CommonParams.PACKAGES);
    }

    public static List<Class<?>> getPackageClasses(String packageName) {
        List<Class<?>> classes = Lists.newList();
        for (String path : StringUtil.split(packageName, ",")) {
            String p = StringUtil.replace(path, ".", "/");
            ResourceUtil.getResources(p).forEach(url -> {
                for (String string : ClassUtil.getClasses(url.getPath(), p)) {
                    if (string.endsWith(".class")) {
                        try {
                            void var5_10;
                            String string3 = p + "." + StringUtil.subString(string, 0, string.length() - 6);
                            string3 = StringUtil.replace(string3, "/", ".");
                            if (string3.startsWith(".")) {
                                String string4 = StringUtil.subString(string3, 1);
                            }
                            classes.add(Class.forName((String)var5_10, false, ClassUtil.getClassLoader()));
                        }
                        catch (ClassNotFoundException e) {
                            Logs.error(e);
                        }
                        continue;
                    }
                    classes.addAll(ClassUtil.getPackageClasses((String)(U.E.isEmpty(p) ? string : path + "/" + string)));
                }
            });
        }
        return classes;
    }

    public static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl == null ? ClassLoader.getSystemClassLoader() : cl;
    }

    private static List<String> getClasses(String name, String packageName) {
        File path = new File(name);
        if (path.isDirectory()) {
            return Lists.newList(path.list());
        }
        if (name.indexOf(".jar!") > -1) {
            return ClassUtil.getClassesFromJARFile(StringUtil.subString(name, "file:/", "!"), packageName + "/");
        }
        return Lists.emptyList();
    }

    private static List<String> getClassesFromJARFile(String jar, String name) {
        if (((String)jar).indexOf(":") == -1) {
            jar = "/" + (String)jar;
        }
        List<String> list = Lists.newList();
        try (JarInputStream jarFile = new JarInputStream(new FileInputStream((String)jar));){
            JarEntry jarEntry = null;
            while ((jarEntry = jarFile.getNextJarEntry()) != null) {
                String className = jarEntry.getName();
                if (className.indexOf(name) <= -1 || className.equals(name)) continue;
                list.add(StringUtil.subString(className, name));
            }
        }
        catch (IOException e) {
            Logs.error(e);
        }
        return list;
    }

    public static List<Class<?>> getInterfaces(Class<?> c) {
        List<Class<?>> list = W.L.newList();
        if (c == null) {
            return list;
        }
        if (!Object.class.equals(c) && !Object.class.equals(c.getSuperclass())) {
            list.addAll(ClassUtil.getInterfaces(c.getSuperclass()));
        }
        for (Class<?> i : c.getInterfaces()) {
            list.add(i);
        }
        return list;
    }

    public static List<Annotation> getAnnotations(Class<?> c) {
        List<Annotation> list = W.L.newList();
        for (Annotation a : c.getAnnotations()) {
            list.add(a);
        }
        return list;
    }

    private static Map<Class<?>, List<Class<?>>> init() {
        Map<Class<?>, List<Class<?>>> map = W.M.newMap();
        U.C.getPackageClasses().forEach(c -> {
            ClassUtil.getInterfaces(c).forEach(i -> {
                if (Modifier.isPublic(c.getModifiers()) && !Modifier.isAbstract(c.getModifiers())) {
                    W.M.getList(map, i).add(c);
                    W.M.getMap(CLASS_BEANS, i).put(U.S.convert(c.getSimpleName(), "Impl", i.getSimpleName()), (Class<?>)c);
                }
            });
            for (Annotation a : c.getAnnotations()) {
                W.M.getList(map, a.annotationType()).add(c);
            }
            W.M.getList(PASSAGES, c.getPackage().getName()).add((Class<?>)c);
            BEANS.put(U.S.convert(c.getSimpleName(), CommonParams.CLASS_NAMES), (Class<?>)c);
        });
        return map;
    }
}

